/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.management.ObjectName;
import management.J2EEApplication;
import management.J2EEResource;
import management.J2EEServer;
import management.Node;
import management.Port;
import org.jboss.jmx.interfaces.JMXConnector;
import org.jboss.management.JBossJ2EEManagedObject;

public class JBossJ2EEServer
extends JBossJ2EEManagedObject
implements J2EEServer {
    private Collection mApplications = new ArrayList();
    private Collection mResources = new ArrayList();
    private Collection mNodes = new ArrayList();
    private Collection mPorts = new ArrayList();
    private JMXConnector mServerConnector;

    public JBossJ2EEServer(String string, JMXConnector jMXConnector) {
        super(string);
        this.mServerConnector = jMXConnector;
    }

    public J2EEApplication[] getApplications() {
        return this.mApplications.toArray(new J2EEApplication[0]);
    }

    public Node[] getNodes() {
        return this.mNodes.toArray(new Node[0]);
    }

    public Port[] getPorts() {
        return this.mPorts.toArray(new Port[0]);
    }

    public J2EEResource[] getResources() {
        return this.mApplications.toArray(new J2EEResource[0]);
    }

    public void init(J2EEApplication[] j2EEApplicationArray, Node[] nodeArray, Port[] portArray, J2EEResource[] j2EEResourceArray) {
        this.setApplications(j2EEApplicationArray);
        this.setNodes(nodeArray);
        this.setPorts(portArray);
        this.setResources(j2EEResourceArray);
    }

    public void refresh() {
        try {
            Collection collection;
            Collection collection2;
            Collection collection3;
            ObjectName objectName = new ObjectName("Management", "service", "Collector");
            this.mServerConnector.invoke(objectName, "refreshNow", new Object[0], new String[0]);
            this.mApplications = collection3 = (Collection)this.mServerConnector.getAttribute(objectName, "Applications");
            this.mResources = collection2 = (Collection)this.mServerConnector.getAttribute(objectName, "Resources");
            this.mNodes = collection = (Collection)this.mServerConnector.getAttribute(objectName, "Nodes");
            System.out.println("Refresh() created: " + this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setApplications(J2EEApplication[] j2EEApplicationArray) {
        this.mApplications = j2EEApplicationArray == null ? new ArrayList() : new ArrayList<J2EEApplication>(Arrays.asList(j2EEApplicationArray));
    }

    public void setNodes(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            throw new InvalidParameterException("There must always be at least one Node defined");
        }
        this.mNodes = new ArrayList<Node>(Arrays.asList(nodeArray));
    }

    public void setPorts(Port[] portArray) {
        if (portArray == null || portArray.length == 0) {
            throw new InvalidParameterException("There must always be at least one Port defined");
        }
        this.mPorts = new ArrayList<Port>(Arrays.asList(portArray));
    }

    public void setResources(J2EEResource[] j2EEResourceArray) {
        this.mResources = j2EEResourceArray == null ? new ArrayList() : new ArrayList<J2EEResource>(Arrays.asList(j2EEResourceArray));
    }

    public String toString() {
        return "JBossJ2EEServer[ applications: " + this.mApplications + ", resources: " + this.mResources + ", ports: " + Arrays.asList(this.getPorts()) + ", nodes: " + Arrays.asList(this.getNodes()) + " ]";
    }
}

