/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import management.J2EEManagement;
import org.jboss.management.JBossJ2EEManagement;
import org.jboss.management.JBossManagementMBean;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.util.ServiceMBeanSupport;

public class JBossManagement
extends ServiceMBeanSupport
implements JBossManagementMBean {
    public static String JNDI_NAME = "j2eemanagement:domain";
    public static String JMX_NAME = "j2eemanagement";
    private MBeanServer mServer;
    private JBossJ2EEManagement mJ2EEManagement;
    private String mName;
    private URL mJNDIPropertiesFileURL;
    static /* synthetic */ Class class$org$jboss$management$JBossJ2EEManagement;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public JBossManagement() {
        this.mName = null;
    }

    public JBossManagement(String string) {
        this.mName = string;
    }

    public JBossManagement(String string, String string2) throws InvalidParameterException {
        this.mName = string;
        this.setJNDIPropertiesFileURL(string2);
    }

    private void bind(JBossJ2EEManagement jBossJ2EEManagement) throws NamingException {
        Object object;
        Context context = new InitialContext();
        String string = this.getJNDIName();
        NonSerializableFactory.bind((String)string, (Object)jBossJ2EEManagement);
        Name name = context.getNameParser("").parse(string);
        while (name.size() > 1) {
            object = name.get(0);
            try {
                context = (Context)context.lookup((String)object);
            }
            catch (NameNotFoundException nameNotFoundException) {
                context = context.createSubcontext((String)object);
            }
            name = name.getSuffix(1);
        }
        object = new StringRefAddr("nns", string);
        Reference reference = new Reference((class$org$jboss$management$JBossJ2EEManagement != null ? class$org$jboss$management$JBossJ2EEManagement : (class$org$jboss$management$JBossJ2EEManagement = JBossManagement.class$("org.jboss.management.JBossJ2EEManagement"))).getName(), (RefAddr)object, (class$org$jboss$naming$NonSerializableFactory != null ? class$org$jboss$naming$NonSerializableFactory : (class$org$jboss$naming$NonSerializableFactory = JBossManagement.class$("org.jboss.naming.NonSerializableFactory"))).getName(), null);
        context.bind(name.get(0), (Object)reference);
        this.log.log("JBoss Management Service '" + this.getJNDIName() + "' bound to " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public J2EEManagement getJ2EEManagement() {
        return this.mJ2EEManagement;
    }

    public String getJNDIName() {
        if (this.mName != null) {
            return String.valueOf(JMX_NAME) + ":" + this.mName;
        }
        return JMX_NAME;
    }

    public String getName() {
        return "JBoss J2EE Management MBean";
    }

    public ObjectName getObjectName(MBeanServer mBeanServer, ObjectName objectName) throws MalformedObjectNameException {
        this.mServer = mBeanServer;
        return new ObjectName("J2EEManagement:name=Main");
    }

    protected void initService() throws Exception {
        Properties properties = null;
        if (this.mJNDIPropertiesFileURL != null) {
            properties.load(this.mJNDIPropertiesFileURL.openStream());
        }
        this.mJ2EEManagement = new JBossJ2EEManagement(this.mName, this.mServer, properties);
    }

    public void refresh() {
        this.mJ2EEManagement.refresh();
    }

    public void setJNDIPropertiesFileURL(String string) throws InvalidParameterException {
        try {
            this.mJNDIPropertiesFileURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidParameterException("Given JNDI Properties File URL is invalid");
        }
    }

    protected void startService() throws Exception {
        this.bind(this.mJ2EEManagement);
        this.refresh();
    }

    protected void stopService() {
        try {
            this.unbind();
        }
        catch (Exception exception) {
            this.log.exception((Throwable)exception);
        }
    }

    private void unbind() throws NamingException {
        String string = this.getJNDIName();
        new InitialContext().unbind(string);
        NonSerializableFactory.unbind((String)string);
        this.log.log("JBoss Management service '" + string + "' removed from JNDI");
    }
}

