/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jca;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.log4j.Category;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;
import tyrex.resource.Resource;
import tyrex.resource.ResourceConfig;
import tyrex.resource.ResourceException;
import tyrex.resource.jca.ConnectionPool;
import tyrex.resource.jca.ConnectorLoader;
import tyrex.resource.jca.dd.DDConfigProperty;
import tyrex.resource.jca.dd.DDConnector;
import tyrex.resource.jca.dd.DDResourceAdapter;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TyrexTransactionManager;
import tyrex.util.Logger;

public class Connector
extends ResourceConfig {
    private static final String DEPLOYMENT_DESCRIPTOR_PATH = "META-INF/ra.xml";
    private static final Class[] EMPTY_CLASSES = new Class[0];
    private Resource _resource;
    private ConnectorLoader _loader;
    private MissingConfigurationProperty _missing;
    static /* synthetic */ Class class$tyrex$resource$jca$Connector;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;

    public void setFactory(Object object) {
        if (null != object) {
            MissingConfigurationProperty missingConfigurationProperty = this._missing;
            while (null != missingConfigurationProperty) {
                Object object2;
                try {
                    object2 = missingConfigurationProperty._configPropertyGetMethod.invoke(object, (Object[])EMPTY_CLASSES);
                }
                catch (Exception exception) {
                    Logger.resource.error((Object)("Error in connector configuration '" + this.getName() + "'. Could not check that configuration property: '" + missingConfigurationProperty._configProperty.getConfigPropertyName() + "' was set."), (Throwable)exception);
                    throw new IllegalStateException("Could not check that configuration property: '" + missingConfigurationProperty._configProperty.getConfigPropertyName() + "' was set.");
                }
                if (null == missingConfigurationProperty._defaultValue && null == object2 || null != missingConfigurationProperty._defaultValue && missingConfigurationProperty._defaultValue.equals(object2)) {
                    Logger.resource.error((Object)("Error in connector configuration '" + this.getName() + "'. The configuration property: '" + missingConfigurationProperty._configProperty.getConfigPropertyName() + "' was not set."));
                    throw new IllegalStateException("Configuration property '" + missingConfigurationProperty._configProperty.getConfigPropertyName() + "' was not set.");
                }
                missingConfigurationProperty = missingConfigurationProperty._next;
            }
        }
        super.setFactory(object);
    }

    public Object createFactory() throws ResourceException {
        try {
            return this.createFactory_();
        }
        catch (ResourceException resourceException) {
            Logger.resource.error((Object)("Error in connector configuration '" + this.getName() + "'"), (Throwable)resourceException);
            throw resourceException;
        }
    }

    private Object createFactory_() throws ResourceException {
        DDResourceAdapter dDResourceAdapter;
        DDConnector dDConnector;
        StringBuffer stringBuffer;
        URL[] uRLArray;
        String string = this._name;
        if (string == null || string.trim().length() == 0) {
            throw new ResourceException("The configuration element is missing the resource manager name");
        }
        String string2 = this.trim(this._jar);
        if (string2 == null || string2.length() == 0) {
            throw new ResourceException("The configuration element is missing the JAR name");
        }
        File file = null;
        try {
            file = new File(string2);
            URL uRL = file.exists() && file.canRead() ? file.toURL() : new URL(string2);
            String string3 = this._paths;
            if (string3 != null && string3.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",; ");
                uRLArray = new URL[stringTokenizer.countTokens() + 1];
                uRLArray[0] = uRL;
                int n = 1;
                while (n < uRLArray.length) {
                    string2 = stringTokenizer.nextToken();
                    file = new File(string2);
                    uRLArray[n] = file.exists() && file.canRead() ? file.toURL() : new URL(string2);
                    ++n;
                }
            } else {
                uRLArray = new URL[]{uRL};
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (null != file) {
                Logger.resource.error((Object)("Could not create url for connector file: '" + file + "'. File may not exist."));
            }
            throw new ResourceException(malformedURLException);
        }
        try {
            stringBuffer = new StringBuffer("Loading connector " + string + " from " + this._jar);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new InputSource((class$tyrex$resource$jca$Connector == null ? (class$tyrex$resource$jca$Connector = Connector.class$("tyrex.resource.jca.Connector")) : class$tyrex$resource$jca$Connector).getResourceAsStream("mapping.xml")));
            dDConnector = (DDConnector)new Unmarshaller(mapping).unmarshal(new InputSource(this.getRAInputStream(uRLArray[0])));
        }
        catch (IOException iOException) {
            throw new ResourceException(iOException);
        }
        catch (ValidationException validationException) {
            throw new ResourceException((Exception)((Object)validationException));
        }
        catch (MarshalException marshalException) {
            throw new ResourceException((Exception)((Object)marshalException));
        }
        catch (MappingException mappingException) {
            throw new ResourceException((Exception)((Object)mappingException));
        }
        if (dDConnector.getDisplayName() != null) {
            stringBuffer.append("  ").append(dDConnector.getDisplayName());
        }
        if (dDConnector.getVendorName() != null) {
            stringBuffer.append("  ").append(dDConnector.getVendorName());
        }
        if (dDConnector.getVersion() != null) {
            stringBuffer.append("  ").append(dDConnector.getVersion());
        }
        if ((dDResourceAdapter = dDConnector.getResourceadapter()) == null) {
            throw new ResourceException("Connector " + string + " missing resource adapter deployment descriptor");
        }
        String string4 = this.trim(dDResourceAdapter.getTransactionSupport());
        try {
            this._loader = new ConnectorLoader(new URLClassLoader(uRLArray, this.getClass().getClassLoader()), this.trim(dDResourceAdapter.getManagedconnectionfactoryClass()), this.trim(dDResourceAdapter.getConnectionfactoryInterface()), this.trim(dDResourceAdapter.getConnectionInterface()), "xa_transaction".equals(string4), "local_transaction".equals(string4));
            this.configureManagedConnectionFactory(this._loader.getConfigFactory(), dDResourceAdapter.getConfigProperty());
        }
        catch (Exception exception) {
            throw new ResourceException(exception);
        }
        return this._loader.getConfigFactory();
    }

    public synchronized Resource createResource(TransactionDomain transactionDomain) throws ResourceException {
        String string = this._name;
        if (string == null || string.trim().length() == 0) {
            throw new ResourceException("The configuration element is missing the resource manager name");
        }
        if (transactionDomain == null) {
            throw new ResourceException("The configuration was not loaded from a transaction domain");
        }
        TyrexTransactionManager tyrexTransactionManager = (TyrexTransactionManager)transactionDomain.getTransactionManager();
        if (this._resource != null) {
            return this._resource;
        }
        ConnectorLoader connectorLoader = this._loader;
        if (connectorLoader == null) {
            throw new ResourceException("No connector configured");
        }
        try {
            this._resource = new ConnectionPool(string, super.getLimits(), connectorLoader, tyrexTransactionManager, Category.getInstance((String)(Logger.resource.getName() + "." + string)));
        }
        catch (Exception exception) {
            throw new ResourceException(exception);
        }
        return this._resource;
    }

    private InputStream getRAInputStream(URL uRL) throws IOException, ResourceException {
        try {
            String string;
            if (uRL.getProtocol().equals("file")) {
                JarFile jarFile = new JarFile(uRL.getFile(), true);
                JarEntry jarEntry = jarFile.getJarEntry(DEPLOYMENT_DESCRIPTOR_PATH);
                if (jarEntry == null) {
                    throw new ResourceException("The connector deployment descriptor is not found for " + uRL);
                }
                return jarFile.getInputStream(jarEntry);
            }
            URL uRL2 = uRL.getProtocol().equals("jar") ? ((string = uRL.getFile()).endsWith("!/") ? new URL("jar:" + uRL.getFile() + DEPLOYMENT_DESCRIPTOR_PATH) : new URL("jar:" + string.substring(0, string.lastIndexOf(33)) + "!/" + DEPLOYMENT_DESCRIPTOR_PATH)) : new URL("jar:" + uRL + "!/" + DEPLOYMENT_DESCRIPTOR_PATH);
            return uRL2.openStream();
        }
        catch (IOException iOException) {
            Logger.resource.error((Object)("Failed to extract connector ra.xml file for url " + uRL));
            throw iOException;
        }
    }

    private String trim(String string) {
        return null == string ? null : string.trim();
    }

    private void configureManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory, Vector vector) throws Exception {
        if (null != vector && !vector.isEmpty()) {
            Class[] classArray = new Class[1];
            Class[] classArray2 = new Class[1];
            Object[] objectArray = new Object[1];
            Class<?> clazz = managedConnectionFactory.getClass();
            DDConfigProperty dDConfigProperty = null;
            try {
                int n = vector.size();
                while (--n >= 0) {
                    Method method;
                    String string;
                    dDConfigProperty = (DDConfigProperty)vector.get(n);
                    String string2 = this.trim(dDConfigProperty.getConfigPropertyValue());
                    if (null != string2 && 0 != string2.length()) {
                        this.initConfigPropertyValue(this.trim(dDConfigProperty.getConfigPropertyType()), string2, classArray, classArray2, objectArray);
                        string = this.getConfigPropertySetMethodName(this.trim(dDConfigProperty.getConfigPropertyName()));
                        method = null;
                        try {
                            method = clazz.getMethod(string, classArray);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (null != classArray2[0]) {
                                method = clazz.getMethod(string, classArray2);
                            }
                            throw noSuchMethodException;
                        }
                        method.invoke((Object)managedConnectionFactory, objectArray);
                        continue;
                    }
                    try {
                        string = this.getConfigPropertyGetMethodName(this.trim(dDConfigProperty.getConfigPropertyName()));
                        method = clazz.getMethod(string, EMPTY_CLASSES);
                        MissingConfigurationProperty missingConfigurationProperty = new MissingConfigurationProperty(dDConfigProperty, method, method.invoke((Object)managedConnectionFactory, (Object[])EMPTY_CLASSES));
                        missingConfigurationProperty._next = this._missing;
                        this._missing = missingConfigurationProperty;
                    }
                    catch (Exception exception) {
                        Logger.resource.debug((Object)("Error in connector configuration '" + this.getName() + "'  - ignoring error with missing configuration property - name: '" + dDConfigProperty.getConfigPropertyName() + "' type: '" + dDConfigProperty.getConfigPropertyType() + "' value: '" + dDConfigProperty.getConfigPropertyValue() + "'"), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                if (null != dDConfigProperty) {
                    Logger.resource.error((Object)("Error in connector configuration '" + this.getName() + "'  - error with configuration property - name: '" + dDConfigProperty.getConfigPropertyName() + "' type: '" + dDConfigProperty.getConfigPropertyType() + "' value: '" + dDConfigProperty.getConfigPropertyValue() + "'"));
                }
                throw exception;
            }
        }
    }

    private String getConfigPropertySetMethodName(String string) {
        if (null == string || 0 == string.length()) {
            throw new IllegalArgumentException("The argument 'configPropertyName' is null or empty.");
        }
        return "set" + string;
    }

    private String getConfigPropertyGetMethodName(String string) {
        if (null == string || 0 == string.length()) {
            throw new IllegalArgumentException("The argument 'configPropertyName' is null or empty.");
        }
        return "get" + string;
    }

    private void initConfigPropertyValue(String string, String string2, Class[] classArray, Class[] classArray2, Object[] objectArray) throws ResourceException {
        if (null == string || 0 == string.length()) {
            throw new IllegalArgumentException("The argument 'configPropertyType' is null or empty.");
        }
        try {
            Class<?> clazz;
            classArray[0] = clazz = Class.forName(string);
            if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Connector.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                objectArray[0] = Boolean.valueOf(string2);
                classArray2[0] = Boolean.TYPE;
                return;
            }
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Connector.class$("java.lang.String")) : class$java$lang$String)) {
                objectArray[0] = string2;
                classArray2[0] = null;
                return;
            }
            if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = Connector.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                objectArray[0] = Integer.valueOf(string2);
                classArray2[0] = Integer.TYPE;
                return;
            }
            if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = Connector.class$("java.lang.Double")) : class$java$lang$Double)) {
                objectArray[0] = Double.valueOf(string2);
                classArray2[0] = Double.TYPE;
                return;
            }
            if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = Connector.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                objectArray[0] = Byte.valueOf(string2);
                classArray2[0] = Byte.TYPE;
                return;
            }
            if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = Connector.class$("java.lang.Short")) : class$java$lang$Short)) {
                objectArray[0] = Short.valueOf(string2);
                classArray2[0] = Short.TYPE;
                return;
            }
            if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = Connector.class$("java.lang.Long")) : class$java$lang$Long)) {
                objectArray[0] = Long.valueOf(string2);
                classArray2[0] = Long.TYPE;
                return;
            }
            if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = Connector.class$("java.lang.Float")) : class$java$lang$Float)) {
                objectArray[0] = Float.valueOf(string2);
                classArray2[0] = Float.TYPE;
                return;
            }
            if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = Connector.class$("java.lang.Character")) : class$java$lang$Character)) {
                if (1 != string2.length()) {
                    throw new ResourceException("The argument 'configPropertyValue' is not valid for a character - '" + string2 + "'");
                }
                objectArray[0] = new Character(string2.charAt(0));
                classArray2[0] = Character.TYPE;
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ResourceException("The argument 'configPropertyType' type is not valid - " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MissingConfigurationProperty {
        private final DDConfigProperty _configProperty;
        private final Method _configPropertyGetMethod;
        private final Object _defaultValue;
        private MissingConfigurationProperty _next;

        private MissingConfigurationProperty(DDConfigProperty dDConfigProperty, Method method, Object object) {
            this._configProperty = dDConfigProperty;
            this._configPropertyGetMethod = method;
            this._defaultValue = object;
            this._next = null;
        }
    }
}

