/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.ldap;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import tyrex.security.NamePasswordCredentials;
import tyrex.security.container.RoleCredentials;
import tyrex.security.container.helper.EmailPrincipal;
import tyrex.security.ldap.CommonNamePrincipal;
import tyrex.security.ldap.LDAPCredentials;
import tyrex.security.ldap.LDAPPrincipal;
import tyrex.security.ldap.LDAPRealm;
import tyrex.util.Logger;

public class LDAPLoginModule
implements LoginModule {
    public static final String OPTION_LDAP_URL = "ldap-url";
    public static final String OPTION_DN_MASK = "dn-mask";
    public static final String OPTION_ROLES_RDN = "roles-rdn";
    public static final String OPTION_REALM = "realm";
    public static final String OPTION_LOG_ERRORS = "log-errors";
    private static final String MODULE_NAME = "LDAPLoginModule";
    private Subject _subject;
    private LDAPRealm _realm;
    private Map _options;
    private LDAPCredentials _ldapCreds;
    private RoleCredentials _roleCreds;
    private Vector _princs = new Vector();
    static /* synthetic */ Class class$tyrex$security$ldap$LDAPCredentials;
    static /* synthetic */ Class class$tyrex$security$NamePasswordCredentials;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this._subject = subject;
        this._options = map2;
        String string = (String)this._options.get(OPTION_REALM);
        if (string == null) {
            string = "<default>";
        }
        Map map3 = map;
        synchronized (map3) {
            this._realm = (LDAPRealm)map.get(string);
            if (this._realm == null) {
                try {
                    this._realm = new LDAPRealm(string, (String)this._options.get(OPTION_LDAP_URL), (String)this._options.get(OPTION_DN_MASK), (String)this._options.get(OPTION_ROLES_RDN));
                }
                catch (Exception exception) {
                    if (map2.get(OPTION_LOG_ERRORS) != null) {
                        Logger.security.error((Object)("LDAPLoginModule error: cannot load LDAP realm " + string), (Throwable)exception);
                        exception.printStackTrace();
                    }
                    return;
                }
                map.put(string, this._realm);
            }
        }
    }

    public boolean login() throws LoginException {
        LDAPCredentials lDAPCredentials;
        if (this._subject == null) {
            return false;
        }
        if (this._realm == null) {
            return false;
        }
        Iterator iterator = this._subject.getPrivateCredentials(class$tyrex$security$ldap$LDAPCredentials == null ? (class$tyrex$security$ldap$LDAPCredentials = LDAPLoginModule.class$("tyrex.security.ldap.LDAPCredentials")) : class$tyrex$security$ldap$LDAPCredentials).iterator();
        while (iterator.hasNext()) {
            lDAPCredentials = (LDAPCredentials)iterator.next();
            if (!lDAPCredentials.getHost().equals(this._realm.getLDAPHost()) || lDAPCredentials.getPort() != this._realm.getLDAPPort() || !this.loginWithCred(lDAPCredentials)) continue;
            return true;
        }
        iterator = this._subject.getPrivateCredentials(class$tyrex$security$NamePasswordCredentials == null ? (class$tyrex$security$NamePasswordCredentials = LDAPLoginModule.class$("tyrex.security.NamePasswordCredentials")) : class$tyrex$security$NamePasswordCredentials).iterator();
        while (iterator.hasNext()) {
            NamePasswordCredentials namePasswordCredentials = (NamePasswordCredentials)iterator.next();
            if ((namePasswordCredentials.getRealm() != null || !this._realm.isDefaultRealm()) && (namePasswordCredentials.getRealm() == null || !namePasswordCredentials.getRealm().equals(this._realm.getRealmName())) || !this.loginWithCred(lDAPCredentials = new LDAPCredentials(this._realm.getLDAPHost(), this._realm.getLDAPPort(), this._realm.getDN(namePasswordCredentials.getName()), namePasswordCredentials.getPassword()))) continue;
            this._ldapCreds = lDAPCredentials;
            return true;
        }
        return false;
    }

    private boolean loginWithCred(LDAPCredentials lDAPCredentials) throws LoginException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(lDAPCredentials.getHost(), lDAPCredentials.getPort());
            lDAPConnection.authenticate(lDAPCredentials.getDN(), new String(lDAPCredentials.getPassword()));
            LDAPEntry lDAPEntry = lDAPConnection.read(lDAPCredentials.getDN(), new String[]{"cn", "mail"});
            this._princs.add(new LDAPPrincipal(lDAPCredentials.getDN()));
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
            if (lDAPAttribute != null && lDAPAttribute.getStringValueArray().length > 0) {
                this._princs.add(new CommonNamePrincipal(lDAPAttribute.getStringValueArray()[0]));
            }
            if ((lDAPAttribute = lDAPEntry.getAttribute("email")) != null && lDAPAttribute.getStringValueArray().length > 0) {
                this._princs.add(new EmailPrincipal(lDAPAttribute.getStringValueArray()[0]));
            }
            lDAPConnection.disconnect();
            this._roleCreds = this._realm.getRoleCredentials(lDAPCredentials.getDN());
            return true;
        }
        catch (LDAPException lDAPException) {
            try {
                if (lDAPConnection.isConnected()) {
                    lDAPConnection.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lDAPException.getLDAPResultCode() == 32) {
                return false;
            }
            if (lDAPException.getLDAPResultCode() == 48) {
                throw new LoginException("Account " + lDAPCredentials.getDN() + " has no password");
            }
            if (lDAPException.getLDAPResultCode() == 49) {
                throw new LoginException("Account " + lDAPCredentials.getDN() + " has invalid password");
            }
            if (lDAPException.getLDAPResultCode() == 50) {
                throw new FailedLoginException("No credentials to access account " + lDAPCredentials.getDN());
            }
            throw new LoginException(lDAPException.getMessage());
        }
    }

    public boolean commit() throws LoginException {
        if (this._subject == null) {
            return false;
        }
        if (this._roleCreds != null) {
            this._subject.getPublicCredentials().add(this._roleCreds);
        }
        if (this._ldapCreds != null) {
            this._subject.getPrivateCredentials().add(this._ldapCreds);
        }
        this._subject.getPrincipals().addAll(this._princs);
        return true;
    }

    public boolean abort() throws LoginException {
        if (this._subject == null) {
            return false;
        }
        if (this._roleCreds != null) {
            this._roleCreds.destroy();
            this._roleCreds = null;
        }
        if (this._ldapCreds != null) {
            this._ldapCreds.destroy();
            this._ldapCreds = null;
        }
        this._princs = null;
        this._subject = null;
        return true;
    }

    public boolean logout() throws LoginException {
        if (this._subject == null) {
            return false;
        }
        if (this._roleCreds != null) {
            this._roleCreds.destroy();
            this._subject.getPublicCredentials().remove(this._roleCreds);
            this._roleCreds = null;
        }
        if (this._ldapCreds != null) {
            this._ldapCreds.destroy();
            this._subject.getPrivateCredentials().remove(this._ldapCreds);
            this._ldapCreds = null;
        }
        this._subject.getPrincipals().remove(this._princs);
        this._subject = null;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

