/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.ldap;

import java.net.MalformedURLException;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;
import tyrex.security.container.helper.RolesRealm;

public class LDAPRealm
extends RolesRealm {
    public static final String DEFAULT_REALM_NAME = "<default>";
    private LDAPUrl _url;
    private String _dnMaskStart;
    private String _dnMaskEnd;
    private String _rolesRDN;

    LDAPRealm(String string, String string2, String string3, String string4) throws MalformedURLException, LDAPException {
        super(string, null);
        this._url = new LDAPUrl(string2);
        DN dN = new DN(string3);
        Vector vector = dN.getRDNs();
        if (vector.size() < 2) {
            throw new IllegalArgumentException("DN mask " + string3 + " not of the form x=*,y=z");
        }
        RDN rDN = (RDN)vector.elementAt(0);
        if (!rDN.getValues()[0].equals("*")) {
            throw new IllegalArgumentException("DN mask " + string3 + " not of the form x=*,y=z");
        }
        this._dnMaskStart = rDN.getTypes()[0] + "=";
        this._dnMaskEnd = "," + dN.getParent();
        this._rolesRDN = string4;
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(this._url.getHost(), this._url.getPort());
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string4, 1, "(objectclass=role)", new String[]{"role", "member"}, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("role");
                if (lDAPAttribute == null) continue;
                String[] stringArray = lDAPAttribute.getStringValueArray();
                int n = 0;
                while (n < stringArray.length) {
                    String string5 = stringArray[n];
                    lDAPAttribute = lDAPEntry.getAttribute("member");
                    if (lDAPAttribute != null) {
                        this.addRole(string5, lDAPAttribute.getStringValueArray());
                    }
                    ++n;
                }
            }
        }
        catch (LDAPException lDAPException) {
            try {
                if (lDAPConnection.isConnected()) {
                    lDAPConnection.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lDAPException.getLDAPResultCode() == 32) {
                return;
            }
            throw lDAPException;
        }
    }

    public int getLDAPPort() {
        return this._url.getPort();
    }

    public String getLDAPHost() {
        return this._url.getHost();
    }

    public String getLDAPUrl() {
        return this._url.toString();
    }

    public boolean isDefaultRealm() {
        return this.getRealmName().equals(DEFAULT_REALM_NAME);
    }

    public String getDN(String string) {
        return this._dnMaskStart + string + this._dnMaskEnd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(String string, String string2) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(this._url.getHost(), this._url.getPort());
            lDAPConnection.authenticate(string, string2);
            String[] stringArray = this.listRoles();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    Object var11_11 = null;
                    break;
                }
                String string3 = "role=" + stringArray[n] + "," + this._rolesRDN;
                String[] stringArray2 = this.listMembers(stringArray[n]);
                if (stringArray2.length == 0) {
                    try {
                        lDAPConnection.delete(string3);
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() != 32) throw lDAPException;
                    }
                } else {
                    LDAPEntry lDAPEntry;
                    try {
                        lDAPEntry = lDAPConnection.read(string3);
                        lDAPConnection.modify(string3, new LDAPModification(2, new LDAPAttribute("member", stringArray2)));
                    }
                    catch (LDAPException lDAPException) {
                        if (lDAPException.getLDAPResultCode() != 32) throw lDAPException;
                        lDAPEntry = new LDAPEntry(string3);
                        lDAPEntry.getAttributeSet().add(new LDAPAttribute("role", stringArray[n]));
                        lDAPEntry.getAttributeSet().add(new LDAPAttribute("member", stringArray2));
                        lDAPConnection.add(lDAPEntry);
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (!lDAPConnection.isConnected()) throw throwable;
                lDAPConnection.disconnect();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (!lDAPConnection.isConnected()) return;
        lDAPConnection.disconnect();
    }
}

