/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions._TransactionFactoryImplBase;
import tyrex.tm.impl.ControlImpl;
import tyrex.tm.impl.TransactionDomainImpl;
import tyrex.tm.impl.TransactionImpl;

final class TransactionFactoryImpl
extends _TransactionFactoryImplBase
implements Sender,
Receiver {
    private final TransactionDomainImpl _txDomain;

    TransactionFactoryImpl(TransactionDomainImpl transactionDomainImpl) {
        if (transactionDomainImpl == null) {
            throw new IllegalArgumentException("Argument 'txDomain' is null");
        }
        this._txDomain = transactionDomainImpl;
    }

    public Control create(int n) {
        try {
            TransactionImpl transactionImpl = this._txDomain.createTransaction(null, n);
            Control control = transactionImpl.getControl();
            if (this._txDomain._orb != null) {
                this._txDomain._orb.connect((Object)control);
            }
            return control;
        }
        catch (Exception exception) {
            throw new INVALID_TRANSACTION();
        }
    }

    public Control recreate(PropagationContext propagationContext) {
        try {
            TransactionImpl transactionImpl = this._txDomain.recreateTransaction(propagationContext);
            Control control = transactionImpl.getControl();
            if (this._txDomain._orb != null) {
                this._txDomain._orb.connect((Object)control);
            }
            return control;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new INVALID_TRANSACTION();
        }
    }

    public void sending_request(int n, PropagationContextHolder propagationContextHolder) {
        TransactionImpl transactionImpl = (TransactionImpl)this._txDomain._txManager.getTransaction();
        if (transactionImpl == null) {
            throw new TRANSACTION_REQUIRED();
        }
        propagationContextHolder.value = ((ControlImpl)transactionImpl.getControl()).getPropagationContext();
    }

    public void received_request(int n, PropagationContext propagationContext) {
        try {
            ControlImpl controlImpl = (ControlImpl)this.recreate(propagationContext);
            try {
                this._txDomain._txManager.resume(controlImpl.getTransaction());
            }
            catch (IllegalStateException illegalStateException) {
                throw new InvalidControl();
            }
            catch (InvalidTransactionException invalidTransactionException) {
                throw new InvalidControl();
            }
            catch (SystemException systemException) {
                throw new INVALID_TRANSACTION(systemException.toString());
            }
        }
        catch (InvalidControl invalidControl) {
            throw new INVALID_TRANSACTION();
        }
    }

    public void sending_reply(int n, PropagationContextHolder propagationContextHolder) {
        TransactionImpl transactionImpl = (TransactionImpl)this._txDomain._txManager.getTransaction();
        if (transactionImpl == null) {
            throw new TRANSACTION_ROLLEDBACK();
        }
        if (transactionImpl.getPropagationContext() == null) {
            while (transactionImpl.getParent() != null) {
                transactionImpl = (TransactionImpl)transactionImpl.getParent();
            }
            if (transactionImpl.getPropagationContext() != null) {
                try {
                    transactionImpl.getPropagationContext().current.coord.rollback_only();
                }
                catch (Inactive inactive) {
                    // empty catch block
                }
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        propagationContextHolder.value = transactionImpl.getPropagationContext();
    }

    public void received_reply(int n, PropagationContext propagationContext, Environment environment) throws WrongTransaction {
        if (environment.exception() != null) {
            try {
                this._txDomain._txManager.setRollbackOnly();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SystemException systemException) {
                throw new INVALID_TRANSACTION(systemException.toString());
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        TransactionImpl transactionImpl = (TransactionImpl)this._txDomain._txManager.getTransaction();
        if (transactionImpl == null || ((ControlImpl)transactionImpl.getControl()).getCoordinator() != propagationContext.current.coord) {
            throw new WrongTransaction();
        }
    }
}

