/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.configuration;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.configuration.ConfigurationException;
import org.jboss.configuration.ConfigurationServiceMBean;
import org.jboss.logging.Logger;
import org.jboss.util.Service;
import org.jboss.util.ServiceFactory;
import org.jboss.util.ServiceMBeanSupport;
import org.jboss.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationService
extends ServiceMBeanSupport
implements ConfigurationServiceMBean {
    public static final String CONFIGURATION_FILE = "jboss.jcml";
    public static final String RUNNING_STATE_FILE = "jboss-auto.jcml";
    private static Hashtable primitives = new Hashtable();
    private static HashMap serviceOpMap;
    private MBeanServer server;
    private ObjectName serviceControl;
    private boolean autoTrim;
    static Logger proxyLog;
    static /* synthetic */ Class class$org$jboss$configuration$ConfigurationService$ServiceProxy;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$jboss$util$Service;
    static /* synthetic */ Class class$java$lang$String;

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("long", Long.TYPE);
        serviceOpMap = new HashMap();
        serviceOpMap.put("init", new Integer(0));
        serviceOpMap.put("start", new Integer(1));
        serviceOpMap.put("destroy", new Integer(2));
        serviceOpMap.put("stop", new Integer(3));
        proxyLog = Logger.getLogger(class$org$jboss$configuration$ConfigurationService$ServiceProxy != null ? class$org$jboss$configuration$ConfigurationService$ServiceProxy : (class$org$jboss$configuration$ConfigurationService$ServiceProxy = ConfigurationService.class$("org.jboss.configuration.ConfigurationService$ServiceProxy")));
    }

    public ConfigurationService() {
        this(true);
    }

    public ConfigurationService(boolean autoTrim) {
        this.autoTrim = autoTrim;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void create(Document configuration) throws Exception {
        try {
            ObjectName loader = new ObjectName(this.server.getDefaultDomain(), "service", "MLet");
            NodeList nl = configuration.getElementsByTagName("mbean");
            int i = 0;
            while (i < nl.getLength()) {
                MBeanInfo info;
                Element mbeanElement = (Element)nl.item(i);
                ObjectName objectName = this.parseObjectName(mbeanElement);
                try {
                    info = this.server.getMBeanInfo(objectName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    String code = mbeanElement.getAttribute("code");
                    if (code == null) {
                        throw new ConfigurationException("missing 'code' attribute");
                    }
                    try {
                        ConstructorInfo constructor = ConstructorInfo.create(mbeanElement);
                        ObjectInstance instance = this.server.createMBean(code, objectName, loader, constructor.params, constructor.signature);
                        info = this.server.getMBeanInfo(instance.getObjectName());
                    }
                    catch (Throwable ex) {
                        this.logException("Could not create MBean " + objectName + "(" + code + ")", ex);
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            this.logException(e);
            throw (Exception)e;
        }
    }

    public boolean getAutoTrim() {
        return this.autoTrim;
    }

    public String getName() {
        return "Configuration";
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return new ObjectName(":service=Configuration");
    }

    private Service getServiceInstance(ObjectName objectName, MBeanInfo info, String serviceFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Service service = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (serviceFactory != null && serviceFactory.length() > 0) {
            Class<?> clazz = loader.loadClass(serviceFactory);
            ServiceFactory factory = (ServiceFactory)clazz.newInstance();
            service = factory.createService(this.server, objectName);
        } else {
            MBeanOperationInfo[] opInfo = info.getOperations();
            Class[] interfaces = new Class[]{class$org$jboss$util$Service != null ? class$org$jboss$util$Service : (class$org$jboss$util$Service = ConfigurationService.class$("org.jboss.util.Service"))};
            ServiceProxy handler = new ServiceProxy(objectName, opInfo);
            service = (Service)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
        }
        return service;
    }

    private boolean isAttributeWriteable(String className, String attribute, String type) {
        Class<Serializable> arg = null;
        Class<?> cls = null;
        try {
            arg = type.equals("int") ? Integer.TYPE : (type.equals("boolean") ? Boolean.TYPE : (type.equals("float") ? Float.TYPE : (type.equals("byte") ? Byte.TYPE : (type.equals("short") ? Short.TYPE : (type.equals("char") ? Character.TYPE : (type.equals("long") ? Long.TYPE : (type.equals("double") ? Double.TYPE : Class.forName(type))))))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error("Unable to check parameter of type '" + type + "'");
            return false;
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error("Unable to check MBean of type '" + className + "'");
            return false;
        }
        try {
            Method m = cls.getMethod("set" + attribute, arg);
            return this.isSetterMethod(m);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private boolean isSetterMethod(Method m) {
        if (m != null) {
            return Modifier.isPublic(m.getModifiers()) && !Modifier.isStatic(m.getModifiers()) && m.getReturnType().equals(Void.TYPE);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void load(Document configuration) throws Exception {
        this.serviceControl = new ObjectName(this.server.getDefaultDomain(), "service", "ServiceControl");
        if (!this.server.isRegistered(this.serviceControl)) {
            throw new IllegalStateException("Failed to find ServiceControl mbean, name=" + this.serviceControl);
        }
        try {
            NodeList nl = configuration.getElementsByTagName("mbean");
            int i = 0;
            while (i < nl.getLength()) {
                block18: {
                    MBeanInfo info;
                    Element mbeanElement = (Element)nl.item(i);
                    ObjectName objectName = this.parseObjectName(mbeanElement);
                    try {
                        info = this.server.getMBeanInfo(objectName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        break block18;
                    }
                    NodeList attrs = mbeanElement.getElementsByTagName("attribute");
                    int j = 0;
                    while (j < attrs.getLength()) {
                        Element attributeElement = (Element)attrs.item(j);
                        String attributeName = attributeElement.getAttribute("name");
                        if (attributeElement.hasChildNodes()) {
                            Node n = attributeElement.getFirstChild();
                            String attributeText = null;
                            if (n instanceof Text) {
                                attributeText = ((Text)n).getData();
                                if (this.autoTrim) {
                                    attributeText = attributeText.trim();
                                }
                            }
                            MBeanAttributeInfo[] attributes = info.getAttributes();
                            int k = 0;
                            while (k < attributes.length) {
                                if (attributeName.equals(attributes[k].getName())) {
                                    String typeName = attributes[k].getType();
                                    Class typeClass = primitives.containsKey(typeName) ? (Class)primitives.get(typeName) : Class.forName(typeName);
                                    Object value = attributeText;
                                    if ((class$org$w3c$dom$Element != null ? class$org$w3c$dom$Element : ConfigurationService.class$("org.w3c.dom.Element")).isAssignableFrom(typeClass)) {
                                        NodeList nodes = attributeElement.getChildNodes();
                                        int l = 0;
                                        while (l < nodes.getLength()) {
                                            n = nodes.item(l);
                                            if (n.getNodeType() == 1) {
                                                value = (Element)n;
                                                break;
                                            }
                                            ++l;
                                        }
                                    } else {
                                        PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
                                        if (editor != null) {
                                            editor.setAsText(attributeText);
                                            value = editor.getValue();
                                        }
                                    }
                                    this.log.debug(String.valueOf(attributeName) + " set to " + value + " in " + objectName);
                                    this.server.setAttribute(objectName, new Attribute(attributeName, value));
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    this.registerService(objectName, info, mbeanElement);
                }
                ++i;
            }
        }
        catch (Error e) {
            this.logException(e);
            throw new RuntimeException("Unexpected Error: " + e.getMessage());
        }
        catch (Exception e) {
            void nl;
            this.logException(e);
            throw nl;
        }
    }

    public void loadConfiguration() throws Exception {
        Document doc;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream input = loader.getResourceAsStream(CONFIGURATION_FILE);
        StringBuffer sbufData = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        String eol = System.getProperty("line.separator");
        try {
            String sTmp;
            while ((sTmp = br.readLine()) != null) {
                sbufData.append(sTmp);
                sbufData.append(eol);
            }
        }
        finally {
            Object var8_7 = null;
            input.close();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        try {
            doc = parser.parse(new InputSource(new StringReader(sbufData.toString())));
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        this.create(doc);
        this.load(doc);
    }

    private void logException(String msg, Throwable e) {
        if (e instanceof RuntimeErrorException) {
            e = ((RuntimeErrorException)e).getTargetError();
        } else if (e instanceof RuntimeMBeanException) {
            e = ((RuntimeMBeanException)e).getTargetException();
        } else if (e instanceof RuntimeOperationsException) {
            e = ((RuntimeOperationsException)e).getTargetException();
        } else if (e instanceof MBeanException) {
            e = ((MBeanException)e).getTargetException();
        } else if (e instanceof ReflectionException) {
            e = ((ReflectionException)e).getTargetException();
        }
        this.log.error(msg, e);
    }

    private void logException(Throwable e) {
        this.logException("Unexpected error", e);
    }

    private ObjectName parseObjectName(Element element) throws ConfigurationException, MalformedObjectNameException {
        String name = element.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new ConfigurationException("MBean attribute 'name' must be given.");
        }
        return new ObjectName(name);
    }

    private void registerService(ObjectName objectName, MBeanInfo info, Element mbeanElement) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        block2: {
            String serviceFactory = mbeanElement.getAttribute("serviceFactory");
            Service service = this.getServiceInstance(objectName, info, serviceFactory);
            if (service == null) break block2;
            Object[] args = new Object[]{service};
            String[] signature = new String[]{"org.jboss.util.Service"};
            try {
                this.server.invoke(this.serviceControl, "register", args, signature);
            }
            catch (Exception e) {
                this.logException("register failure", e);
            }
        }
    }

    public String save() throws Exception {
        StringWriter out = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element serverElement = doc.createElement("server");
        Iterator<ObjectInstance> mbeans = this.server.queryMBeans(null, null).iterator();
        while (mbeans.hasNext()) {
            ObjectInstance instance = mbeans.next();
            ObjectName name = instance.getObjectName();
            Element mbeanElement = doc.createElement("mbean");
            mbeanElement.setAttribute("name", name.toString());
            MBeanInfo info = this.server.getMBeanInfo(name);
            mbeanElement.setAttribute("code", info.getClassName());
            MBeanAttributeInfo[] attributes = info.getAttributes();
            boolean hasAttributes = true;
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i].isReadable() && this.isAttributeWriteable(this.server.getObjectInstance(name).getClassName(), attributes[i].getName(), attributes[i].getType())) {
                    if (!attributes[i].isWritable()) {
                        this.log.debug("Detected JMX Bug: Server reports attribute '" + attributes[i].getName() + "' is not writeable for MBean '" + name.getCanonicalName() + "'");
                    }
                    Element attributeElement = doc.createElement("attribute");
                    Object value = this.server.getAttribute(name, attributes[i].getName());
                    attributeElement.setAttribute("name", attributes[i].getName());
                    if (value != null) {
                        attributeElement.appendChild(doc.createTextNode(value.toString()));
                    }
                    mbeanElement.appendChild(attributeElement);
                    hasAttributes = true;
                }
                ++i;
            }
            if (!hasAttributes) continue;
            serverElement.appendChild(mbeanElement);
        }
        doc.appendChild(serverElement);
        XmlHelper.write(out, doc);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    public void saveConfiguration() throws Exception {
        String xml = this.save();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL confFile = loader.getResource(RUNNING_STATE_FILE);
        if (confFile != null) {
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new FileOutputStream(confFile.getFile()));
                    out.print(xml);
                }
                catch (FileNotFoundException e) {
                    this.log.error("Configuration file " + confFile.getFile() + " must be available and writable.", e);
                }
                Object var6_6 = null;
                out.close();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                out.close();
                throw throwable;
            }
        }
    }

    private static class ConstructorInfo {
        public static final Object[] EMPTY_PARAMS = new Object[0];
        public static final String[] EMPTY_SIGNATURE = new String[0];
        public String[] signature = EMPTY_SIGNATURE;
        public Object[] params = EMPTY_PARAMS;

        ConstructorInfo() {
        }

        public static ConstructorInfo create(Element element) throws ConfigurationException {
            ConstructorInfo info = new ConstructorInfo();
            NodeList list = element.getElementsByTagName("constructor");
            if (list.getLength() > 1) {
                throw new ConfigurationException("only one <constructor> element may be defined");
            }
            if (list.getLength() == 1) {
                element = (Element)list.item(0);
                list = element.getElementsByTagName("arg");
                int length = list.getLength();
                info.params = new Object[length];
                info.signature = new String[length];
                int j = 0;
                while (j < length) {
                    Element arg = (Element)list.item(j);
                    String signature = arg.getAttribute("type");
                    String value = arg.getAttribute("value");
                    Object realValue = value;
                    if (signature != null) {
                        if (signature.equals("short")) {
                            signature = Short.TYPE.getName();
                            realValue = new Short(value);
                        } else if (signature.equals("int")) {
                            signature = Integer.TYPE.getName();
                            realValue = new Integer(value);
                        } else if (signature.equals("long")) {
                            signature = Long.TYPE.getName();
                            realValue = new Long(value);
                        } else if (signature.equals("byte")) {
                            signature = Byte.TYPE.getName();
                            realValue = new Byte(value);
                        } else if (signature.equals("char")) {
                            signature = Character.TYPE.getName();
                            realValue = new Character(value.charAt(0));
                        } else if (signature.equals("float")) {
                            signature = Float.TYPE.getName();
                            realValue = new Float(value);
                        } else if (signature.equals("double")) {
                            signature = Double.TYPE.getName();
                            realValue = new Double(value);
                        } else if (signature.equals("boolean")) {
                            signature = Boolean.TYPE.getName();
                            realValue = new Boolean(value);
                        } else {
                            try {
                                Class<?> signatureClass = Thread.currentThread().getContextClassLoader().loadClass(signature);
                                Constructor<?> signatureConstructor = signatureClass.getConstructor(class$java$lang$String != null ? class$java$lang$String : ConfigurationService.class$("java.lang.String"));
                                realValue = signatureConstructor.newInstance(value);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    info.signature[j] = signature;
                    info.params[j] = realValue;
                    ++j;
                }
            }
            return info;
        }
    }

    private class ServiceProxy
    implements InvocationHandler {
        private boolean[] hasOp = new boolean[4];
        private ObjectName objectName;

        public ServiceProxy(ObjectName objectName, MBeanOperationInfo[] opInfo) {
            this.objectName = objectName;
            int opCount = 0;
            int op = 0;
            while (op < opInfo.length) {
                MBeanOperationInfo info = opInfo[op];
                String name = info.getName();
                Integer opID = (Integer)serviceOpMap.get(name);
                if (opID != null && info.getReturnType().equals("void") && info.getSignature().length == 0) {
                    this.hasOp[opID.intValue()] = true;
                    ++opCount;
                }
                ++op;
            }
            if (opCount == 0) {
                proxyLog.warn(String.valueOf(String.valueOf(objectName)) + " does not implement any Service methods");
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            block3: {
                String name = method.getName();
                Integer opID = (Integer)serviceOpMap.get(name);
                if (opID == null || !this.hasOp[opID]) break block3;
                try {
                    String[] sig = new String[]{};
                    ConfigurationService.this.server.invoke(this.objectName, name, args, sig);
                }
                catch (JMRuntimeException e) {
                    ConfigurationService.this.logException(e);
                }
                catch (JMException e) {
                    ConfigurationService.this.logException(e);
                }
            }
            return null;
        }
    }
}

