/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import org.jboss.deployment.AutoDeployerMBean;
import org.jboss.deployment.Util;
import org.jboss.util.ServiceMBeanSupport;

public class AutoDeployer
extends ServiceMBeanSupport
implements AutoDeployerMBean,
Runnable {
    MBeanServer server;
    String deployerList = "";
    ObjectName[] deployerNames;
    int timeout = 3000;
    boolean running = false;
    ArrayList watchedDirectories = new ArrayList();
    HashMap watchedURLs = new HashMap();
    String urlList = "";
    FilenameFilter[] deployableFilters = null;

    public AutoDeployer() {
        this("");
    }

    public AutoDeployer(String urlList) {
        this("J2EE:service=J2eeDeployer", urlList);
    }

    public AutoDeployer(String _namedDeployer, String urlList) {
        this.setDeployers(_namedDeployer);
        this.setURLs(urlList);
    }

    protected void deploy(String url, ObjectName deployerName) throws Exception {
        try {
            this.server.invoke(deployerName, "deploy", new Object[]{url}, new String[]{"java.lang.String"});
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (RuntimeErrorException e) {
            throw e.getTargetError();
        }
    }

    public String getDeployers() {
        return this.deployerList;
    }

    public String getName() {
        return "Auto deploy";
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return name == null ? new ObjectName("EJB:service=AutoDeployer") : name;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getURLs() {
        return this.urlList;
    }

    public void run() {
        do {
            if (this.running) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                DeploymentInfo deployment;
                int i = 0;
                while (i < this.watchedDirectories.size()) {
                    File dir = (File)this.watchedDirectories.get(i);
                    File[] files = dir.listFiles();
                    int idx = 0;
                    while (idx < files.length) {
                        URL fileURL = files[idx].toURL();
                        int j = 0;
                        while (j < this.deployerNames.length) {
                            if (this.deployableFilters[j].accept(null, fileURL.getFile()) && !this.watchedURLs.containsKey(fileURL)) {
                                this.watchedURLs.put(fileURL, new DeploymentInfo(fileURL));
                            }
                            ++j;
                        }
                        ++idx;
                    }
                    ++i;
                }
                Iterator iterator = this.watchedURLs.values().iterator();
                while (iterator.hasNext()) {
                    deployment = (DeploymentInfo)iterator.next();
                    URL url = deployment.url;
                    if (!url.getProtocol().startsWith("file") || new File(url.getFile()).exists()) continue;
                    this.log.info("Auto undeploy of " + url);
                    try {
                        this.undeploy(url.toString(), deployment.deployerName);
                    }
                    catch (Exception e) {
                        this.log.error("Undeployment failed", e);
                    }
                    iterator.remove();
                }
                iterator = this.watchedURLs.values().iterator();
                while (iterator.hasNext()) {
                    deployment = (DeploymentInfo)iterator.next();
                    long lm = deployment.watch.getProtocol().startsWith("file") ? new File(deployment.watch.getFile()).lastModified() : deployment.watch.openConnection().getLastModified();
                    if (deployment.lastModified != 0L && deployment.lastModified >= lm) continue;
                    this.log.info("Auto deploy of " + deployment.url);
                    deployment.lastModified = lm;
                    try {
                        this.deploy(deployment.url.toString(), deployment.deployerName);
                    }
                    catch (Throwable e) {
                        this.log.error("DeploymentInfo failed:" + deployment.url, e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.running = false;
            }
        } while (this.running);
    }

    public void setDeployers(String deployers) {
        this.deployerList = deployers;
    }

    public void setTimeout(int to) {
        this.timeout = to;
    }

    public void setURLs(String urlList) {
        this.urlList = urlList;
    }

    protected void startService() throws Exception {
        StringTokenizer deployers = new StringTokenizer(this.deployerList, ";");
        this.deployerNames = new ObjectName[deployers.countTokens()];
        this.deployableFilters = new FilenameFilter[this.deployerNames.length];
        int i = 0;
        while (i < this.deployerNames.length && deployers.hasMoreTokens()) {
            block15: {
                String deployerName = deployers.nextToken().trim();
                try {
                    this.deployerNames[i] = new ObjectName(deployerName);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    this.log.warn("The string '" + deployerName + "'is not a valid " + "object name - ignoring it.");
                    break block15;
                }
                try {
                    this.deployableFilters[i] = (FilenameFilter)this.server.invoke(this.deployerNames[i], "getDeployableFilter", new Object[0], new String[0]);
                }
                catch (ReflectionException reflectionException) {
                    this.log.info("Deployer '" + this.deployerNames[i] + "' doesn't provide a " + "filter - will try to deploy all files");
                    this.deployableFilters[i] = new FilenameFilter(){

                        public boolean accept(File dir, String filename) {
                            return true;
                        }
                    };
                }
            }
            ++i;
        }
        StringTokenizer urls = new StringTokenizer(this.urlList, ",");
        while (urls.hasMoreTokens()) {
            DeploymentInfo info;
            URL modURL;
            File modFile;
            String url = urls.nextToken().trim();
            File urlFile = new File(url.startsWith("file:") ? url.substring(5) : url);
            if (urlFile.isDirectory()) {
                try {
                    modFile = urlFile.getCanonicalFile();
                    if (Util.hasDeploymentDescriptor(modFile) >= 0) {
                        modURL = modFile.toURL();
                        info = new DeploymentInfo(modURL);
                        this.watchedURLs.put(modURL, info);
                        this.log.info("Watching module directory: " + modFile);
                        continue;
                    }
                    this.watchedDirectories.add(modFile);
                    this.log.info("Watching directory: " + modFile);
                }
                catch (Exception e) {
                    this.log.info("Cannot auto-deploy module: " + urlFile, e);
                }
                continue;
            }
            if (urlFile.exists()) {
                try {
                    modFile = urlFile.getCanonicalFile();
                    modURL = modFile.toURL();
                    info = new DeploymentInfo(modURL);
                    this.watchedURLs.put(modURL, info);
                    this.log.info("Auto-deploying module archive: " + modFile);
                }
                catch (Exception e) {
                    this.log.info("Cannot auto-deploy module: " + urlFile, e);
                }
                continue;
            }
            try {
                URL infoURL = new URL(url);
                this.watchedURLs.put(infoURL, new DeploymentInfo(infoURL));
            }
            catch (MalformedURLException malformedURLException) {
                this.log.warn("Cannot auto-deploy " + url);
            }
        }
        this.run();
        this.running = true;
        new Thread((Runnable)this, "AutoDeployer").start();
    }

    protected void stopService() {
        this.running = false;
        this.watchedDirectories.clear();
        this.watchedURLs.clear();
    }

    protected void undeploy(String url, ObjectName deployerName) throws Exception {
        try {
            this.server.invoke(deployerName, "undeploy", new Object[]{url}, new String[]{"java.lang.String"});
        }
        catch (MBeanException e) {
            throw e.getTargetException();
        }
        catch (RuntimeErrorException e) {
            throw e.getTargetError();
        }
    }

    class DeploymentInfo {
        long lastModified;
        URL url;
        URL watch;
        ObjectName deployerName;

        DeploymentInfo(URL url) throws MalformedURLException {
            this.url = url;
            int i = 0;
            while (i < AutoDeployer.this.deployableFilters.length) {
                if (AutoDeployer.this.deployableFilters[i].accept(null, url.getFile())) {
                    this.watch = url;
                    this.deployerName = AutoDeployer.this.deployerNames[i];
                }
                ++i;
            }
            if (this.watch == null) {
                throw new MalformedURLException("Failed to find deployer for: " + url);
            }
            String protocol = this.watch.getProtocol();
            File watchDir = new File(this.watch.getFile());
            if (protocol.equals("file") && watchDir.isDirectory()) {
                String path = Util.getDeploymentDescriptor(watchDir);
                this.watch = new URL(this.watch, path);
            }
        }
    }
}

