/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployment.DeployerMBean;
import org.jboss.deployment.DeploymentException;
import org.jboss.util.ServiceMBeanSupport;

public abstract class DeployerMBeanSupport
extends ServiceMBeanSupport
implements DeployerMBean {
    private Map deployments = new HashMap();

    public void deploy(String url) throws MalformedURLException, IOException, DeploymentException {
        URL u = new URL(url);
        Map map = this.deployments;
        synchronized (map) {
            Object info;
            if (this.deployments.containsKey(u)) {
                info = this.deployments.get(u);
                try {
                    this.undeploy(u, info);
                }
                catch (Throwable t) {
                    this.log.error("undeploy failure", t);
                    if (t instanceof Exception) {
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                        if (t instanceof DeploymentException) {
                            throw (DeploymentException)t;
                        }
                        throw (RuntimeException)t;
                    }
                    throw (Error)t;
                }
            }
            try {
                info = this.deploy(u);
                this.deployments.put(u, info);
            }
            catch (Throwable t) {
                this.log.error("deploy failure", t);
                if (t instanceof Exception) {
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    if (t instanceof DeploymentException) {
                        throw (DeploymentException)t;
                    }
                    throw (RuntimeException)t;
                }
                throw (Error)t;
            }
        }
    }

    protected abstract Object deploy(URL var1) throws IOException, DeploymentException;

    public abstract FilenameFilter getDeployableFilter();

    protected Map getDeployments() {
        HashMap ret = new HashMap();
        Map map = this.deployments;
        synchronized (map) {
            ret.putAll(this.deployments);
        }
        return ret;
    }

    protected Object getInfo(URL url) {
        return this.deployments.get(url);
    }

    public boolean isDeployed(String url) throws MalformedURLException, DeploymentException {
        URL u = new URL(url);
        Map map = this.deployments;
        synchronized (map) {
            boolean bl = this.deployments.containsKey(u);
            Object var5_5 = null;
            return bl;
        }
    }

    public void undeploy(String url) throws MalformedURLException, IOException, DeploymentException {
        URL u = new URL(url);
        Map map = this.deployments;
        synchronized (map) {
            if (this.deployments.containsKey(u)) {
                Object info = this.deployments.remove(u);
                this.undeploy(u, info);
            }
        }
    }

    protected abstract void undeploy(URL var1, Object var2) throws IOException, DeploymentException;
}

