/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.deployment.Deployment;
import org.jboss.deployment.Installer;
import org.jboss.deployment.J2eeDeployer;
import org.jboss.deployment.J2eeDeploymentException;
import org.jboss.deployment.LegacyInstaller;
import org.jboss.deployment.LocalDirInstaller;
import org.jboss.logging.Logger;

public class InstallerFactory {
    protected File baseDir;
    protected Logger log;

    public InstallerFactory(File _tmpDir, Logger _log) throws IOException {
        this.baseDir = _tmpDir.getCanonicalFile();
        this.log = _log;
    }

    private void deleteRecursive(File _file) throws IOException {
        if (_file.exists()) {
            if (_file.isDirectory()) {
                File[] files = _file.listFiles();
                int i = 0;
                int l = files.length;
                while (i < l) {
                    this.deleteRecursive(files[i]);
                    ++i;
                }
            }
            _file.delete();
        }
    }

    public Deployment findDeployment(String _pattern) {
        if (_pattern == null) {
            return null;
        }
        Deployment result = null;
        String realPattern = null;
        try {
            URL u = new URL(_pattern);
            String realtmp = u.getFile();
            File fp = new File(realtmp);
            realPattern = fp.getName();
        }
        catch (MalformedURLException malformedURLException) {}
        if (realPattern == null) {
            try {
                File fp = new File(_pattern);
                realPattern = fp.getName();
            }
            catch (Exception exception) {}
        }
        if (realPattern == null) {
            return result;
        }
        File[] files = this.baseDir.listFiles();
        int i = 0;
        int l = files.length;
        while (i < l) {
            if (realPattern.equals(files[i].getName())) {
                try {
                    result = this.loadConfig(new File(files[i], J2eeDeployer.CONFIG));
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException _ioe) {
                    this.log.error("exception while searching deployment: ", _ioe);
                }
            }
            ++i;
        }
        return result;
    }

    public static FilenameFilter getDeployableFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                boolean accept = false;
                File pkgDir = new File(filename);
                if (pkgDir.isDirectory()) {
                    int f = 0;
                    while (f < Installer.files.length) {
                        File dd = new File(pkgDir, Installer.files[f]);
                        accept |= dd.exists();
                        ++f;
                    }
                }
                filename = filename.toLowerCase();
                if (!accept) {
                    accept = filename.endsWith(".jar") || filename.endsWith(".war") || filename.endsWith(".ear") || filename.endsWith(".zip");
                }
                return accept;
            }
        };
    }

    public Deployment[] getDeployments() {
        Vector<Deployment> found = new Vector<Deployment>();
        File[] files = this.baseDir.listFiles();
        int i = 0;
        int l = files.length;
        while (i < l) {
            File deployment = new File(files[i], J2eeDeployer.CONFIG);
            if (deployment.exists()) {
                try {
                    found.add(this.loadConfig(deployment));
                }
                catch (IOException _ioe) {
                    this.log.error("exception while searching deployments: ", _ioe);
                }
            }
            ++i;
        }
        Deployment[] result = new Deployment[found.size()];
        Iterator it = ((AbstractList)found).iterator();
        int i2 = 0;
        while (it.hasNext()) {
            result[i2] = (Deployment)it.next();
            ++i2;
        }
        return result;
    }

    private String getName(String _url) {
        String result = _url;
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        result = result.substring(result.lastIndexOf("/") + 1);
        return result;
    }

    public Deployment install(URL src) throws J2eeDeploymentException, IOException {
        File srcDir;
        Installer installer = null;
        String protocol = src.getProtocol();
        installer = protocol.equals("file") ? ((srcDir = new File(src.getFile())).isDirectory() ? new LocalDirInstaller() : new LegacyInstaller()) : new LegacyInstaller();
        return installer.execute(this, src);
    }

    private Deployment loadConfig(File _file) throws IOException {
        Deployment d = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(_file));
            d = (Deployment)in.readObject();
            in.close();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return d;
    }

    public void unclutter() throws IOException {
        File[] files = this.baseDir.listFiles();
        int i = 0;
        int l = files.length;
        while (i < l) {
            File dep = new File(files[i], J2eeDeployer.CONFIG);
            if (dep.exists()) {
                try {
                    Deployment d = this.loadConfig(dep);
                    Vector needed = d.getAllFiles();
                    File[] parts = files[i].listFiles();
                    int j = 0;
                    while (j < parts.length) {
                        if (!needed.contains(parts[j].getName())) {
                            this.deleteRecursive(parts[j]);
                        }
                        ++j;
                    }
                }
                catch (IOException _ioe) {
                    this.log.error("exception while uncluttering deployment " + files[i] + ": ", _ioe);
                }
            } else {
                this.deleteRecursive(files[i]);
            }
            ++i;
        }
    }

    public void uninstall(Deployment _d) throws IOException {
        File appDir = new File(_d.localUrl.getFile());
        this.deleteRecursive(appDir);
    }
}

