/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class J2eeApplicationMetaData
extends MetaData {
    String displayName;
    String description;
    String smallIcon;
    String largeIcon;
    Vector modules;

    public J2eeApplicationMetaData(Element rootElement) throws DeploymentException {
        this.importXml(rootElement);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public Iterator getModules() {
        return ((AbstractList)this.modules).iterator();
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void importXml(Element element) throws DeploymentException {
        String rootTag = element.getOwnerDocument().getDocumentElement().getTagName();
        if (rootTag.equals("application")) {
            this.displayName = MetaData.getElementContent(MetaData.getUniqueChild(element, "display-name"));
            Element e = MetaData.getOptionalChild(element, "description");
            this.description = e != null ? MetaData.getElementContent(e) : "";
            e = MetaData.getOptionalChild(element, "icon");
            if (e != null) {
                Element e2 = MetaData.getOptionalChild(element, "small-icon");
                this.smallIcon = e2 != null ? MetaData.getElementContent(e2) : "";
                e2 = MetaData.getOptionalChild(element, "large-icon");
                this.largeIcon = e2 != null ? MetaData.getElementContent(e2) : "";
            } else {
                this.smallIcon = "";
                this.largeIcon = "";
            }
            this.modules = new Vector();
            Iterator it = MetaData.getChildrenByTagName(element, "module");
            while (it.hasNext()) {
                this.modules.add(new J2eeModuleMetaData((Element)it.next()));
            }
        } else {
            throw new DeploymentException("Unrecognized root tag in EAR deployment descriptor: " + element);
        }
    }
}

