/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import org.jboss.deployment.Deployment;
import org.jboss.deployment.DeploymentNotification;
import org.jboss.deployment.InstallerFactory;
import org.jboss.deployment.J2eeDeployerMBean;
import org.jboss.deployment.J2eeDeploymentException;
import org.jboss.util.ServiceMBeanSupport;

public class J2eeDeployer
extends ServiceMBeanSupport
implements J2eeDeployerMBean {
    public File DEPLOYMENT_DIR = null;
    public static String CONFIG = "deployment.cfg";
    public static final int EASY = 0;
    public static final int RESTRICTIVE = 1;
    protected MBeanServer server;
    protected String name;
    protected ObjectName jarDeployer;
    protected ObjectName warDeployer;
    protected InstallerFactory installer;
    String jarDeployerName;
    String warDeployerName;
    int classpathPolicy = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public J2eeDeployer() {
        this("Default", "EJB:service=ContainerFactory", ":service=EmbeddedTomcat");
    }

    public J2eeDeployer(String _name, String jarDeployerName, String warDeployerName) {
        this.setDeployerName(_name);
        this.setJarDeployerName(jarDeployerName);
        this.setWarDeployerName(warDeployerName);
    }

    private boolean checkApplication(Deployment _d) throws J2eeDeploymentException {
        boolean result = false;
        int count = 0;
        int others = 0;
        Object o = this.checkModule(this.jarDeployer, _d.name, _d.localUrl.toString());
        if (o == null) {
            ++others;
        } else {
            result = (Boolean)o;
        }
        if (this.warDeployer != null) {
            Iterator webModules = ((AbstractList)_d.webModules).iterator();
            while (webModules.hasNext()) {
                Deployment.Module m = (Deployment.Module)webModules.next();
                o = this.checkModule(this.warDeployer, m.name, m.localUrls.firstElement().toString());
                if (o == null) {
                    ++others;
                    continue;
                }
                if (count++ == 0) {
                    result = (Boolean)o;
                    continue;
                }
                if (result == (Boolean)o) continue;
                ++others;
            }
        } else {
            this.log.warn("Cannot find web container");
        }
        if (others > 0) {
            throw new J2eeDeploymentException("Application " + _d.name + " is not correctly deployed! (" + (result ? count - others : others) + " modules are running " + (result ? others : count - others) + " are not)");
        }
        return result;
    }

    private Object checkModule(ObjectName container, String moduleName, String moduleUrl) {
        try {
            this.log.info("Checking module " + moduleName);
            return this.server.invoke(container, "isDeployed", new Object[]{moduleUrl}, new String[]{"java.lang.String"});
        }
        catch (MBeanException _mbe) {
            this.log.error("Error while checking module " + moduleName + ": " + _mbe.getTargetException().getMessage());
            return null;
        }
        catch (JMException _jme) {
            this.log.error("Fatal error while checking module " + moduleName + ": " + _jme.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected ObjectName createCollectorName() {
        try {
            return new ObjectName("Management", "service", "Collector");
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void createContextClassLoader(Deployment deployment) throws J2eeDeploymentException {
        URL[] urls = new URL[deployment.commonUrls.size()];
        int i = 0;
        int l = deployment.commonUrls.size();
        while (i < l) {
            urls[i] = (URL)deployment.commonUrls.elementAt(i);
            ++i;
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URLClassLoader appCl = new URLClassLoader(urls, parent);
        Thread.currentThread().setContextClassLoader(appCl);
    }

    public void deploy(String _url) throws MalformedURLException, IOException, J2eeDeploymentException {
        URL url = new URL(_url);
        ObjectName lCollector = this.createCollectorName();
        try {
            this.undeploy(_url);
            this.removeFromCollector(_url, lCollector);
        }
        catch (Exception exception) {}
        this.log.info("Deploy J2EE application: " + _url);
        Deployment d = this.installApplication(url);
        try {
            this.startApplication(d);
            this.log.info("J2EE application: " + _url + " is deployed.");
        }
        catch (Exception _e) {
            try {
                try {
                    this.stopApplication(d);
                }
                catch (Exception _e2) {
                    this.log.error("unable to stop application " + d.name + ": " + _e2);
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    this.uninstallApplication(_url);
                }
                catch (Exception _e3) {
                    this.log.error("unable to uninstall application " + d.name + ": " + _e3);
                }
                throw throwable;
            }
            try {
                this.uninstallApplication(_url);
            }
            catch (Exception _e3) {
                this.log.error("unable to uninstall application " + d.name + ": " + _e3);
            }
            if (_e instanceof J2eeDeploymentException) {
                throw (J2eeDeploymentException)_e;
            }
            this.log.error("fatal error", _e);
            throw new J2eeDeploymentException("fatal error: " + _e);
        }
    }

    public FilenameFilter getDeployableFilter() {
        return InstallerFactory.getDeployableFilter();
    }

    public String getDeployerName() {
        return this.name.trim();
    }

    public String getJarDeployerName() {
        return this.jarDeployerName;
    }

    public String getName() {
        return "J2EE Deployer" + this.name;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return name == null ? new ObjectName("J2EE:service=J2eeDeployer" + this.name) : name;
    }

    public String getWarDeployerName() {
        return this.warDeployerName;
    }

    protected void initService() throws Exception {
        URL tmpDirUrl = this.getClass().getResource("/tmp.properties");
        if (tmpDirUrl == null) {
            throw new IOException("Failed to get /tmp.properties URL; Temporary directory does not exist!");
        }
        File dir = new File(new File(tmpDirUrl.getFile()).getParentFile(), "deploy/" + this.getDeployerName());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Temporary directory \"" + dir.getCanonicalPath() + "\" does not exist!");
        }
        this.installer = new InstallerFactory(dir, this.log);
        this.jarDeployer = new ObjectName(this.jarDeployerName);
        this.warDeployer = new ObjectName(this.warDeployerName);
    }

    protected Deployment installApplication(URL _downloadUrl) throws IOException, J2eeDeploymentException {
        return this.installer.install(_downloadUrl);
    }

    public boolean isDeployed(String _url) throws MalformedURLException, J2eeDeploymentException {
        boolean result = false;
        Deployment d = this.installer.findDeployment(_url);
        if (d != null) {
            result = this.checkApplication(d);
        }
        return result;
    }

    public static void main(String[] _args) throws Exception {
        new J2eeDeployer().deploy(_args[0]);
    }

    protected void removeFromCollector(String _url, ObjectName lCollector) {
        try {
            this.server.invoke(lCollector, "removeApplication", new Object[]{_url}, new String[]{"java.lang.String"});
        }
        catch (Exception exception) {
            this.log.info("Report of undeployment of J2EE application: " + _url + " could not be reported.");
        }
    }

    public void setDeployerName(String name) {
        this.name = name = name.equals("") ? "" : " " + name;
    }

    public void setJarDeployerName(String jarDeployerName) {
        this.jarDeployerName = jarDeployerName;
    }

    public void setWarDeployerName(String warDeployerName) {
        this.warDeployerName = warDeployerName;
    }

    protected void startApplication(Deployment _d) throws J2eeDeploymentException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        this.createContextClassLoader(_d);
        ClassLoader appCl = Thread.currentThread().getContextClassLoader();
        DeploymentNotification evt = new DeploymentNotification(this, this.nextSequenceNumber(), _d, 0);
        this.sendNotification(evt);
        this.startModules(_d, appCl, oldCl);
        evt = new DeploymentNotification(this, this.nextSequenceNumber(), _d, 1);
        this.sendNotification(evt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startModules(Deployment _d, ClassLoader appCl, ClassLoader oldCl) throws J2eeDeploymentException {
        Deployment.Module m = null;
        String moduleName = null;
        try {
            try {
                String[] jarUrls;
                moduleName = _d.name;
                Vector<String> tmp = new Vector<String>();
                Iterator it = ((AbstractList)_d.ejbModules).iterator();
                while (true) {
                    if (!it.hasNext()) {
                        jarUrls = new String[tmp.size()];
                        tmp.toArray(jarUrls);
                    }
                    m = (Deployment.Module)it.next();
                    tmp.add(m.localUrls.firstElement().toString());
                }
                this.server.invoke(this.jarDeployer, "deploy", new Object[]{_d.localUrl.toString(), jarUrls, moduleName}, new String[]{(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = J2eeDeployer.class$("java.lang.String"))).getName(), (array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = J2eeDeployer.class$("[Ljava.lang.String;"))).getName(), (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = J2eeDeployer.class$("java.lang.String"))).getName()});
                it = ((AbstractList)_d.webModules).iterator();
                if (it.hasNext() && !this.warDeployerAvailable()) {
                    throw new J2eeDeploymentException("application contains war files but no web container available");
                }
                while (it.hasNext()) {
                    m = (Deployment.Module)it.next();
                    moduleName = m.name;
                    this.log.info("Starting module " + moduleName);
                    this.server.invoke(this.warDeployer, "deploy", new Object[]{m.webContext, m.localUrls.firstElement().toString()}, new String[]{"java.lang.String", "java.lang.String"});
                    Thread.currentThread().setContextClassLoader(appCl);
                }
            }
            catch (MBeanException e) {
                this.log.error("Starting " + moduleName + " failed!");
                e.getTargetException().printStackTrace();
                throw new J2eeDeploymentException("Error while starting " + moduleName + ": " + e.getTargetException().getMessage(), e.getTargetException());
            }
            catch (RuntimeErrorException e) {
                this.log.error("Starting " + moduleName + " failed!");
                e.getTargetError().printStackTrace();
                throw new J2eeDeploymentException("Error while starting " + moduleName + ": " + e.getTargetError().getMessage(), e.getTargetError());
            }
            catch (RuntimeMBeanException e) {
                this.log.error("Starting " + moduleName + " failed!");
                e.getTargetException().printStackTrace();
                throw new J2eeDeploymentException("Error while starting " + moduleName + ": " + e.getTargetException().getMessage(), e.getTargetException());
            }
            catch (JMException e) {
                this.log.error("Starting failed!");
                e.printStackTrace();
                throw new J2eeDeploymentException("Fatal error while interacting with deployer MBeans... " + e.getMessage());
            }
            Object var8_13 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    protected void startService() throws Exception {
        if (!this.warDeployerAvailable()) {
            this.log.info("No web container found - only EJB deployment available...");
        }
        this.log.info("Cleaning up deployment directory");
        this.installer.unclutter();
    }

    protected void stopApplication(Deployment _d) throws J2eeDeploymentException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        StringBuffer error = new StringBuffer();
        DeploymentNotification evt = new DeploymentNotification(this, this.nextSequenceNumber(), _d, 2);
        this.sendNotification(evt);
        if (this.warDeployer != null) {
            Iterator webModules = ((AbstractList)_d.webModules).iterator();
            while (webModules.hasNext()) {
                Deployment.Module m = (Deployment.Module)webModules.next();
                this.stopModule(this.warDeployer, m.name, m.localUrls.firstElement().toString(), error);
            }
        } else {
            this.log.warn("Cannot find web container");
        }
        this.stopModule(this.jarDeployer, _d.name, _d.localUrl.toString(), error);
        if (!error.toString().equals("")) {
            throw new J2eeDeploymentException("Error(s) on stopping application " + _d.name + ":\n" + error.toString());
        }
        Thread.currentThread().setContextClassLoader(oldCl);
        evt = new DeploymentNotification(this, this.nextSequenceNumber(), _d, 3);
        this.sendNotification(evt);
    }

    private void stopModule(ObjectName container, String moduleName, String moduleUrl, StringBuffer error) {
        try {
            Object result = this.server.invoke(container, "isDeployed", new Object[]{moduleUrl}, new String[]{"java.lang.String"});
            if (((Boolean)result).booleanValue()) {
                this.log.info("Stopping module " + moduleName);
                this.server.invoke(container, "undeploy", new Object[]{moduleUrl}, new String[]{"java.lang.String"});
            } else {
                this.log.info("Module " + moduleName + " is not running");
            }
        }
        catch (MBeanException _mbe) {
            this.log.error("Unable to stop module " + moduleName + ": " + _mbe.getTargetException().getMessage());
            error.append("Unable to stop module " + moduleName + ": " + _mbe.getTargetException().getMessage());
            error.append("/n");
        }
        catch (JMException _jme) {
            this.log.error("Unable to stop module " + moduleName + ": " + _jme.getMessage());
            error.append("Unable to stop module " + moduleName + ": fatal error while calling " + container + ": " + _jme.getMessage());
            error.append("/n");
        }
    }

    protected void stopService() {
        this.log.info("Undeploying all applications.");
        Deployment[] deps = this.installer.getDeployments();
        int count = 0;
        int i = 0;
        int l = deps.length;
        while (i < l) {
            IOException _ioe2;
            Object var6_5;
            try {
                try {
                    this.stopApplication(deps[i]);
                }
                catch (J2eeDeploymentException _e) {
                    this.log.error("stopApplication", _e);
                }
                var6_5 = null;
            }
            catch (Throwable throwable) {
                var6_5 = null;
                try {
                    this.uninstallApplication(deps[i]);
                }
                catch (IOException _ioe2) {
                    this.log.error("uninstallApplication", _ioe2);
                }
                throw throwable;
            }
            try {
                this.uninstallApplication(deps[i]);
            }
            catch (IOException _ioe2) {
                this.log.error("uninstallApplication", _ioe2);
            }
            ++count;
            ++i;
        }
        this.log.info("Undeployed " + count + " applications.");
    }

    public void undeploy(String _app) throws IOException, J2eeDeploymentException {
        Deployment d = this.installer.findDeployment(_app);
        if (d == null) {
            throw new J2eeDeploymentException("The application \"" + this.name + "\" has not been deployed.");
        }
        try {
            this.stopApplication(d);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.uninstallApplication(d);
            throw throwable;
        }
        this.uninstallApplication(d);
    }

    protected void uninstallApplication(String _pattern) throws IOException {
        Deployment d = this.installer.findDeployment(_pattern);
        if (d != null) {
            this.uninstallApplication(d);
        }
    }

    protected void uninstallApplication(Deployment _d) throws IOException {
        this.log.info("Destroying application " + _d.name);
        this.installer.uninstall(_d);
    }

    protected boolean warDeployerAvailable() {
        return this.server.isRegistered(this.warDeployer);
    }
}

