/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class J2eeModuleMetaData
extends MetaData {
    public static final int EJB = 0;
    public static final int WEB = 1;
    public static final int CLIENT = 2;
    public static final int CONNECTOR = 3;
    private static final String[] tags = new String[]{"ejb", "web", "java", "connector"};
    int type;
    String fileName;
    String alternativeDD;
    String webContext;

    public J2eeModuleMetaData(Element moduleElement) throws DeploymentException {
        this.importXml(moduleElement);
    }

    public String getAlternativeDD() {
        return this.alternativeDD;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getWebContext() {
        if (this.type == 1) {
            return this.webContext;
        }
        return null;
    }

    public void importXml(Element element) throws DeploymentException {
        if (element.getTagName().equals("module")) {
            boolean done = false;
            int i = 0;
            while (i < tags.length) {
                Element child = MetaData.getOptionalChild(element, tags[i]);
                if (child != null) {
                    if (done) {
                        throw new DeploymentException("malformed module definition in application dd: " + element);
                    }
                    this.type = i;
                    switch (this.type) {
                        case 0: 
                        case 2: 
                        case 3: {
                            this.fileName = MetaData.getElementContent(child);
                            this.alternativeDD = MetaData.getElementContent(MetaData.getOptionalChild(element, "alt-dd"));
                            break;
                        }
                        case 1: {
                            this.fileName = MetaData.getElementContent(MetaData.getUniqueChild(child, "web-uri"));
                            this.webContext = MetaData.getElementContent(MetaData.getOptionalChild(child, "context-root"));
                            this.alternativeDD = MetaData.getElementContent(MetaData.getOptionalChild(element, "alt-dd"));
                        }
                    }
                    done = true;
                }
                ++i;
            }
        } else {
            throw new DeploymentException("unrecognized module tag in application dd: " + element);
        }
    }

    public boolean isConnector() {
        return this.type == 3;
    }

    public boolean isEjb() {
        return this.type == 0;
    }

    public boolean isJava() {
        return this.type == 2;
    }

    public boolean isWeb() {
        return this.type == 1;
    }
}

