/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.deployment.Deployment;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.Installer;
import org.jboss.deployment.InstallerFactory;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeDeployer;
import org.jboss.deployment.J2eeDeploymentException;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.deployment.URLWizzard;
import org.jboss.logging.Logger;
import org.jboss.metadata.XmlFileLoader;
import org.w3c.dom.Element;

public class LegacyInstaller
implements Installer {
    File baseDir;
    URL src;
    Deployment d;
    Logger log;
    InstallerFactory factory;
    boolean done;
    private byte[] copyBuffer;
    static int counter = 1000;

    private void copy(InputStream _in, OutputStream _out, boolean _closeInput) throws IOException {
        int read;
        byte[] buffer = this.getCopyBuffer();
        while ((read = _in.read(buffer)) != -1) {
            _out.write(buffer, 0, read);
        }
        _out.flush();
        _out.close();
        if (_closeInput) {
            _in.close();
        }
    }

    private File createTmpDir(File _parent, String _prefix) throws IOException {
        File result = null;
        while ((result = new File(_parent, String.valueOf(_prefix) + LegacyInstaller.nextNumber())).exists()) {
        }
        if (!result.mkdirs()) {
            throw new IOException("couldnt create directory: " + result.getCanonicalPath());
        }
        return result;
    }

    private File createTmpFile(File _parent, String _prefix, String _suffix) throws IOException {
        if (_parent.exists()) {
            if (!_parent.isDirectory()) {
                throw new IOException("parent file " + _parent.getCanonicalPath() + " is not a directory");
            }
        } else if (!_parent.mkdirs()) {
            throw new IOException("couldnt create parent directory: " + _parent.getCanonicalPath());
        }
        File result = null;
        while ((result = new File(_parent, String.valueOf(_prefix) + LegacyInstaller.nextNumber() + _suffix)).exists()) {
        }
        return result;
    }

    private void deleteRecursive(File _file) throws IOException {
        if (_file.exists()) {
            if (_file.isDirectory()) {
                File[] files = _file.listFiles();
                int i = 0;
                int l = files.length;
                while (i < l) {
                    this.deleteRecursive(files[i]);
                    ++i;
                }
            }
            _file.delete();
        }
    }

    private int determineType(JarFile _file) throws J2eeDeploymentException {
        int result = -1;
        ZipEntry dd = null;
        int i = 0;
        while (i < Installer.files.length && dd == null) {
            dd = _file.getEntry(Installer.files[i]);
            result = i++;
        }
        if (dd == null) {
            Enumeration<JarEntry> e = _file.entries();
            while (e.hasMoreElements()) {
                dd = e.nextElement();
                String name = dd.getName();
                int i2 = 0;
                while (i2 < Installer.files.length) {
                    if (name.equalsIgnoreCase(Installer.files[i2])) {
                        throw new J2eeDeploymentException("no deployment descriptor found but file that could be ment as: " + name + " <-> " + Installer.files[i2]);
                    }
                    ++i2;
                }
            }
            throw new J2eeDeploymentException("no deployment descriptor (" + Installer.files[0] + ", " + Installer.files[1] + ", " + Installer.files[2] + ") found");
        }
        return result;
    }

    public Deployment execute(InstallerFactory factory, URL src) throws J2eeDeploymentException, IOException {
        if (this.done) {
            throw new IllegalStateException("this object (" + src + ")is already executed.");
        }
        this.factory = factory;
        this.log = factory.log;
        this.src = src;
        File localCopy = null;
        this.d = new Deployment();
        this.d.name = this.getName(src.toString());
        this.d.sourceUrl = src;
        this.baseDir = new File(factory.baseDir, this.d.name);
        this.d.localUrl = this.baseDir.toURL();
        try {
            try {
                localCopy = this.makeLocalCopy();
                try {
                    this.d.manifest = new JarFile(localCopy).getManifest();
                }
                catch (IOException iOException) {}
                int type = this.determineType(new JarFile(localCopy));
                this.log.info("Create application " + this.d.name);
                switch (type) {
                    case 0: {
                        this.log.info("install EJB module " + this.d.name);
                        File f = this.install(new FileInputStream(localCopy), "ejb");
                        JarFile jar = new JarFile(f);
                        Manifest mf = jar.getManifest();
                        URL[] libs = this.resolveLibraries(mf, src);
                        URL localJar = f.toURL();
                        this.d.addEjbModule(this.d.name, localJar, libs);
                        break;
                    }
                    case 1: {
                        String webContext = "\u0000" + this.d.name;
                        this.log.info("inflate and install WEB module " + this.d.name);
                        File f = this.installInflate(new FileInputStream(localCopy), "web");
                        URL[] libs = new URL[]{};
                        try {
                            FileInputStream mfIn = new FileInputStream(new File(f, "META-INF/MANIFEST.MF"));
                            Manifest mf = new Manifest(mfIn);
                            libs = this.resolveLibraries(mf, src);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        URL localJar = f.toURL();
                        this.d.addWebModule(this.d.name, webContext, localJar, libs);
                        break;
                    }
                    case 2: {
                        JarFile jarFile = new JarFile(localCopy);
                        J2eeApplicationMetaData app = null;
                        try {
                            InputStream in = jarFile.getInputStream(jarFile.getEntry(Installer.files[type]));
                            XmlFileLoader xfl = new XmlFileLoader();
                            Element root = xfl.getDocument(in, Installer.files[type]).getDocumentElement();
                            app = new J2eeApplicationMetaData(root);
                            in.close();
                        }
                        catch (IOException _ioe) {
                            throw new J2eeDeploymentException("Error in accessing application metadata: " + _ioe.getMessage());
                        }
                        catch (DeploymentException _de) {
                            throw new J2eeDeploymentException("Error in parsing application.xml: " + _de.getMessage());
                        }
                        catch (NullPointerException nullPointerException) {
                            throw new J2eeDeploymentException("unexpected error: application.xml was found once but not a second time?!");
                        }
                        File f = null;
                        ArrayList<URL> ejbJars = new ArrayList<URL>();
                        Iterator it = app.getModules();
                        while (it.hasNext()) {
                            InputStream in;
                            String name;
                            J2eeModuleMetaData mod = (J2eeModuleMetaData)it.next();
                            if (mod.isEjb()) {
                                name = mod.getFileName();
                                this.log.info("install EJB module " + name);
                                try {
                                    String ejbJarName = mod.getFileName();
                                    in = jarFile.getInputStream(jarFile.getEntry(ejbJarName));
                                    f = this.install(in, "ejb");
                                    JarFile jar = new JarFile(f);
                                    Manifest mf = jar.getManifest();
                                    URL jarURL = new URL("jar:file:" + localCopy.getAbsolutePath() + "!/");
                                    URL[] libs = this.resolveLibraries(mf, jarURL);
                                    URL localJar = f.toURL();
                                    this.d.addEjbModule(name, localJar, libs);
                                    ejbJars.add(localJar);
                                    continue;
                                }
                                catch (IOException _ioe) {
                                    throw _ioe;
                                }
                                catch (NullPointerException nullPointerException) {
                                    this.log.info("module " + name + " not found in " + this.d.name);
                                    throw new J2eeDeploymentException("module " + name + " not found in " + this.d.name);
                                }
                            }
                            if (!mod.isWeb()) continue;
                            name = mod.getFileName();
                            String webContext = mod.getWebContext();
                            this.log.info("inflate and install WEB module " + name);
                            try {
                                in = jarFile.getInputStream(jarFile.getEntry(name));
                                f = this.installInflate(in, "web");
                                URL[] libs = new URL[]{};
                                try {
                                    FileInputStream mfIn = new FileInputStream(new File(f, "META-INF/MANIFEST.MF"));
                                    Manifest mf = new Manifest(mfIn);
                                    URL jarURL = new URL("jar:file:" + localCopy.getAbsolutePath() + "!/");
                                    libs = this.resolveLibraries(mf, jarURL);
                                }
                                catch (FileNotFoundException fileNotFoundException) {}
                                URL localJar = f.toURL();
                                this.d.addWebModule(name, webContext, localJar, libs);
                            }
                            catch (IOException _ioe) {
                                throw _ioe;
                            }
                            catch (NullPointerException nullPointerException) {
                                this.log.info("module " + name + " not found in " + this.d.name);
                                throw new J2eeDeploymentException("module " + name + " not found in " + this.d.name);
                            }
                        }
                        if (ejbJars.size() > 0) {
                            this.log.info("add all ejb jar files to the common classpath");
                        }
                        int e = 0;
                        while (e < ejbJars.size()) {
                            URL jar = (URL)ejbJars.get(e);
                            this.d.commonUrls.add(jar);
                            ++e;
                        }
                        break;
                    }
                }
                this.saveConfig();
            }
            catch (Exception _ex) {
                try {
                    this.deleteRecursive(this.baseDir);
                }
                catch (Exception _e) {
                    this.log.debug("couldnt remove unused files in " + this.baseDir.getAbsolutePath() + ": " + _e.getMessage());
                }
                if (_ex instanceof J2eeDeploymentException) {
                    throw (J2eeDeploymentException)_ex;
                }
                if (_ex instanceof IOException) {
                    throw (IOException)_ex;
                }
                this.log.error("unexpected exception occured", _ex);
                throw new J2eeDeploymentException("unexpected exception occured (see server trace)");
            }
            Object var5_38 = null;
            this.done = true;
        }
        catch (Throwable throwable) {
            Object var5_39 = null;
            this.done = true;
            try {
                if (localCopy != null) {
                    localCopy.delete();
                }
            }
            catch (Exception _e) {
                this.log.debug("couldnt remove temporary copy " + localCopy + ": " + _e.getMessage());
            }
            throw throwable;
        }
        try {
            if (localCopy != null) {
                localCopy.delete();
            }
        }
        catch (Exception _e) {
            this.log.debug("couldnt remove temporary copy " + localCopy + ": " + _e.getMessage());
        }
        return this.d;
    }

    private byte[] getCopyBuffer() {
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[0x100000];
        }
        return this.copyBuffer;
    }

    private String getName(String _url) {
        String result = _url;
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        result = result.substring(result.lastIndexOf("/") + 1);
        return result;
    }

    private void inflate(ZipInputStream _in, File _destDir) throws IOException {
        ZipEntry entry;
        if (_destDir.exists()) {
            this.deleteRecursive(_destDir);
        }
        _destDir.mkdirs();
        while ((entry = _in.getNextEntry()) != null) {
            File dir;
            String name = entry.getName();
            if (entry.isDirectory()) continue;
            int x = name.lastIndexOf("/");
            if (x != -1 && !(dir = new File(_destDir, name.substring(0, x))).exists()) {
                dir.mkdirs();
            }
            File file = new File(_destDir, name);
            FileOutputStream out = new FileOutputStream(file);
            this.copy(_in, out, false);
            long time = entry.getTime();
            if (time <= 0L) continue;
            file.setLastModified(time);
        }
        _in.close();
    }

    private File install(InputStream _in, String _prefix) throws IOException {
        File result = this.createTmpFile(this.baseDir, _prefix, ".jar");
        this.copy(_in, new FileOutputStream(result), true);
        return result;
    }

    private File installInflate(InputStream _in, String _prefix) throws IOException {
        File result = this.createTmpDir(this.baseDir, _prefix);
        this.inflate(new ZipInputStream(_in), result);
        return result;
    }

    private File makeLocalCopy() throws IOException {
        URL dest = null;
        dest = this.src.getProtocol().equals("file") && new File(this.src.getFile()).isDirectory() ? URLWizzard.downloadAndPackTemporary(this.src, this.factory.baseDir.toURL(), "copy", ".zip") : URLWizzard.downloadTemporary(this.src, this.factory.baseDir.toURL(), "copy", ".zip");
        return new File(dest.getFile());
    }

    private static int nextNumber() {
        return ++counter;
    }

    private URL[] resolveLibraries(Manifest mf, URL baseURL) {
        String classPath = null;
        if (mf != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        URL[] libs = new URL[]{};
        if (classPath != null) {
            ArrayList<URL> tmp = new ArrayList<URL>();
            StringTokenizer st = new StringTokenizer(classPath);
            this.log.debug("resolveLibraries: " + classPath);
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                try {
                    URL lib = new URL(baseURL, tk);
                    URL baseDir = this.factory.baseDir.toURL();
                    URL localURL = URLWizzard.downloadTemporary(lib, baseDir, "lib", ".jar");
                    tmp.add(localURL);
                    this.log.debug("added " + lib + " to common classpath");
                }
                catch (IOException _ioe) {
                    this.log.warn("Failed to add " + tk + " to common classpath: " + _ioe.getMessage());
                }
            }
            libs = new URL[tmp.size()];
            tmp.toArray(libs);
        }
        return libs;
    }

    private void saveConfig() throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this.baseDir, J2eeDeployer.CONFIG)));
        out.writeObject(this.d);
        out.flush();
        out.close();
    }
}

