/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class URLWizzard {
    private static byte[] buffer = new byte[524288];
    private static int id = 1000;

    private static void add(JarOutputStream _jout, File _dir, String _prefix) throws IOException {
        File[] content = _dir.listFiles();
        int i = 0;
        int l = content.length;
        while (i < l) {
            if (content[i].isDirectory()) {
                URLWizzard.add(_jout, content[i], String.valueOf(_prefix) + (_prefix.equals("") ? "" : "/") + content[i].getName());
            } else {
                _jout.putNextEntry(new ZipEntry(String.valueOf("".equals(_prefix) ? "" : String.valueOf(_prefix) + "/") + content[i].getName()));
                FileInputStream in = new FileInputStream(content[i]);
                URLWizzard.write(in, _jout);
                in.close();
            }
            ++i;
        }
    }

    public static URL createTempDir(URL _baseDir, String _prefix) throws IOException {
        File f;
        while ((f = new File(_baseDir.getFile(), String.valueOf(_prefix) + URLWizzard.getId())).exists()) {
        }
        f.mkdirs();
        return new URL("file:" + f.getCanonicalPath());
    }

    public static URL createTempFile(URL _baseDir, String _prefix, String _suffix) throws IOException {
        File file;
        File f = new File(_baseDir.getFile());
        if (!f.exists()) {
            f.mkdirs();
        }
        while (!(file = new File(f, String.valueOf(_prefix) + URLWizzard.getId() + _suffix)).createNewFile()) {
        }
        return new URL("file:" + file.getCanonicalPath());
    }

    private static boolean delete(File _f) throws IOException {
        if (_f.exists()) {
            if (_f.isDirectory()) {
                File[] files = _f.listFiles();
                int i = 0;
                int l = files.length;
                while (i < l) {
                    if (!URLWizzard.delete(files[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return _f.delete();
        }
        return true;
    }

    public static void deleteTree(URL _dir) throws IOException {
        if (!_dir.getProtocol().equals("file")) {
            throw new IOException("Protocol not supported");
        }
        File f = new File(_dir.getFile());
        if (!URLWizzard.delete(f)) {
            throw new IOException("deleting " + _dir.toString() + "recursively failed!");
        }
    }

    public static URL download(URL _src, URL _dest) throws IOException {
        if (!_dest.getProtocol().equals("file")) {
            throw new IOException("only file: protocoll is allowed as destination!");
        }
        String s = _dest.getFile();
        File dir = new File(s.substring(0, s.lastIndexOf("/")));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        InputStream in = _src.openStream();
        FileOutputStream out = new FileOutputStream(s);
        URLWizzard.write(in, out);
        ((OutputStream)out).close();
        in.close();
        return _dest;
    }

    public static URL downloadAndInflate(URL _src, URL _dest) throws IOException {
        ZipEntry entry;
        InputStream in = _src.openStream();
        boolean jar = false;
        String jarPath = "";
        String s = _dest.toString();
        if (!_dest.getProtocol().equals("file")) {
            throw new IOException("only file: protocoll is allowed as destination!");
        }
        File base = new File(_dest.getFile());
        if (base.exists()) {
            URLWizzard.deleteTree(_dest);
        }
        base.mkdirs();
        ZipInputStream zin = new ZipInputStream(in);
        while ((entry = zin.getNextEntry()) != null) {
            File dir;
            String name = entry.getName();
            if (entry.isDirectory()) continue;
            int x = name.lastIndexOf("/");
            if (x != -1 && !(dir = new File(String.valueOf(base.getCanonicalPath()) + File.separator + name.substring(0, x))).exists()) {
                dir.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(String.valueOf(base.getCanonicalPath()) + File.separator + name);
            URLWizzard.write(zin, out);
            ((OutputStream)out).close();
        }
        zin.close();
        return _dest;
    }

    public static URL downloadAndInflateTemporary(URL _src, URL _destDir, String _prefix) throws IOException {
        return URLWizzard.downloadAndInflate(_src, URLWizzard.createTempDir(_destDir, _prefix));
    }

    public static void downloadAndPack(URL _src, URL _dest) throws IOException {
        if (!_dest.getProtocol().equals("file")) {
            throw new IOException("only file: protocoll is allowed as destination!");
        }
        if (!_src.getProtocol().equals("file")) {
            throw new IOException("only file: protocoll is allowed as source!");
        }
        String s = _dest.getFile();
        File dir = new File(s.substring(0, s.lastIndexOf("/")));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(_dest.getFile()));
        URLWizzard.add(jout, new File(_src.getFile()), "");
        jout.close();
    }

    public static URL downloadAndPackTemporary(URL _src, URL _destDir, String _prefix, String _suffix) throws IOException {
        if (!_destDir.getProtocol().equals("file")) {
            throw new IOException("only file: protocoll is allowed as destination!");
        }
        if (!_src.getProtocol().equals("file")) {
            throw new IOException("only file: protocoll is allowed as source!");
        }
        File dest = new File(URLWizzard.createTempFile(_destDir, _prefix, _suffix).getFile());
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(dest));
        URLWizzard.add(jout, new File(_src.getFile()), "");
        jout.close();
        return dest.toURL();
    }

    public static URL downloadTemporary(URL _src, URL _destDirectory, String _prefix, String _suffix) throws IOException {
        return URLWizzard.download(_src, URLWizzard.createTempFile(_destDirectory, _prefix, _suffix));
    }

    private static String getId() {
        return String.valueOf(++id);
    }

    public static void main(String[] _args) throws Exception {
        URLWizzard.downloadAndPack(new URL(_args[0]), new URL(_args[1]));
    }

    private static synchronized void write(InputStream _in, OutputStream _out) throws IOException {
        int read;
        while ((read = _in.read(buffer)) != -1) {
            _out.write(buffer, 0, read);
        }
        _out.flush();
    }
}

