/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.HashMap;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;

public class BeanLockManager {
    private HashMap map = new HashMap();
    private Container container;
    private boolean reentrant = false;
    private int txTimeout = 5000;
    public Class lockClass;

    public synchronized boolean canPassivate(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Attempt to passivate with a null object");
        }
        BeanLock lock = (BeanLock)this.map.get(id);
        if (lock == null) {
            throw new IllegalStateException("Attempt to passivate without a lock");
        }
        return lock.getRefs() > 1;
    }

    public synchronized BeanLock getLock(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Attempt to get lock ref with a null object");
        }
        BeanLock lock = (BeanLock)this.map.get(id);
        if (lock == null) {
            try {
                lock = (BeanLock)this.lockClass.newInstance();
                lock.setId(id);
                lock.setReentrant(this.reentrant);
                lock.setTimeout(this.txTimeout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.map.put(id, lock);
        }
        lock.addRef();
        return lock;
    }

    public synchronized void removeLockRef(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Attempt to remove lock ref with a null object");
        }
        BeanLock lock = (BeanLock)this.map.get(id);
        if (lock != null) {
            lock.removeRef();
            if (lock.getRefs() <= 0) {
                this.map.remove(lock.getId());
            }
        }
    }

    public void setLockCLass(Class lockClass) {
        this.lockClass = lockClass;
    }

    public void setReentrant(boolean reentrant) {
        this.reentrant = reentrant;
    }
}

