/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Application;
import org.jboss.ejb.BeanLockManager;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.LocalContainerInvoker;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.local.BaseLocalContainerInvoker;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.naming.Util;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;

public abstract class Container {
    protected Logger log = Logger.getLogger(this.getClass());
    protected Application application;
    protected ClassLoader localClassLoader;
    protected ClassLoader classLoader;
    protected BeanMetaData metaData;
    protected Class beanClass;
    protected TransactionManager tm;
    protected AuthenticationManager sm;
    protected RealmMapping rm;
    protected Object securityProxy;
    protected LocalContainerInvoker localContainerInvoker = new BaseLocalContainerInvoker();
    private HashMap methodPermissionsCache = new HashMap();
    protected Class localHomeInterface;
    protected Class localInterface;
    protected BeanLockManager lockManager;

    public abstract void addInterceptor(Interceptor var1);

    public Object createBeanClassInstance() throws Exception {
        return this.getBeanClass().newInstance();
    }

    abstract Interceptor createContainerInterceptor();

    public void destroy() {
        this.localContainerInvoker.destroy();
        this.localContainerInvoker = null;
        this.classLoader = null;
        this.localClassLoader = null;
        this.methodPermissionsCache.clear();
        this.application.removeLocalHome(this);
        this.application = null;
    }

    public Application getApplication() {
        return this.application;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public BeanMetaData getBeanMetaData() {
        return this.metaData;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getLocalClass() {
        return this.localInterface;
    }

    public ClassLoader getLocalClassLoader() {
        return this.localClassLoader;
    }

    public Class getLocalHomeClass() {
        return this.localHomeInterface;
    }

    public BeanLockManager getLockManager() {
        return this.lockManager;
    }

    public Set getMethodPermissions(Method m, boolean home) {
        Set permissions;
        if (this.methodPermissionsCache.containsKey(m)) {
            permissions = (Set)this.methodPermissionsCache.get(m);
        } else {
            permissions = this.getBeanMetaData().getMethodPermissions(m.getName(), m.getParameterTypes(), home ^ true);
            this.methodPermissionsCache.put(m, permissions);
        }
        return permissions;
    }

    public RealmMapping getRealmMapping() {
        return this.rm;
    }

    public AuthenticationManager getSecurityManager() {
        return this.sm;
    }

    public Object getSecurityProxy() {
        return this.securityProxy;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void init() throws Exception {
        this.beanClass = this.classLoader.loadClass(this.metaData.getEjbClass());
        if (this.metaData.getLocalHome() != null) {
            this.localHomeInterface = this.classLoader.loadClass(this.metaData.getLocalHome());
        }
        if (this.metaData.getLocal() != null) {
            this.localInterface = this.classLoader.loadClass(this.metaData.getLocal());
        }
        this.localContainerInvoker.setContainer(this);
        this.localContainerInvoker.init();
        if (this.localHomeInterface != null) {
            this.application.addLocalHome(this, this.localContainerInvoker.getEJBLocalHome());
        }
        this.setupEnvironment();
    }

    public abstract Object invoke(MethodInvocation var1) throws Exception;

    public abstract Object invokeHome(MethodInvocation var1) throws Exception;

    public void setApplication(Application app) {
        if (app == null) {
            throw new IllegalArgumentException("Null application");
        }
        this.application = app;
    }

    public void setBeanMetaData(BeanMetaData metaData) {
        this.metaData = metaData;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public void setLocalClassLoader(ClassLoader cl) {
        this.localClassLoader = cl;
    }

    public void setLockManager(BeanLockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setRealmMapping(RealmMapping rm) {
        this.rm = rm;
    }

    public void setSecurityManager(AuthenticationManager sm) {
        this.sm = sm;
    }

    public void setSecurityProxy(Object proxy) {
        this.securityProxy = proxy;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    private void setupEnvironment() throws DeploymentException {
        try {
            BeanMetaData beanMetaData = this.getBeanMetaData();
            this.log.debug("Begin java:comp/env for EJB: " + beanMetaData.getEjbName());
            this.log.debug("TCL: " + Thread.currentThread().getContextClassLoader());
            Context ctx = (Context)new InitialContext().lookup("java:comp");
            Context envCtx = ctx.createSubcontext("env");
            Iterator iterator = beanMetaData.getEnvironmentEntries();
            while (iterator.hasNext()) {
                EnvEntryMetaData entry = (EnvEntryMetaData)iterator.next();
                try {
                    this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
                    EnvEntryMetaData.bindEnvEntry(envCtx, entry);
                }
                catch (ClassNotFoundException e) {
                    this.log.error("env-entry bind failed", e);
                    throw new DeploymentException("Could not set up environment", e);
                }
            }
            enum = beanMetaData.getEjbReferences();
            while (enum.hasNext()) {
                EjbRefMetaData ref = (EjbRefMetaData)enum.next();
                this.log.debug("Binding an EJBReference " + ref.getName());
                if (ref.getLink() != null) {
                    this.log.debug("Binding " + ref.getName() + " to internal JNDI source: " + ref.getLink());
                    Container refContainer = this.getApplication().getContainer(ref.getLink());
                    if (refContainer == null) {
                        throw new DeploymentException("Bean " + ref.getLink() + " not found within this application.");
                    }
                    Util.bind(envCtx, ref.getName(), (Object)new LinkRef(refContainer.getBeanMetaData().getJndiName()));
                    continue;
                }
                if (ref.getJndiName() == null) {
                    throw new DeploymentException("ejb-ref " + ref.getName() + ", expected either ejb-link in ejb-jar.xml or jndi-name in jboss.xml");
                }
                this.log.debug("Binding " + ref.getName() + " to external JNDI source: " + ref.getJndiName());
                Util.bind(envCtx, ref.getName(), (Object)new LinkRef(ref.getJndiName()));
            }
            enum = beanMetaData.getEjbLocalReferences();
            String localJndiName = beanMetaData.getLocalJndiName();
            while (enum.hasNext()) {
                EjbLocalRefMetaData ref = (EjbLocalRefMetaData)enum.next();
                String refName = ref.getName();
                this.log.debug("Binding an EJBLocalReference " + refName);
                if (ref.getLink() != null) {
                    String refLink = ref.getLink();
                    this.log.debug("Binding " + refName + " to bean source: " + refLink);
                    Container refContainer = this.getApplication().getContainer(refLink);
                    if (refContainer == null) {
                        throw new DeploymentException("Bean " + refLink + " not found within this application.");
                    }
                    Util.bind(envCtx, refName, (Object)new LinkRef(refContainer.getBeanMetaData().getLocalJndiName()));
                    continue;
                }
                throw new DeploymentException("Local references currently require ejb-link");
            }
            enum = beanMetaData.getResourceReferences();
            ApplicationMetaData application = beanMetaData.getApplicationMetaData();
            while (enum.hasNext()) {
                ResourceRefMetaData ref = (ResourceRefMetaData)enum.next();
                String resourceName = ref.getResourceName();
                String finalName = application.getResourceByName(resourceName);
                if (finalName == null) {
                    finalName = ref.getJndiName();
                }
                if (finalName == null) {
                    if (ref.getType().equals("javax.sql.DataSource")) {
                        InitialContext dsCtx = new InitialContext();
                        try {
                            dsCtx.lookup("java:/DefaultDS");
                            finalName = "java:/DefaultDS";
                        }
                        catch (Exception e) {
                            this.log.debug(e);
                        }
                    }
                    if (finalName == null) {
                        this.log.warn("No resource manager found for " + ref.getResourceName());
                        continue;
                    }
                }
                if (ref.getType().equals("java.net.URL")) {
                    try {
                        this.log.debug("Binding URL: " + finalName + " to JDNI ENC as: " + ref.getRefName());
                        Util.bind(envCtx, ref.getRefName(), (Object)new URL(finalName));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new NamingException("Malformed URL:" + e.getMessage());
                    }
                }
                this.log.debug("Binding resource manager: " + finalName + " to JDNI ENC as: " + ref.getRefName());
                Util.bind(envCtx, ref.getRefName(), (Object)new LinkRef(finalName));
            }
            enum = beanMetaData.getResourceEnvReferences();
            while (enum.hasNext()) {
                ResourceEnvRefMetaData resRef = (ResourceEnvRefMetaData)enum.next();
                String encName = resRef.getRefName();
                String jndiName = resRef.getJndiName();
                this.log.debug("Binding env resource: " + jndiName + " to JDNI ENC as: " + encName);
                Util.bind(envCtx, encName, (Object)new LinkRef(jndiName));
            }
            String securityDomain = this.metaData.getContainerConfiguration().getSecurityDomain();
            if (securityDomain == null) {
                securityDomain = this.metaData.getApplicationMetaData().getSecurityDomain();
            }
            if (securityDomain != null) {
                this.log.debug("Binding securityDomain: " + securityDomain + " to JDNI ENC as: security/security-domain");
                Util.bind(envCtx, "security/security-domain", (Object)new LinkRef(securityDomain));
                Util.bind(envCtx, "security/subject", (Object)new LinkRef(String.valueOf(securityDomain) + "/subject"));
            }
            this.log.debug("End java:comp/env for EJB: " + beanMetaData.getEjbName());
        }
        catch (NamingException e) {
            this.log.error("Could not set up environment", e);
            throw new DeploymentException("Could not set up environment", e);
        }
    }

    public void start() throws Exception {
        this.localContainerInvoker.start();
    }

    public void stop() {
        this.localContainerInvoker.stop();
    }
}

