/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.log4j.NDC;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Application;
import org.jboss.ejb.BeanLockManager;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerFactoryMBean;
import org.jboss.ejb.ContainerInvoker;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityPersistenceManager;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.ejb.plugins.CMPPersistenceManager;
import org.jboss.ejb.plugins.SecurityProxyInterceptor;
import org.jboss.ejb.plugins.StatefulSessionInstancePool;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.metadata.XmlLoadable;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.util.MBeanProxy;
import org.jboss.util.ServiceMBeanSupport;
import org.jboss.verifier.BeanVerifier;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationListener;
import org.jboss.web.WebClassLoader;
import org.jboss.web.WebServiceMBean;
import org.w3c.dom.Element;

public class ContainerFactory
extends ServiceMBeanSupport
implements ContainerFactoryMBean {
    public static String DEFAULT_STATELESS_CONFIGURATION = "Default Stateless SessionBean";
    public static String DEFAULT_STATEFUL_CONFIGURATION = "Default Stateful SessionBean";
    public static String DEFAULT_ENTITY_BMP_CONFIGURATION = "Default BMP EntityBean";
    public static String DEFAULT_ENTITY_CMP_CONFIGURATION = "Default CMP EntityBean";
    public static String DEFAULT_MESSAGEDRIVEN_CONFIGURATION = "Default MesageDriven Bean";
    public static final int BMT = 1;
    public static final int CMT = 2;
    public static final int ANY = 3;
    static final String BMT_VALUE = "Bean";
    static final String CMT_VALUE = "Container";
    static final String ANY_VALUE = "Both";
    File tmpDir;
    Logger log = Logger.getLogger(class$org$jboss$ejb$ContainerFactory != null ? class$org$jboss$ejb$ContainerFactory : (class$org$jboss$ejb$ContainerFactory = ContainerFactory.class$("org.jboss.ejb.ContainerFactory")));
    HashMap deployments = new HashMap();
    boolean verifyDeployments = false;
    boolean verifierVerbose = false;
    boolean metricsEnabled = false;
    private boolean m_beanCacheJMSMonitoring;
    private boolean validateDTDs;
    static /* synthetic */ Class class$org$jboss$ejb$ContainerFactory;
    static /* synthetic */ Class class$org$jboss$web$WebServiceMBean;

    private void addInterceptors(Container container, int transType, Element element) {
        Iterator interceptorElements = MetaData.getChildrenByTagName(element, "interceptor");
        String transTypeString = ContainerFactory.stringTransactionValue(transType);
        ClassLoader loader = container.getClassLoader();
        ArrayList<Interceptor> istack = new ArrayList<Interceptor>();
        while (interceptorElements != null && interceptorElements.hasNext()) {
            Element ielement = (Element)interceptorElements.next();
            String transAttr = ielement.getAttribute("transaction");
            if (transAttr == null || transAttr.length() == 0) {
                transAttr = ANY_VALUE;
            }
            if (!transAttr.equalsIgnoreCase(ANY_VALUE) && !transAttr.equalsIgnoreCase(transTypeString)) continue;
            String metricsAttr = ielement.getAttribute("metricsEnabled");
            boolean metricsInterceptor = metricsAttr.equalsIgnoreCase("true");
            if (!this.metricsEnabled && metricsInterceptor) continue;
            String className = null;
            try {
                className = MetaData.getElementContent(ielement);
                Class<?> clazz = loader.loadClass(className);
                Interceptor interceptor = (Interceptor)clazz.newInstance();
                istack.add(interceptor);
            }
            catch (Exception e) {
                this.log.warn("Could not load the " + className + " interceptor for this container", e);
            }
        }
        if (istack.size() == 0) {
            this.log.warn("There are no interceptors configured. Check the standardjboss.xml file");
        }
        int i = 0;
        while (i < istack.size()) {
            Interceptor interceptor = (Interceptor)istack.get(i);
            container.addInterceptor(interceptor);
            ++i;
        }
        if (container.getSecurityProxy() != null) {
            container.addInterceptor(new SecurityProxyInterceptor());
        }
        container.addInterceptor(container.createContainerInterceptor());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static BeanLockManager createBeanLockManager(boolean reentrant, String beanLock, ClassLoader cl) throws Exception {
        BeanLockManager lockManager = new BeanLockManager();
        Class<?> lockClass = null;
        try {
            lockClass = cl.loadClass(beanLock);
        }
        catch (Exception e) {
            throw new DeploymentException("Missing or invalid lock class (in jboss.xml or standardjboss.xml): " + beanLock + " - " + e);
        }
        lockManager.setLockCLass(lockClass);
        lockManager.setReentrant(reentrant);
        return lockManager;
    }

    private Container createContainer(BeanMetaData bean, ClassLoader cl, ClassLoader localCl) throws Exception {
        if (bean.isMessageDriven()) {
            return this.createMessageDrivenContainer(bean, cl, localCl);
        }
        if (bean.isSession()) {
            if (((SessionMetaData)bean).isStateless()) {
                return this.createStatelessSessionContainer(bean, cl, localCl);
            }
            return this.createStatefulSessionContainer(bean, cl, localCl);
        }
        return this.createEntityContainer(bean, cl, localCl);
    }

    private static ContainerInvoker createContainerInvoker(ConfigurationMetaData conf, ClassLoader cl) throws Exception {
        ContainerInvoker ci = null;
        try {
            ci = (ContainerInvoker)cl.loadClass(conf.getContainerInvoker()).newInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Missing or invalid Container Invoker (in jboss.xml or standardjboss.xml): " + conf.getContainerInvoker() + " - " + e);
        }
        if (ci instanceof XmlLoadable) {
            ((XmlLoadable)((Object)ci)).importXml(conf.getContainerInvokerConf());
        }
        return ci;
    }

    private EntityContainer createEntityContainer(BeanMetaData bean, ClassLoader cl, ClassLoader localCl) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        EntityContainer container = new EntityContainer();
        int transType = 2;
        this.initializeContainer(container, conf, bean, transType, cl, localCl);
        if (bean.getHome() != null) {
            container.setContainerInvoker(ContainerFactory.createContainerInvoker(conf, cl));
        }
        container.setInstanceCache(ContainerFactory.createInstanceCache(conf, this.m_beanCacheJMSMonitoring, cl));
        container.setInstancePool(ContainerFactory.createInstancePool(conf, cl));
        container.setLockManager(ContainerFactory.createBeanLockManager(((EntityMetaData)bean).isReentrant(), conf.getLockClass(), cl));
        if (((EntityMetaData)bean).isBMP()) {
            container.setPersistenceManager((EntityPersistenceManager)cl.loadClass(conf.getPersistenceManager()).newInstance());
        } else {
            CMPPersistenceManager persistenceManager = new CMPPersistenceManager();
            persistenceManager.setPersistenceStore((EntityPersistenceStore)cl.loadClass(conf.getPersistenceManager()).newInstance());
            container.setPersistenceManager(persistenceManager);
        }
        return container;
    }

    private static InstanceCache createInstanceCache(ConfigurationMetaData conf, boolean jmsMonitoring, ClassLoader cl) throws Exception {
        InstanceCache ic = null;
        try {
            ic = (InstanceCache)cl.loadClass(conf.getInstanceCache()).newInstance();
            if (ic instanceof AbstractInstanceCache) {
                ((AbstractInstanceCache)ic).setJMSMonitoringEnabled(jmsMonitoring);
            }
        }
        catch (Exception exception) {
            throw new DeploymentException("Missing or invalid Instance Cache (in jboss.xml or standardjboss.xml)");
        }
        if (ic instanceof XmlLoadable) {
            ((XmlLoadable)((Object)ic)).importXml(conf.getContainerCacheConf());
        }
        return ic;
    }

    private static InstancePool createInstancePool(ConfigurationMetaData conf, ClassLoader cl) throws Exception {
        InstancePool ip = null;
        try {
            ip = (InstancePool)cl.loadClass(conf.getInstancePool()).newInstance();
        }
        catch (Exception exception) {
            throw new DeploymentException("Missing or invalid Instance Pool (in jboss.xml or standardjboss.xml)");
        }
        if (ip instanceof XmlLoadable) {
            ((XmlLoadable)((Object)ip)).importXml(conf.getContainerPoolConf());
        }
        return ip;
    }

    private MessageDrivenContainer createMessageDrivenContainer(BeanMetaData bean, ClassLoader cl, ClassLoader localCl) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        MessageDrivenContainer container = new MessageDrivenContainer();
        int transType = ((MessageDrivenMetaData)bean).isContainerManagedTx() ? 2 : 1;
        this.initializeContainer(container, conf, bean, transType, cl, localCl);
        container.setContainerInvoker(ContainerFactory.createContainerInvoker(conf, cl));
        container.setInstancePool(ContainerFactory.createInstancePool(conf, cl));
        return container;
    }

    private StatefulSessionContainer createStatefulSessionContainer(BeanMetaData bean, ClassLoader cl, ClassLoader localCl) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        StatefulSessionContainer container = new StatefulSessionContainer();
        int transType = ((SessionMetaData)bean).isContainerManagedTx() ? 2 : 1;
        this.initializeContainer(container, conf, bean, transType, cl, localCl);
        if (bean.getHome() != null) {
            container.setContainerInvoker(ContainerFactory.createContainerInvoker(conf, cl));
        }
        container.setInstanceCache(ContainerFactory.createInstanceCache(conf, this.m_beanCacheJMSMonitoring, cl));
        StatefulSessionInstancePool ip = new StatefulSessionInstancePool();
        ip.importXml(conf.getContainerPoolConf());
        container.setInstancePool(ip);
        container.setPersistenceManager((StatefulSessionPersistenceManager)cl.loadClass(conf.getPersistenceManager()).newInstance());
        container.setLockManager(ContainerFactory.createBeanLockManager(false, conf.getLockClass(), cl));
        return container;
    }

    private StatelessSessionContainer createStatelessSessionContainer(BeanMetaData bean, ClassLoader cl, ClassLoader localCl) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        StatelessSessionContainer container = new StatelessSessionContainer();
        int transType = ((SessionMetaData)bean).isContainerManagedTx() ? 2 : 1;
        this.initializeContainer(container, conf, bean, transType, cl, localCl);
        if (bean.getHome() != null) {
            container.setContainerInvoker(ContainerFactory.createContainerInvoker(conf, cl));
        }
        container.setInstancePool(ContainerFactory.createInstancePool(conf, cl));
        return container;
    }

    public void deploy(String url, String appId) throws MalformedURLException, DeploymentException {
        this.deploy(new URL(url), appId);
    }

    public void deploy(String appUrl, String[] jarUrls, String appId) throws MalformedURLException, DeploymentException {
        URL[] tmp = new URL[jarUrls.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = new URL(jarUrls[i]);
            ++i;
        }
        this.deploy(new URL(appUrl), tmp, appId);
    }

    public synchronized void deploy(URL url, String appId) throws DeploymentException {
        this.deploy(url, new URL[]{url}, appId);
    }

    public synchronized void deploy(URL appUrl, URL[] jarUrls, String appId) throws DeploymentException {
        Application app = new Application();
        try {
            if (this.deployments.containsKey(appUrl)) {
                this.undeploy(appUrl);
            }
            app.setURL(appUrl);
            this.log.info("Deploying:" + appUrl);
            WebClassLoader cl = new WebClassLoader(jarUrls, Thread.currentThread().getContextClassLoader());
            app.setClassLoader(cl);
            WebServiceMBean webServer = (WebServiceMBean)MBeanProxy.create(class$org$jboss$web$WebServiceMBean != null ? class$org$jboss$web$WebServiceMBean : (class$org$jboss$web$WebServiceMBean = ContainerFactory.class$("org.jboss.web.WebServiceMBean")), ":service=Webserver");
            URL[] codebase = new URL[]{webServer.addClassLoader(cl)};
            cl.setWebURLs(codebase);
            int i = 0;
            while (i < jarUrls.length) {
                this.deploy(app, jarUrls[i], cl);
                ++i;
            }
            app.init();
            app.start();
            Iterator i2 = app.containers.values().iterator();
            while (i2.hasNext()) {
                this.handleContainerManagement((Container)i2.next(), true);
            }
            this.log.info("Deployed application: " + app.getName());
            this.deployments.put(appUrl, app);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                this.log.error("InternalError", e);
            } else {
                this.log.error("DeploymentError", e);
            }
            app.stop();
            app.destroy();
            throw new DeploymentException("Could not deploy " + appUrl.toString(), e);
        }
    }

    private void deploy(Application app, URL url, ClassLoader cl) throws NamingException, Exception {
        XmlFileLoader efm = new XmlFileLoader(this.validateDTDs);
        URLClassLoader localCl = new URLClassLoader(new URL[]{url});
        efm.setClassLoader(localCl);
        ApplicationMetaData metaData = efm.load();
        NDC.push((String)"Verifier");
        try {
            if (this.verifyDeployments) {
                BeanVerifier verifier = new BeanVerifier();
                verifier.addVerificationListener(new VerificationListener(){

                    public void beanChecked(VerificationEvent event) {
                        ContainerFactory.this.log.debug(event.getMessage());
                    }

                    public void specViolation(VerificationEvent event) {
                        if (ContainerFactory.this.verifierVerbose) {
                            ContainerFactory.this.log.error(event.getVerbose());
                        } else {
                            ContainerFactory.this.log.error(event.getMessage());
                        }
                    }
                });
                this.log.debug("Verifying " + url);
                verifier.verify(url, metaData, cl);
            }
        }
        catch (Throwable t) {
            this.log.error("Verify failure", t);
        }
        NDC.pop();
        Iterator beans = metaData.getEnterpriseBeans();
        InitialContext ctx = new InitialContext();
        while (beans.hasNext()) {
            BeanMetaData bean = (BeanMetaData)beans.next();
            this.log.info("Deploying " + bean.getEjbName());
            app.addContainer(this.createContainer(bean, cl, localCl));
        }
    }

    public void destroyService() {
        Iterator apps = this.deployments.values().iterator();
        while (apps.hasNext()) {
            Application app = (Application)apps.next();
            app.destroy();
        }
        this.deployments.clear();
    }

    public Iterator getDeployedApplications() {
        HashMap tmp = (HashMap)this.deployments.clone();
        return tmp.values().iterator();
    }

    public String getName() {
        return "Container factory";
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(":service=ContainerFactory");
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public boolean getVerifierVerbose() {
        return this.verifierVerbose;
    }

    public boolean getVerifyDeployments() {
        return this.verifyDeployments;
    }

    private void handleContainerManagement(Container container, boolean doStart) {
    }

    private void initializeContainer(Container container, ConfigurationMetaData conf, BeanMetaData bean, int transType, ClassLoader cl, ClassLoader localCl) throws NamingException, DeploymentException {
        String securityProxyClassName;
        container.setClassLoader(new URLClassLoader(new URL[0], cl));
        container.setLocalClassLoader(new URLClassLoader(new URL[0], localCl));
        container.setBeanMetaData(bean);
        InitialContext iniCtx = new InitialContext();
        container.setTransactionManager((TransactionManager)iniCtx.lookup("java:/TransactionManager"));
        String securityDomain = bean.getApplicationMetaData().getSecurityDomain();
        String confSecurityDomain = conf.getSecurityDomain();
        if (securityDomain != null || confSecurityDomain != null) {
            try {
                if (confSecurityDomain == null) {
                    confSecurityDomain = securityDomain;
                }
                System.out.println("lookup securityDomain manager name: " + confSecurityDomain);
                Object securityMgr = iniCtx.lookup(confSecurityDomain);
                AuthenticationManager ejbS = (AuthenticationManager)securityMgr;
                RealmMapping rM = (RealmMapping)securityMgr;
                container.setSecurityManager(ejbS);
                container.setRealmMapping(rM);
            }
            catch (NamingException ne) {
                throw new DeploymentException("Could not find the Security Manager specified for this container, name=" + confSecurityDomain, ne);
            }
        }
        if ((securityProxyClassName = bean.getSecurityProxy()) != null) {
            try {
                Class<?> proxyClass = cl.loadClass(securityProxyClassName);
                Object proxy = proxyClass.newInstance();
                container.setSecurityProxy(proxy);
                System.out.println("setSecurityProxy, " + proxy);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to create SecurityProxy of type: " + securityProxyClassName + ", " + conf.getContainerInvoker() + " - " + e);
            }
        }
        this.addInterceptors(container, transType, conf.getContainerInterceptorsConf());
    }

    public boolean isDeployed(String url) throws MalformedURLException {
        return this.isDeployed(new URL(url));
    }

    public boolean isDeployed(URL url) {
        return this.deployments.get(url) != null;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void setBeanCacheJMSMonitoringEnabled(boolean enable) {
        this.m_beanCacheJMSMonitoring = enable;
    }

    public void setMetricsEnabled(boolean enable) {
        this.metricsEnabled = enable;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    public void setVerifierVerbose(boolean verbose) {
        this.verifierVerbose = verbose;
    }

    public void setVerifyDeployments(boolean verify) {
        this.verifyDeployments = verify;
    }

    public void stopService() {
        Iterator apps = this.deployments.values().iterator();
        while (apps.hasNext()) {
            Application app = (Application)apps.next();
            app.stop();
        }
    }

    private static String stringTransactionValue(int transType) {
        String transaction = ANY_VALUE;
        switch (transType) {
            case 1: {
                transaction = BMT_VALUE;
                break;
            }
            case 2: {
                transaction = CMT_VALUE;
                break;
            }
        }
        return transaction;
    }

    public void undeploy(String url) throws MalformedURLException, DeploymentException {
        this.undeploy(new URL(url));
    }

    public void undeploy(URL url) throws DeploymentException {
        Application app = (Application)this.deployments.get(url);
        if (app == null) {
            throw new DeploymentException("URL not deployed");
        }
        this.log.info("Undeploying:" + url);
        Iterator i = app.containers.values().iterator();
        while (i.hasNext()) {
            this.handleContainerManagement((Container)i.next(), false);
        }
        app.stop();
        app.destroy();
        try {
            try {
                if (app.getClassLoader() != null) {
                    WebServiceMBean webServer = (WebServiceMBean)MBeanProxy.create(class$org$jboss$web$WebServiceMBean != null ? class$org$jboss$web$WebServiceMBean : (class$org$jboss$web$WebServiceMBean = ContainerFactory.class$("org.jboss.web.WebServiceMBean")), ":service=Webserver");
                    webServer.removeClassLoader(app.getClassLoader());
                }
            }
            catch (Exception e) {
                throw new DeploymentException("Error during undeploy of " + app.getURL().toString(), e);
            }
            Object var5_6 = null;
            this.deployments.remove(url);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.deployments.remove(url);
            this.log.info("Undeployed application: " + app.getName());
            throw throwable;
        }
        this.log.info("Undeployed application: " + app.getName());
    }
}

