/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.ArrayList;
import java.util.HashMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.EntityEnterpriseContext;

public class GlobalTxEntityMap {
    protected HashMap m_map = new HashMap();

    public synchronized void associate(Transaction tx, EntityEnterpriseContext entity) throws RollbackException, SystemException {
        ArrayList<EntityEnterpriseContext> entityList = (ArrayList<EntityEnterpriseContext>)this.m_map.get(tx);
        if (entityList == null) {
            entityList = new ArrayList<EntityEnterpriseContext>();
            this.m_map.put(tx, entityList);
            tx.registerSynchronization((Synchronization)new GlobalTxEntityMapCleanup(this, tx));
        }
        entityList.add(entity);
    }

    public synchronized EntityEnterpriseContext[] getEntities(Transaction tx) {
        ArrayList entityList = (ArrayList)this.m_map.get(tx);
        if (entityList == null) {
            return new EntityEnterpriseContext[0];
        }
        return entityList.toArray(new EntityEnterpriseContext[entityList.size()]);
    }

    private class GlobalTxEntityMapCleanup
    implements Synchronization {
        GlobalTxEntityMap map;
        Transaction tx;

        public GlobalTxEntityMapCleanup(GlobalTxEntityMap map, Transaction tx) {
            this.map = map;
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            GlobalTxEntityMap globalTxEntityMap = this.map;
            synchronized (globalTxEntityMap) {
                ArrayList entityList = (ArrayList)GlobalTxEntityMap.this.m_map.remove(this.tx);
                if (entityList != null) {
                    entityList.clear();
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

