/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvoker;
import org.jboss.ejb.ContainerInvokerContainer;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.InstancePoolContainer;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.LocalContainerInvoker;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;

public class StatefulSessionContainer
extends Container
implements ContainerInvokerContainer,
InstancePoolContainer {
    protected Class homeInterface;
    protected Class remoteInterface;
    protected Map homeMapping;
    protected Map beanMapping;
    protected ContainerInvoker containerInvoker;
    protected Interceptor interceptor;
    protected InstancePool instancePool;
    protected StatefulSessionPersistenceManager persistenceManager;
    protected InstanceCache instanceCache;
    static /* synthetic */ Class class$org$jboss$ejb$MethodInvocation;

    public void addInterceptor(Interceptor in) {
        if (this.interceptor == null) {
            this.interceptor = in;
        } else {
            Interceptor current = this.interceptor;
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(in);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected Interceptor createContainerInterceptor() {
        return new ContainerInterceptor();
    }

    public EJBObject createHome(MethodInvocation mi) throws Exception {
        this.getPersistenceManager().createSession(mi.getMethod(), mi.getArguments(), (StatefulSessionEnterpriseContext)mi.getEnterpriseContext());
        return ((StatefulSessionEnterpriseContext)mi.getEnterpriseContext()).getEJBObject();
    }

    public EJBLocalObject createLocalHome(MethodInvocation mi) throws Exception {
        this.getPersistenceManager().createSession(mi.getMethod(), mi.getArguments(), (StatefulSessionEnterpriseContext)mi.getEnterpriseContext());
        return ((StatefulSessionEnterpriseContext)mi.getEnterpriseContext()).getEJBLocalObject();
    }

    public void destroy() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            if (this.containerInvoker != null) {
                this.containerInvoker.destroy();
            }
            this.containerInvoker = null;
            this.instanceCache.destroy();
            this.instanceCache = null;
            this.instancePool.destroy();
            this.instancePool = null;
            this.persistenceManager.destroy();
            this.persistenceManager = null;
            Interceptor in = this.interceptor;
            while (in != null) {
                in.destroy();
                in = in.getNext();
            }
            super.destroy();
        }
        finally {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public ContainerInvoker getContainerInvoker() {
        return this.containerInvoker;
    }

    public EJBHome getEJBHome(MethodInvocation mi) throws RemoteException {
        if (this.containerInvoker == null) {
            throw new IllegalStateException();
        }
        return this.containerInvoker.getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome(MethodInvocation mi) {
        return this.localContainerInvoker.getEJBLocalHome();
    }

    public EJBMetaData getEJBMetaDataHome(MethodInvocation mi) throws RemoteException {
        if (this.containerInvoker == null) {
            throw new IllegalStateException();
        }
        return this.getContainerInvoker().getEJBMetaData();
    }

    public EJBObject getEJBObject(MethodInvocation mi) throws RemoteException {
        if (this.containerInvoker == null) {
            throw new IllegalStateException();
        }
        return this.containerInvoker.getStatefulSessionEJBObject(mi.getArguments()[0]);
    }

    public Handle getHandle(MethodInvocation mi) throws RemoteException {
        return null;
    }

    public Class getHomeClass() {
        return this.homeInterface;
    }

    public HomeHandle getHomeHandleHome(MethodInvocation mi) throws RemoteException {
        throw new Error("Not Yet Implemented");
    }

    public InstanceCache getInstanceCache() {
        return this.instanceCache;
    }

    public InstancePool getInstancePool() {
        return this.instancePool;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public LocalContainerInvoker getLocalContainerInvoker() {
        return this.localContainerInvoker;
    }

    public StatefulSessionPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public Object getPrimaryKey(MethodInvocation mi) throws RemoteException {
        return null;
    }

    public Class getRemoteClass() {
        return this.remoteInterface;
    }

    public void init() throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        if (this.metaData.getHome() != null) {
            this.homeInterface = this.classLoader.loadClass(this.metaData.getHome());
        }
        if (this.metaData.getRemote() != null) {
            this.remoteInterface = this.classLoader.loadClass(this.metaData.getRemote());
        }
        super.init();
        this.setupBeanMapping();
        this.setupHomeMapping();
        if (this.containerInvoker != null) {
            this.containerInvoker.init();
        }
        this.instanceCache.init();
        this.instancePool.init();
        this.persistenceManager.init();
        Interceptor in = this.interceptor;
        while (in != null) {
            in.setContainer(this);
            in.init();
            in = in.getNext();
        }
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    public Object invoke(MethodInvocation mi) throws Exception {
        return this.getInterceptor().invoke(mi);
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        return this.getInterceptor().invokeHome(mi);
    }

    public boolean isIdentical(MethodInvocation mi) throws RemoteException {
        return false;
    }

    public void remove(MethodInvocation mi) throws RemoteException, RemoveException {
        this.getPersistenceManager().removeSession((StatefulSessionEnterpriseContext)mi.getEnterpriseContext());
        mi.getEnterpriseContext().setId(null);
    }

    public void removeHome(MethodInvocation mi) throws RemoteException, RemoveException {
        throw new Error("Not Yet Implemented");
    }

    public void removeLocalHome(MethodInvocation mi) throws RemoteException, RemoveException {
        throw new Error("Not Yet Implemented");
    }

    public void setContainerInvoker(ContainerInvoker ci) {
        if (ci == null) {
            throw new IllegalArgumentException("Null invoker");
        }
        this.containerInvoker = ci;
        ci.setContainer(this);
    }

    public void setInstanceCache(InstanceCache ic) {
        this.instanceCache = ic;
        ic.setContainer(this);
    }

    public void setInstancePool(InstancePool ip) {
        if (ip == null) {
            throw new IllegalArgumentException("Null pool");
        }
        this.instancePool = ip;
        ip.setContainer(this);
    }

    public void setPersistenceManager(StatefulSessionPersistenceManager pm) {
        this.persistenceManager = pm;
        pm.setContainer(this);
    }

    private void setUpBeanMappingImpl(Map map, Method[] m, String declaringClass) throws NoSuchMethodException {
        int i = 0;
        while (i < m.length) {
            if (!m[i].getDeclaringClass().getName().equals(declaringClass)) {
                map.put(m[i], this.beanClass.getMethod(m[i].getName(), m[i].getParameterTypes()));
            } else {
                try {
                    map.put(m[i], this.getClass().getMethod(m[i].getName(), class$org$jboss$ejb$MethodInvocation != null ? class$org$jboss$ejb$MethodInvocation : StatefulSessionContainer.class$("org.jboss.ejb.MethodInvocation")));
                }
                catch (NoSuchMethodException e) {
                    this.log.error(String.valueOf(m[i].getName()) + " in bean has not been mapped", e);
                }
            }
            ++i;
        }
    }

    protected void setupBeanMapping() throws NoSuchMethodException {
        Method[] m;
        HashMap map = new HashMap();
        if (this.remoteInterface != null) {
            m = this.remoteInterface.getMethods();
            this.setUpBeanMappingImpl(map, m, "javax.ejb.EJBObject");
        }
        if (this.localInterface != null) {
            m = this.localInterface.getMethods();
            this.setUpBeanMappingImpl(map, m, "javax.ejb.EJBLocalObject");
        }
        this.beanMapping = map;
    }

    protected void setupHomeMapping() throws NoSuchMethodException {
        int i;
        Method[] m;
        HashMap<Method, Method> map = new HashMap<Method, Method>();
        if (this.homeInterface != null) {
            m = this.homeInterface.getMethods();
            i = 0;
            while (i < m.length) {
                try {
                    map.put(m[i], this.getClass().getMethod(String.valueOf(m[i].getName()) + "Home", class$org$jboss$ejb$MethodInvocation != null ? class$org$jboss$ejb$MethodInvocation : StatefulSessionContainer.class$("org.jboss.ejb.MethodInvocation")));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.log.info(String.valueOf(m[i].getName()) + " in bean has not been mapped");
                }
                ++i;
            }
        }
        if (this.localHomeInterface != null) {
            m = this.localHomeInterface.getMethods();
            i = 0;
            while (i < m.length) {
                try {
                    map.put(m[i], this.getClass().getMethod(String.valueOf(m[i].getName()) + "LocalHome", class$org$jboss$ejb$MethodInvocation != null ? class$org$jboss$ejb$MethodInvocation : StatefulSessionContainer.class$("org.jboss.ejb.MethodInvocation")));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.log.info(String.valueOf(m[i].getName()) + " in bean has not been mapped");
                }
                ++i;
            }
        }
        try {
            Class<?> handleClass = Class.forName("javax.ejb.Handle");
            Method getEJBObjectMethod = handleClass.getMethod("getEJBObject", new Class[0]);
            map.put(getEJBObjectMethod, this.getClass().getMethod("getEJBObject", class$org$jboss$ejb$MethodInvocation != null ? class$org$jboss$ejb$MethodInvocation : (class$org$jboss$ejb$MethodInvocation = StatefulSessionContainer.class$("org.jboss.ejb.MethodInvocation"))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log.debug("Couldn't find getEJBObject method on container");
        }
        catch (Exception e) {
            this.log.error(e);
        }
        this.homeMapping = map;
    }

    public void start() throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        super.start();
        if (this.containerInvoker != null) {
            this.containerInvoker.start();
        }
        this.instanceCache.start();
        this.instancePool.start();
        this.persistenceManager.start();
        Interceptor in = this.interceptor;
        while (in != null) {
            in.start();
            in = in.getNext();
        }
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    public void stop() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        super.stop();
        if (this.containerInvoker != null) {
            this.containerInvoker.stop();
        }
        this.instanceCache.stop();
        this.instancePool.stop();
        this.persistenceManager.stop();
        this.instancePool.stop();
        Interceptor in = this.interceptor;
        while (in != null) {
            in.stop();
            in = in.getNext();
        }
        Thread.currentThread().setContextClassLoader(oldCl);
    }

    class ContainerInterceptor
    implements Interceptor {
        ContainerInterceptor() {
        }

        public void destroy() {
        }

        public Interceptor getNext() {
            return null;
        }

        public void init() {
        }

        public Object invoke(MethodInvocation mi) throws Exception {
            Method m;
            if (mi.getEnterpriseContext().getTransaction() == null) {
                mi.getEnterpriseContext().setTransaction(mi.getTransaction());
            }
            if ((m = (Method)StatefulSessionContainer.this.beanMapping.get(mi.getMethod())).getDeclaringClass().equals(StatefulSessionContainer.this.getClass())) {
                try {
                    return m.invoke((Object)StatefulSessionContainer.this, mi);
                }
                catch (IllegalAccessException e) {
                    throw new EJBException((Exception)e);
                }
                catch (InvocationTargetException e) {
                    Throwable ex = e.getTargetException();
                    if (ex instanceof EJBException) {
                        throw (EJBException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw new EJBException((Exception)ex);
                    }
                    if (ex instanceof Exception) {
                        throw (Exception)ex;
                    }
                    throw (Error)ex;
                }
            }
            try {
                return m.invoke(mi.getEnterpriseContext().getInstance(), mi.getArguments());
            }
            catch (IllegalAccessException e) {
                throw new EJBException((Exception)e);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof EJBException) {
                    throw (EJBException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw new EJBException((Exception)ex);
                }
                if (ex instanceof Exception) {
                    throw (Exception)ex;
                }
                throw (Error)ex;
            }
        }

        public Object invokeHome(MethodInvocation mi) throws Exception {
            Method m = (Method)StatefulSessionContainer.this.homeMapping.get(mi.getMethod());
            try {
                return m.invoke((Object)StatefulSessionContainer.this, mi);
            }
            catch (IllegalAccessException e) {
                throw new EJBException((Exception)e);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex instanceof EJBException) {
                    throw (EJBException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw new EJBException((Exception)ex);
                }
                if (ex instanceof Exception) {
                    throw (Exception)ex;
                }
                throw (Error)ex;
            }
        }

        public void setContainer(Container con) {
        }

        public void setNext(Interceptor interceptor) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

