/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.plugins.InstancePoolFeeder;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public abstract class AbstractInstancePool
implements InstancePool,
XmlLoadable {
    private FIFOSemaphore strictMaxSize;
    private long strictTimeout = Long.MAX_VALUE;
    protected Logger log = Logger.getLogger(this.getClass());
    protected Container container;
    protected Stack pool = new Stack();
    protected int maxSize = 30;
    protected boolean reclaim = false;
    protected InstancePoolFeeder poolFeeder;

    public void add() throws Exception {
        EnterpriseContext ctx = null;
        try {
            ctx = this.create(this.container.createBeanClassInstance());
        }
        catch (InstantiationException e) {
            throw new ServerException("Could not instantiate bean", e);
        }
        catch (IllegalAccessException e) {
            throw new ServerException("Could not instantiate bean", e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Add instance " + this + "#" + ctx);
        }
        this.pool.push(ctx);
    }

    protected abstract EnterpriseContext create(Object var1) throws Exception;

    public void destroy() {
        this.freeAll();
        this.container = null;
    }

    public void discard(EnterpriseContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = "Discard instance:" + this + "#" + ctx + "#" + ctx.getTransaction() + "#" + this.reclaim + "#" + this.getContainer().getBeanClass();
            this.log.trace(msg);
        }
        if (this.strictMaxSize != null) {
            this.strictMaxSize.release();
        }
        try {
            ctx.discard();
        }
        catch (RemoteException remoteException) {}
    }

    public void free(EnterpriseContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = "Free instance:" + this + "#" + ctx + "#" + ctx.getTransaction() + "#" + this.reclaim + "#" + this.getContainer().getBeanClass();
            this.log.trace(msg);
        }
        if (this.strictMaxSize != null) {
            this.strictMaxSize.release();
        }
        this.internalFree(ctx);
    }

    private void freeAll() {
        Iterator i = ((AbstractList)this.pool).iterator();
        while (i.hasNext()) {
            EnterpriseContext ctx = (EnterpriseContext)i.next();
            ctx.clear();
            this.discard(ctx);
        }
        this.pool.clear();
    }

    public EnterpriseContext get() throws Exception {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Get instance " + this + "#" + this.pool.empty() + "#" + this.getContainer().getBeanClass());
        }
        if (this.strictMaxSize != null) {
            boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
            if (trace) {
                this.log.trace("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits());
            }
            if (!acquired) {
                throw new ServerException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
            }
        }
        EnterpriseContext ctx = this.internalGet();
        return ctx;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getCurrentSize() {
        return this.pool.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean getReclaim() {
        return this.reclaim;
    }

    public void importXml(Element element) throws DeploymentException {
        String maximumSize = MetaData.getElementContent(MetaData.getOptionalChild(element, "MaximumSize"));
        try {
            if (maximumSize != null) {
                this.maxSize = Integer.parseInt(maximumSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DeploymentException("Invalid MaximumSize value for instance pool configuration");
        }
        String strictValue = MetaData.getElementContent(MetaData.getOptionalChild(element, "strictMaximumSize"));
        Boolean strictFlag = Boolean.valueOf(strictValue);
        if (strictFlag == Boolean.TRUE) {
            this.strictMaxSize = new FIFOSemaphore((long)this.maxSize);
        }
        String delay = MetaData.getElementContent(MetaData.getOptionalChild(element, "strictTimeout"));
        try {
            if (delay != null) {
                this.strictTimeout = Integer.parseInt(delay);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new DeploymentException("Invalid strictTimeout value for instance pool configuration");
        }
        String feederPolicy = MetaData.getElementContent(MetaData.getOptionalChild(element, "feeder-policy"));
        this.poolFeeder = null;
        if (feederPolicy != null) {
            try {
                Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(feederPolicy);
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                this.poolFeeder = (InstancePoolFeeder)ctor.newInstance(new Class[0]);
                this.poolFeeder.setInstancePool(this);
                this.poolFeeder.importXml(element);
            }
            catch (Exception x) {
                throw new DeploymentException("Can't create instance pool feeder", x);
            }
        }
        this.log.debug("config - MaximumSize=" + this.maxSize + ", strictMaximumSize=" + strictFlag + ", feederPolicy=" + feederPolicy);
    }

    public void init() throws Exception {
    }

    private synchronized void internalFree(EnterpriseContext ctx) {
        ctx.clear();
        try {
            if (this.reclaim && this.pool.size() < this.maxSize) {
                this.pool.push(ctx);
            } else {
                ctx.discard();
            }
        }
        catch (Exception e) {
            this.log.debug("free failure", e);
        }
    }

    private synchronized EnterpriseContext internalGet() throws Exception {
        EnterpriseContext ctx = null;
        if (!this.pool.empty()) {
            ctx = (EnterpriseContext)this.pool.pop();
        } else {
            if (this.poolFeeder != null && this.poolFeeder.isStarted() && this.log.isDebugEnabled()) {
                this.log.debug("The Pool for " + this.container.getBeanClass().getName() + " has been overloaded.  You should change pool parameters.");
            }
            this.add();
            ctx = (EnterpriseContext)this.pool.pop();
        }
        return ctx;
    }

    public void setContainer(Container c) {
        this.container = c;
    }

    public void setReclaim(boolean reclaim) {
        this.reclaim = reclaim;
    }

    public void start() throws Exception {
        if (this.poolFeeder != null && !this.poolFeeder.isStarted()) {
            this.poolFeeder.start();
        }
    }

    public void stop() {
        if (this.poolFeeder != null) {
            this.poolFeeder.stop();
        }
        this.poolFeeder = null;
    }
}

