/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.util.FinderResults;

public class CMPFilePersistenceManager
implements EntityPersistenceStore {
    EntityContainer con;
    File dir;
    Field idField;

    public void activateEntity(EntityEnterpriseContext ctx) throws RemoteException {
    }

    public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        try {
            Object id = this.idField.get(ctx.getInstance());
            if (this.getFile(id).exists()) {
                throw new DuplicateKeyException("Already exists:" + id);
            }
            this.storeEntity(id, ctx.getInstance());
            return id;
        }
        catch (IllegalAccessException e) {
            throw new CreateException("Could not create entity:" + e);
        }
    }

    public void destroy() {
    }

    public FinderResults findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx) throws RemoteException {
        if (finderMethod.getName().equals("findAll")) {
            String[] files = this.dir.list();
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".ser")) {
                    result.add(files[i].substring(0, files[i].length() - 4));
                }
                ++i;
            }
            return new FinderResults(result, null, null, null);
        }
        return new FinderResults(new ArrayList(), null, null, null);
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx) throws RemoteException, FinderException {
        if (finderMethod.getName().equals("findByPrimaryKey")) {
            if (!this.getFile(args[0]).exists()) {
                throw new FinderException(String.valueOf(String.valueOf(args[0])) + " does not exist");
            }
            return args[0];
        }
        return null;
    }

    protected File getFile(Object id) {
        return new File(this.dir, String.valueOf(String.valueOf(id)) + ".ser");
    }

    public void init() throws Exception {
        String ejbName = this.con.getBeanMetaData().getEjbName();
        this.dir = new File(this.getClass().getResource("/db/" + ejbName + "/db.properties").getFile()).getParentFile();
        this.idField = this.con.getBeanClass().getField("id");
    }

    public void loadEntities(FinderResults keys) {
    }

    public void loadEntity(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            CMPObjectInputStream in = new CMPObjectInputStream(new FileInputStream(this.getFile(ctx.getId())));
            Object obj = ctx.getInstance();
            Field[] f = obj.getClass().getFields();
            int i = 0;
            while (i < f.length) {
                f[i].set(obj, in.readObject());
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            throw new ServerException("Load failed", e);
        }
    }

    public void passivateEntity(EntityEnterpriseContext ctx) throws RemoteException {
    }

    public void removeEntity(EntityEnterpriseContext ctx) throws RemoteException, RemoveException {
        if (!this.getFile(ctx.getId()).delete()) {
            throw new RemoveException("Could not remove file:" + this.getFile(ctx.getId()));
        }
    }

    public void setContainer(Container c) {
        this.con = (EntityContainer)c;
    }

    public void start() {
    }

    public void stop() {
    }

    private void storeEntity(Object id, Object obj) throws RemoteException {
        try {
            CMPObjectOutputStream out = new CMPObjectOutputStream(new FileOutputStream(this.getFile(id)));
            Field[] f = obj.getClass().getFields();
            int i = 0;
            while (i < f.length) {
                out.writeObject(f[i].get(obj));
                ++i;
            }
            out.close();
        }
        catch (Exception e) {
            throw new ServerException("Store failed", e);
        }
    }

    public void storeEntity(EntityEnterpriseContext ctx) throws RemoteException {
        this.storeEntity(ctx.getId(), ctx.getInstance());
    }

    static class CMPObjectOutputStream
    extends ObjectOutputStream {
        public CMPObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof EJBObject) {
                return ((EJBObject)obj).getHandle();
            }
            return obj;
        }
    }

    static class CMPObjectInputStream
    extends ObjectInputStream {
        public CMPObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof Handle) {
                return ((Handle)obj).getEJBObject();
            }
            return obj;
        }
    }
}

