/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import javax.ejb.DuplicateKeyException;
import javax.transaction.Transaction;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.CacheKey;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;

public class EntityInstanceInterceptor
extends AbstractInterceptor {
    protected EntityContainer container;

    protected void clearLockTx(MethodInvocation mi, Exception e, boolean trace) {
        BeanLock lock;
        CacheKey key;
        block3: {
            key = (CacheKey)mi.getId();
            lock = this.container.getLockManager().getLock(key);
            lock.sync();
            try {
                Transaction tx = mi.getTransaction();
                if (tx == null) break block3;
                if (trace) {
                    this.log.trace("clear lock tx=" + tx + ", id=" + key, e);
                }
                lock.endTransaction(tx);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                lock.releaseSync();
                this.container.getLockManager().removeLockRef(key);
                throw throwable;
            }
        }
        Object var7_7 = null;
        lock.releaseSync();
        this.container.getLockManager().removeLockRef(key);
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation mi) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        CacheKey key = (CacheKey)mi.getId();
        EntityEnterpriseContext ctx = null;
        try {
            ctx = (EntityEnterpriseContext)this.container.getInstanceCache().get(key);
        }
        catch (Exception e) {
            this.clearLockTx(mi, e, trace);
            throw e;
        }
        if (trace) {
            this.log.trace("Begin invoke, key=" + key);
        }
        ctx.setTransaction(mi.getTransaction());
        mi.setEnterpriseContext(ctx);
        boolean exceptionThrown = false;
        try {
            Object object;
            block20: {
                try {
                    object = this.getNext().invoke(mi);
                    Object var8_8 = null;
                    if (ctx == null) break block20;
                }
                catch (RemoteException e) {
                    exceptionThrown = true;
                    throw e;
                }
                catch (RuntimeException e) {
                    exceptionThrown = true;
                    throw e;
                }
                catch (Error e) {
                    exceptionThrown = true;
                    throw e;
                }
                if (exceptionThrown && !ctx.hasTxSynchronization()) {
                    this.container.getInstanceCache().remove(key);
                    if (trace) {
                        this.log.trace("Ending invoke, exceptionThrown, ctx=" + ctx);
                    }
                } else if (ctx.getId() == null) {
                    this.container.getInstanceCache().remove(key);
                    if (trace) {
                        this.log.trace("Ending invoke, cache removal, ctx=" + ctx);
                    }
                }
            }
            if (!trace) return object;
            this.log.trace("End invoke, key=" + key + ", ctx=" + ctx);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (ctx != null) {
                if (exceptionThrown && !ctx.hasTxSynchronization()) {
                    this.container.getInstanceCache().remove(key);
                    if (trace) {
                        this.log.trace("Ending invoke, exceptionThrown, ctx=" + ctx);
                    }
                } else if (ctx.getId() == null) {
                    this.container.getInstanceCache().remove(key);
                    if (trace) {
                        this.log.trace("Ending invoke, cache removal, ctx=" + ctx);
                    }
                }
            }
            if (!trace) throw throwable;
            this.log.trace("End invoke, key=" + key + ", ctx=" + ctx);
            throw throwable;
        }
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)((EntityContainer)this.getContainer()).getInstancePool().get();
        mi.setEnterpriseContext(ctx);
        ctx.setTransaction(mi.getTransaction());
        boolean exceptionThrown = false;
        Object rtn = this.getNext().invokeHome(mi);
        if (ctx.getId() != null) {
            BeanLock lock = this.container.getLockManager().getLock(ctx.getCacheKey());
            lock.sync();
            try {
                try {
                    this.container.getInstanceCache().insert(ctx);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new DuplicateKeyException("INSERTING AN ALREADY EXISTING BEAN, ID = " + ctx.getId());
                }
                Object var7_6 = null;
                lock.releaseSync();
                this.container.getLockManager().removeLockRef(ctx.getCacheKey());
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                lock.releaseSync();
                this.container.getLockManager().removeLockRef(ctx.getCacheKey());
                throw throwable;
            }
        }
        return rtn;
    }

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
    }
}

