/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import org.jboss.ejb.BeanLock;
import org.jboss.ejb.CacheKey;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;

public class EntityLockInterceptor
extends AbstractInterceptor {
    protected EntityContainer container;

    public Container getContainer() {
        return this.container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation mi) throws Exception {
        CacheKey key = (CacheKey)mi.getId();
        boolean threadIsScheduled = false;
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Begin invoke, key=" + key);
        }
        try {
            Object object;
            BeanLock lock = this.container.getLockManager().getLock(key);
            lock.schedule(mi);
            try {
                object = this.getNext().invoke(mi);
                Object var10_7 = null;
                lock.sync();
                lock.releaseMethodLock();
                lock.releaseSync();
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                lock.sync();
                lock.releaseMethodLock();
                lock.releaseSync();
                throw throwable;
            }
            Object var8_9 = null;
            this.container.getLockManager().removeLockRef(key);
            if (!trace) return object;
            this.log.trace("End invoke, key=" + key);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.container.getLockManager().removeLockRef(key);
            if (!trace) throw throwable;
            this.log.trace("End invoke, key=" + key);
            throw throwable;
        }
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        return this.getNext().invokeHome(mi);
    }

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
    }
}

