/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.EntityInstancePool;
import org.jboss.ejb.plugins.EntitySynchronizationInterceptor;

public class EntityMultiInstanceSynchronizationInterceptor
extends EntitySynchronizationInterceptor {
    protected Synchronization createSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
        return new MultiInstanceSynchronization(tx, ctx);
    }

    public void init() throws Exception {
        super.init();
        if (this.container.getInstancePool() instanceof EntityInstancePool) {
            ((EntityInstancePool)this.container.getInstancePool()).setReclaim(true);
        }
    }

    protected class MultiInstanceSynchronization
    extends EntitySynchronizationInterceptor.InstanceSynchronization {
        MultiInstanceSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
            super(EntityMultiInstanceSynchronizationInterceptor.this, tx, ctx);
        }

        public void afterCompletion(int status) {
            boolean trace = EntityMultiInstanceSynchronizationInterceptor.this.log.isTraceEnabled();
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(EntityMultiInstanceSynchronizationInterceptor.this.container.getClassLoader());
            this.lock.sync();
            try {
                try {
                    if (status != 4) {
                        switch (EntityMultiInstanceSynchronizationInterceptor.this.commitOption) {
                            case 0: {
                                throw new IllegalStateException("Commit option A not allowed with this Interceptor");
                            }
                            case 3: {
                                throw new IllegalStateException("Commit option A not allowed with this Interceptor");
                            }
                        }
                    }
                    try {
                        EntityMultiInstanceSynchronizationInterceptor.this.container.getPersistenceManager().passivateEntity(this.ctx);
                    }
                    catch (Exception exception) {}
                    EntityMultiInstanceSynchronizationInterceptor.this.container.getInstancePool().free(this.ctx);
                }
                finally {
                    Object var7_4 = null;
                    if (trace) {
                        EntityMultiInstanceSynchronizationInterceptor.this.log.trace("afterCompletion, clear tx for ctx=" + this.ctx + ", tx=" + this.tx);
                    }
                    this.lock.endTransaction(this.tx);
                    if (trace) {
                        EntityMultiInstanceSynchronizationInterceptor.this.log.trace("afterCompletion, sent notify on TxLock for ctx=" + this.ctx);
                    }
                }
                Object var5_7 = null;
                this.lock.releaseSync();
                EntityMultiInstanceSynchronizationInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                Thread.currentThread().setContextClassLoader(oldCl);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.lock.releaseSync();
                EntityMultiInstanceSynchronizationInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
        }
    }
}

