/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.HashSet;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEntityException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.metadata.ConfigurationMetaData;

public class EntitySynchronizationInterceptor
extends AbstractInterceptor {
    protected int commitOption;
    protected long optionDRefreshRate;
    protected EntityContainer container;
    protected HashSet validContexts;

    protected void clearContextTx(String msg, EntityEnterpriseContext ctx, Transaction tx, boolean trace) {
        BeanLock lock = this.container.getLockManager().getLock(ctx.getCacheKey());
        lock.sync();
        try {
            if (trace) {
                this.log.trace(String.valueOf(msg) + ", clear tx for ctx=" + ctx + ", tx=" + tx);
            }
            ctx.hasTxSynchronization(false);
            ctx.setTransaction(null);
            lock.wontSynchronize(tx);
        }
        finally {
            Object var7_6 = null;
            lock.releaseSync();
            this.container.getLockManager().removeLockRef(lock.getId());
        }
    }

    protected Synchronization createSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
        return new InstanceSynchronization(tx, ctx);
    }

    public Container getContainer() {
        return this.container;
    }

    public void init() throws Exception {
        try {
            this.validContexts = new HashSet();
            ConfigurationMetaData configuration = this.container.getBeanMetaData().getContainerConfiguration();
            this.commitOption = configuration.getCommitOption();
            this.optionDRefreshRate = configuration.getOptionDRefreshRate();
            if (this.commitOption == 3) {
                ValidContextsRefresher vcr = new ValidContextsRefresher(this.validContexts, this.optionDRefreshRate);
                new Thread(vcr).start();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public Object invoke(MethodInvocation mi) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        Transaction tx = mi.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace("invoke called for ctx " + ctx + ", tx=" + tx);
        }
        if (this.commitOption == 3 && !this.validContexts.contains(ctx.getId())) {
            ctx.setValid(false);
        }
        if (!ctx.isValid()) {
            try {
                this.container.getPersistenceManager().loadEntity(ctx);
            }
            catch (Exception ex) {
                this.clearContextTx("loadEntity Exception", ctx, tx, this.log.isTraceEnabled());
                throw ex;
            }
            ctx.setValid(true);
        }
        if (tx != null && tx.getStatus() != 6) {
            try {
                Object ex = this.getNext().invoke(mi);
                Object var6_8 = null;
                if (!ctx.hasTxSynchronization()) {
                    this.register(ctx, tx);
                }
                return ex;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (!ctx.hasTxSynchronization()) {
                    this.register(ctx, tx);
                }
                throw throwable;
            }
        }
        try {
            Object result = this.getNext().invoke(mi);
            if (ctx.getId() != null) {
                this.container.storeEntity(ctx);
                if (this.commitOption == 2) {
                    this.container.getInstanceCache().release(ctx);
                }
            }
            return result;
        }
        catch (Exception e) {
            ctx.setValid(false);
            throw e;
        }
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        Transaction tx = mi.getTransaction();
        Object rtn = this.getNext().invokeHome(mi);
        if (ctx.getId() != null) {
            ctx.setValid(true);
            if (tx != null) {
                BeanLock lock = this.container.getLockManager().getLock(ctx.getCacheKey());
                try {
                    lock.schedule(mi);
                    this.register(ctx, tx);
                    lock.releaseMethodLock();
                }
                finally {
                    Object var7_6 = null;
                    this.container.getLockManager().removeLockRef(lock.getId());
                }
            } else if (this.commitOption == 2) {
                this.container.getInstanceCache().release(ctx);
            }
        }
        return rtn;
    }

    protected void register(EntityEnterpriseContext ctx, Transaction tx) {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("register, ctx=" + ctx + ", tx=" + tx);
        }
        Synchronization synch = this.createSynchronization(tx, ctx);
        EntityContainer ctxContainer = null;
        try {
            ctxContainer = (EntityContainer)ctx.getContainer();
            tx.registerSynchronization(synch);
            ctxContainer.getTxEntityMap().associate(tx, ctx);
            ctx.hasTxSynchronization(true);
        }
        catch (RollbackException rollbackException) {
            EntityEnterpriseContext entityEnterpriseContext = ctx;
            synchronized (entityEnterpriseContext) {
                ctx.setValid(false);
            }
            this.clearContextTx("RollbackException", ctx, tx, trace);
        }
        catch (Exception e) {
            this.clearContextTx("Exception", ctx, tx, trace);
            throw new EJBException(e);
        }
    }

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
    }

    protected class InstanceSynchronization
    implements Synchronization {
        protected Transaction tx;
        protected EntityEnterpriseContext ctx;
        protected BeanLock lock;

        InstanceSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
            this.tx = tx;
            this.ctx = ctx;
            this.lock = EntitySynchronizationInterceptor.this.container.getLockManager().getLock(ctx.getCacheKey());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(int status) {
            boolean trace = EntitySynchronizationInterceptor.this.log.isTraceEnabled();
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(EntitySynchronizationInterceptor.this.container.getClassLoader());
            this.lock.sync();
            try {
                block17: {
                    try {
                        if (status == 4) {
                            EntitySynchronizationInterceptor.this.container.getInstanceCache().remove(this.ctx.getCacheKey());
                            break block17;
                        }
                        switch (EntitySynchronizationInterceptor.this.commitOption) {
                            case 0: {
                                this.ctx.setValid(true);
                                break;
                            }
                            case 1: {
                                this.ctx.setValid(false);
                                break;
                            }
                            case 2: {
                                try {
                                    if (this.ctx.getId() != null) {
                                        EntitySynchronizationInterceptor.this.container.getInstanceCache().release(this.ctx);
                                    }
                                }
                                catch (Exception e) {
                                    EntitySynchronizationInterceptor.this.log.debug(e);
                                }
                                break;
                            }
                            case 3: {
                                EntitySynchronizationInterceptor.this.validContexts.add(this.ctx.getId());
                                break;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (trace) {
                            EntitySynchronizationInterceptor.this.log.trace("afterCompletion, clear tx for ctx=" + this.ctx + ", tx=" + this.tx);
                        }
                        this.ctx.hasTxSynchronization(false);
                        this.ctx.setTransaction(null);
                        this.lock.endTransaction(this.tx);
                        if (!trace) throw throwable;
                        EntitySynchronizationInterceptor.this.log.trace("afterCompletion, sent notify on TxLock for ctx=" + this.ctx);
                        throw throwable;
                    }
                    {
                    }
                }
                Object var7_5 = null;
                if (trace) {
                    EntitySynchronizationInterceptor.this.log.trace("afterCompletion, clear tx for ctx=" + this.ctx + ", tx=" + this.tx);
                }
                this.ctx.hasTxSynchronization(false);
                this.ctx.setTransaction(null);
                this.lock.endTransaction(this.tx);
                if (trace) {
                    EntitySynchronizationInterceptor.this.log.trace("afterCompletion, sent notify on TxLock for ctx=" + this.ctx);
                }
                Object var5_8 = null;
                this.lock.releaseSync();
                EntitySynchronizationInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                Thread.currentThread().setContextClassLoader(oldCl);
                return;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.lock.releaseSync();
                EntitySynchronizationInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
        }

        public void beforeCompletion() {
            boolean trace = EntitySynchronizationInterceptor.this.log.isTraceEnabled();
            if (trace) {
                EntitySynchronizationInterceptor.this.log.trace("beforeCompletion called for ctx " + this.ctx);
            }
            if (this.ctx.getId() != null) {
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(EntitySynchronizationInterceptor.this.container.getClassLoader());
                try {
                    block16: {
                        try {
                            try {
                                if (trace) {
                                    EntitySynchronizationInterceptor.this.log.trace("Checking ctx=" + this.ctx + ", for status of tx=" + this.tx);
                                }
                                if (this.tx.getStatus() != 1) {
                                    EntitySynchronizationInterceptor.this.container.storeEntity(this.ctx);
                                    if (trace) {
                                        EntitySynchronizationInterceptor.this.log.trace("sync calling store on ctx " + this.ctx);
                                    }
                                }
                            }
                            catch (NoSuchEntityException ignored) {
                                if (trace) {
                                    EntitySynchronizationInterceptor.this.log.trace("Ignoring NSEE", ignored);
                                }
                            }
                        }
                        catch (Exception e) {
                            EntitySynchronizationInterceptor.this.log.error("Store failed", e);
                            try {
                                this.tx.setRollbackOnly();
                            }
                            catch (SystemException ex) {
                                if (trace) {
                                    EntitySynchronizationInterceptor.this.log.trace("Ignoring SE", ex);
                                }
                            }
                            catch (IllegalStateException ex) {
                                if (!trace) break block16;
                                EntitySynchronizationInterceptor.this.log.trace("Ignoring ISE", ex);
                            }
                        }
                    }
                    Object var4_7 = null;
                    Thread.currentThread().setContextClassLoader(oldCl);
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    Thread.currentThread().setContextClassLoader(oldCl);
                    throw throwable;
                }
            }
        }
    }

    class ValidContextsRefresher
    implements Runnable {
        private HashSet validContexts;
        private long refreshRate;

        public ValidContextsRefresher(HashSet validContexts, long refreshRate) {
            this.validContexts = validContexts;
            this.refreshRate = refreshRate;
        }

        public void run() {
            while (true) {
                this.validContexts.clear();
                EntitySynchronizationInterceptor.this.log.trace("Flushing the valid contexts");
                try {
                    Thread.sleep(this.refreshRate);
                    continue;
                }
                catch (Exception e) {
                    EntitySynchronizationInterceptor.this.log.debug("Interrupted from sleep", e);
                    continue;
                }
                break;
            }
        }
    }
}

