/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.TimerTask;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.ejb.plugins.LRUEnterpriseContextCachePolicy;
import org.jboss.ejb.plugins.StatefulSessionInstanceCache;
import org.jboss.metadata.MetaData;
import org.jboss.util.LRUCachePolicy;
import org.w3c.dom.Element;

public class LRUStatefulContextCachePolicy
extends LRUEnterpriseContextCachePolicy {
    private long m_maxBeanLife;
    private TimerTask m_remover;
    private long m_removerPeriod;
    private StatefulSessionInstanceCache m_cache;

    public LRUStatefulContextCachePolicy(AbstractInstanceCache eic) {
        super(eic);
        this.m_cache = (StatefulSessionInstanceCache)eic;
    }

    public void importXml(Element element) throws DeploymentException {
        super.importXml(element);
        String rp = MetaData.getElementContent(MetaData.getOptionalChild(element, "remover-period"));
        String ml = MetaData.getElementContent(MetaData.getOptionalChild(element, "max-bean-life"));
        try {
            if (rp != null) {
                int p = Integer.parseInt(rp);
                if (p <= 0) {
                    throw new DeploymentException("Remover period can't be <= 0");
                }
                this.m_removerPeriod = p * 1000;
            }
            if (ml != null) {
                int a = Integer.parseInt(ml);
                if (a <= 0) {
                    throw new DeploymentException("Max bean life can't be <= 0");
                }
                this.m_maxBeanLife = a * 1000;
            }
        }
        catch (NumberFormatException x) {
            throw new DeploymentException("Can't parse policy configuration", x);
        }
    }

    public void start() throws Exception {
        super.start();
        if (this.m_maxBeanLife > 0L) {
            this.m_remover = new RemoverTask(this.m_removerPeriod);
            LRUEnterpriseContextCachePolicy.tasksTimer.schedule(this.m_remover, (long)(Math.random() * (double)this.m_removerPeriod), this.m_removerPeriod);
        }
    }

    public void stop() {
        if (this.m_remover != null) {
            this.m_remover.cancel();
        }
        super.stop();
    }

    protected class RemoverTask
    extends LRUEnterpriseContextCachePolicy.OveragerTask {
        protected RemoverTask(long period) {
            super(period);
        }

        protected String getJMSTaskType() {
            return "REMOVER";
        }

        protected long getMaxAge() {
            return LRUStatefulContextCachePolicy.this.m_maxBeanLife;
        }

        protected String getTaskLogMessage() {
            return "Removing from cache bean";
        }

        protected void kickOut(LRUCachePolicy.LRUCacheEntry entry) {
            LRUStatefulContextCachePolicy.this.remove(entry.m_key);
        }

        public void run() {
            Object object = LRUStatefulContextCachePolicy.this.m_cache.getCacheLock();
            synchronized (object) {
                super.run();
                LRUStatefulContextCachePolicy.this.m_cache.removePassivated(this.getMaxAge() - super.getMaxAge());
            }
        }
    }
}

