/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.ServerException;
import javax.ejb.EJBException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ejb.Container;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.logging.Logger;

public class LogInterceptor
extends AbstractInterceptor {
    protected boolean callLogging;
    protected Container container;

    public Container getContainer() {
        return this.container;
    }

    public void init() throws Exception {
        super.start();
        String name = this.getContainer().getBeanMetaData().getEjbName();
        this.callLogging = this.getContainer().getBeanMetaData().getContainerConfiguration().getCallLogging();
        name = String.valueOf(this.getClass().getName()) + '.' + name;
        this.log = Logger.getLogger(name);
    }

    public Object invoke(MethodInvocation mi) throws Exception {
        if (this.callLogging) {
            StringBuffer str = new StringBuffer();
            str.append(mi.getId() == null ? "" : "[" + mi.getId().toString() + "] ");
            str.append(mi.getMethod().getName());
            str.append("(");
            Object[] args = mi.getArguments();
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    str.append(i == 0 ? "" : ",");
                    str.append(args[i]);
                    ++i;
                }
            }
            str.append(")");
            this.log.trace(str.toString());
        }
        try {
            return this.getNext().invoke(mi);
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                this.log.error("BEAN EXCEPTION:", e);
                throw new ServerException("Bean exception. Notify the application administrator", e);
            }
            if (e instanceof RuntimeException) {
                this.log.error("CONTAINER EXCEPTION:", e);
                throw new ServerException("Container exception. Notify the container developers :-)", e);
            }
            if (e instanceof TransactionRolledbackException) {
                this.log.error("TRANSACTION ROLLBACK EXCEPTION:", e);
                throw e;
            }
            if (this.callLogging) {
                this.log.trace("AppException", e);
            }
            throw e;
        }
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        if (this.callLogging) {
            StringBuffer str = new StringBuffer();
            str.append(mi.getMethod().getName());
            str.append("(");
            Object[] args = mi.getArguments();
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    str.append(i == 0 ? "" : ",");
                    str.append(args[i]);
                    ++i;
                }
            }
            str.append(")");
            this.log.trace(str.toString());
        }
        try {
            return this.getNext().invokeHome(mi);
        }
        catch (Exception e) {
            if (e instanceof EJBException) {
                this.log.error("BEAN EXCEPTION:", e);
                throw new ServerException("Bean exception. Notify the application administrator", e);
            }
            if (e instanceof RuntimeException) {
                this.log.error("CONTAINER EXCEPTION:", e);
                throw new ServerException("Container exception. Notify the container developers :-)", e);
            }
            if (e instanceof TransactionRolledbackException) {
                this.log.error("TRANSACTION ROLLBACK EXCEPTION:", e);
                throw e;
            }
            if (this.callLogging) {
                this.log.trace("AppException", e);
            }
            throw e;
        }
    }

    public void setContainer(Container container) {
        this.container = container;
    }
}

