/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.ejb.Container;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.monitor.MetricsConstants;

public class MetricsInterceptor
extends AbstractInterceptor
implements MetricsConstants {
    private Container container = null;
    private String applicationName = "<undefined>";
    private String beanName = "<undefined>";
    private Thread publisher = null;
    private List msgQueue = new ArrayList(2000);

    private final void addEntry(MethodInvocation mi, long begin, long end) {
        Transaction tx = mi.getTransaction();
        Principal princ = mi.getPrincipal();
        Method method = mi.getMethod();
        Entry start = new Entry(princ, method, tx, begin, "START");
        Entry stop = new Entry(princ, method, tx, end, "STOP");
        List list = this.msgQueue;
        synchronized (list) {
            this.msgQueue.add(start);
            this.msgQueue.add(stop);
        }
    }

    private Message createMessage(Session session, String principal, int txID, String method, String checkpoint, long time) {
        try {
            Message msg = session.createMessage();
            msg.setJMSType("Invocation");
            msg.setStringProperty("CHECKPOINT", checkpoint);
            msg.setStringProperty("BEAN", this.beanName);
            msg.setObjectProperty("METHOD", (Object)method);
            msg.setLongProperty("TIME", time);
            if (txID != -1) {
                msg.setStringProperty("ID", String.valueOf(txID));
            }
            if (principal != null) {
                msg.setStringProperty("PRINCIPAL", principal);
            }
            return msg;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void destroy() {
        this.publisher.interrupt();
    }

    public Container getContainer() {
        return this.container;
    }

    public void init() {
        this.publisher = new Thread(new Publisher());
        this.publisher.setName("Metrics Publisher Thread for " + this.beanName + ".");
        this.publisher.setDaemon(true);
        this.publisher.start();
    }

    public Object invoke(MethodInvocation mi) throws Exception {
        long begin = System.currentTimeMillis();
        try {
            Object object = super.invoke(mi);
            Object var6_4 = null;
            this.addEntry(mi, begin, System.currentTimeMillis());
            return object;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.addEntry(mi, begin, System.currentTimeMillis());
            throw throwable;
        }
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        long begin = System.currentTimeMillis();
        try {
            Object object = super.invokeHome(mi);
            Object var6_4 = null;
            this.addEntry(mi, begin, System.currentTimeMillis());
            return object;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.addEntry(mi, begin, System.currentTimeMillis());
            throw throwable;
        }
    }

    public void setContainer(Container container) {
        this.container = container;
        this.applicationName = container.getApplication().getName();
        this.beanName = container.getBeanMetaData().getJndiName();
    }

    private class Publisher
    implements Runnable {
        private boolean running = true;
        private int delay = 2000;
        private TopicConnection connection = null;

        Publisher() {
        }

        public void run() {
            try {
                boolean IS_TRANSACTED = true;
                int ACKNOWLEDGE_MODE = 3;
                InitialContext namingContext = new InitialContext();
                TopicConnectionFactory fact = (TopicConnectionFactory)namingContext.lookup("TopicConnectionFactory");
                this.connection = fact.createTopicConnection();
                Topic topic = (Topic)namingContext.lookup("topic/metrics");
                TopicSession session = this.connection.createTopicSession(true, 3);
                TopicPublisher pub = session.createPublisher(topic);
                pub.setDeliveryMode(1);
                pub.setPriority(4);
                pub.setTimeToLive(0L);
                this.connection.start();
                while (this.running) {
                    long sleepTime = this.delay;
                    try {
                        Object[] array;
                        Thread.sleep(sleepTime);
                        long begin = System.currentTimeMillis();
                        List list = MetricsInterceptor.this.msgQueue;
                        synchronized (list) {
                            array = MetricsInterceptor.this.msgQueue.toArray();
                            MetricsInterceptor.this.msgQueue.clear();
                        }
                        int i = 0;
                        while (i < array.length) {
                            Message msg = MetricsInterceptor.this.createMessage((Session)session, ((Entry)array[i]).principal, ((Entry)array[i]).id, ((Entry)array[i]).method, ((Entry)array[i]).checkpoint, ((Entry)array[i]).time);
                            pub.publish(msg);
                            ++i;
                        }
                        try {
                            session.commit();
                        }
                        catch (Exception exception) {}
                        long end = System.currentTimeMillis();
                        sleepTime = (long)this.delay - (end - begin);
                    }
                    catch (InterruptedException interruptedException) {
                        this.running = false;
                    }
                }
                this.connection.close();
            }
            catch (NamingException e) {
                System.out.println(e);
            }
            catch (JMSException e) {
                System.out.println((Object)e);
            }
        }
    }

    private final class Entry {
        int id = -1;
        long time;
        String principal = null;
        String checkpoint;
        String method;

        Entry(Principal principal, Method method, Transaction tx, long time, String checkpoint) {
            this.time = time;
            this.checkpoint = checkpoint;
            this.method = method.getName();
            if (tx != null) {
                this.id = tx.hashCode();
            }
            if (principal != null) {
                this.principal = principal.getName();
            }
        }
    }
}

