/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Set;
import org.jboss.ejb.Container;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class SecurityInterceptor
extends AbstractInterceptor {
    protected Container container;
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;
    protected Principal runAsRole;

    private void checkSecurityAssociation(MethodInvocation mi, boolean home) throws Exception {
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        if (this.securityManager == null) {
            SecurityAssociation.setPrincipal(principal);
            SecurityAssociation.setCredential(credential);
            return;
        }
        if (this.realmMapping == null) {
            throw new RemoteException("checkSecurityAssociation", new SecurityException("Role mapping manager has not been set"));
        }
        if (!this.securityManager.isValid(principal, credential)) {
            String msg = "Authentication exception, principal=" + principal;
            this.log.error(msg);
            SecurityException e = new SecurityException(msg);
            throw new RemoteException("checkSecurityAssociation", e);
        }
        SecurityAssociation.setPrincipal(principal);
        SecurityAssociation.setCredential(credential);
        Set methodRoles = this.container.getMethodPermissions(mi.getMethod(), home);
        if (methodRoles == null) {
            String method = mi.getMethod().getName();
            String msg = "No method permissions assigned to method=" + method;
            this.log.error(msg);
            SecurityException e = new SecurityException(msg);
            throw new RemoteException("checkSecurityAssociation", e);
        }
        Principal threadRunAsRole = SecurityAssociation.peekRunAsRole();
        if (threadRunAsRole != null) {
            if (!methodRoles.contains(threadRunAsRole) && !methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
                String method = mi.getMethod().getName();
                String msg = "Insufficient method permissions, runAsRole=" + threadRunAsRole + ", method=" + method + ", requiredRoles=" + methodRoles;
                this.log.error(msg);
                SecurityException e = new SecurityException(msg);
                throw new RemoteException("checkSecurityAssociation", e);
            }
        } else if (!this.realmMapping.doesUserHaveRole(principal, methodRoles)) {
            String method = mi.getMethod().getName();
            Set userRoles = this.realmMapping.getUserRoles(principal);
            String msg = "Insufficient method permissions, principal=" + principal + ", method=" + method + ", requiredRoles=" + methodRoles + ", principalRoles=" + userRoles;
            this.log.error(msg);
            SecurityException e = new SecurityException(msg);
            throw new RemoteException("checkSecurityAssociation", e);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation mi) throws Exception {
        Object object;
        this.checkSecurityAssociation(mi, false);
        if (this.runAsRole != null) {
            SecurityAssociation.pushRunAsRole(this.runAsRole);
        }
        try {
            Object returnValue;
            object = returnValue = this.getNext().invoke(mi);
            Object var4_4 = null;
            if (this.runAsRole == null) return object;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.runAsRole == null) throw throwable;
            SecurityAssociation.popRunAsRole();
            throw throwable;
        }
        SecurityAssociation.popRunAsRole();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invokeHome(MethodInvocation mi) throws Exception {
        Object object;
        this.checkSecurityAssociation(mi, true);
        if (this.runAsRole != null) {
            SecurityAssociation.pushRunAsRole(this.runAsRole);
        }
        try {
            Object returnValue;
            object = returnValue = this.getNext().invokeHome(mi);
            Object var4_4 = null;
            if (this.runAsRole == null) return object;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.runAsRole == null) throw throwable;
            SecurityAssociation.popRunAsRole();
            throw throwable;
        }
        SecurityAssociation.popRunAsRole();
        return object;
    }

    public void setContainer(Container container) {
        this.container = container;
        BeanMetaData beanMetaData = container.getBeanMetaData();
        SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
        if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
            String roleName = secMetaData.getRunAsRoleName();
            this.runAsRole = new SimplePrincipal(roleName);
        }
        this.securityManager = container.getSecurityManager();
        this.realmMapping = container.getRealmMapping();
    }

    public void start() throws Exception {
        super.start();
    }
}

