/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.security.Principal;
import javax.ejb.EJBContext;
import javax.naming.InitialContext;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvokerContainer;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityProxy;
import org.jboss.security.SecurityProxyFactory;

public class SecurityProxyInterceptor
extends AbstractInterceptor {
    public final String SECURITY_PROXY_FACTORY_NAME = "java:/SecurityProxyFactory";
    protected Container container;
    protected AuthenticationManager securityManager;
    protected SecurityProxy securityProxy;

    public Container getContainer() {
        return this.container;
    }

    public Object invoke(MethodInvocation mi) throws Exception {
        if (this.securityProxy != null) {
            Object bean = mi.getEnterpriseContext().getInstance();
            EJBContext ctx = mi.getEnterpriseContext().getEJBContext();
            Object[] args = mi.getArguments();
            this.securityProxy.setEJBContext(ctx);
            try {
                this.securityProxy.invoke(mi.getMethod(), args, bean);
            }
            catch (SecurityException e) {
                Principal principal = mi.getPrincipal();
                String msg = "SecurityProxy.invoke exception, principal=" + principal + ", msg=" + e.getMessage();
                System.err.println(msg);
                SecurityException se = new SecurityException(msg);
                throw new RemoteException(msg, se);
            }
        }
        return this.getNext().invoke(mi);
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        if (this.securityProxy != null) {
            EJBContext ctx = null;
            EnterpriseContext ectx = mi.getEnterpriseContext();
            if (ectx != null) {
                ctx = ectx.getEJBContext();
            }
            Object[] args = mi.getArguments();
            this.securityProxy.setEJBContext(ctx);
            try {
                this.securityProxy.invokeHome(mi.getMethod(), args);
            }
            catch (SecurityException securityException) {
                Principal principal = mi.getPrincipal();
                String msg = "SecurityProxy.invokeHome exception, principal=" + principal;
                System.err.println(msg);
                SecurityException se = new SecurityException(msg);
                throw new RemoteException("SecurityProxy.invokeHome failure", se);
            }
        }
        return this.getNext().invokeHome(mi);
    }

    public void setContainer(Container container) {
        this.container = container;
        this.securityManager = container.getSecurityManager();
        Object secProxy = container.getSecurityProxy();
        if (secProxy != null) {
            if (!(secProxy instanceof SecurityProxy)) {
                try {
                    InitialContext iniCtx = new InitialContext();
                    SecurityProxyFactory proxyFactory = (SecurityProxyFactory)iniCtx.lookup("java:/SecurityProxyFactory");
                    this.securityProxy = proxyFactory.create(secProxy);
                }
                catch (Exception e) {
                    System.out.println("Failed to initialze DefaultSecurityProxy");
                    e.printStackTrace();
                }
            } else {
                this.securityProxy = (SecurityProxy)secProxy;
            }
            try {
                ContainerInvokerContainer ic = (ContainerInvokerContainer)((Object)container);
                Class beanHome = ic.getHomeClass();
                Class beanRemote = ic.getRemoteClass();
                this.securityProxy.init(beanHome, beanRemote, this.securityManager);
            }
            catch (Exception e) {
                System.out.println("Failed to initialze SecurityProxy");
                e.printStackTrace();
            }
            System.out.println("Initialized SecurityProxy=" + this.securityProxy);
        }
    }

    public void start() throws Exception {
        super.start();
    }
}

