/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.plugins.StatefulSessionBeanField;

class SessionObjectInputStream
extends ObjectInputStream {
    StatefulSessionEnterpriseContext ctx;
    ClassLoader appCl;

    public SessionObjectInputStream(StatefulSessionEnterpriseContext ctx, InputStream in) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.ctx = ctx;
        this.appCl = Thread.currentThread().getContextClassLoader();
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        try {
            return this.appCl.loadClass(v.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(v);
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof Handle) {
            return ((Handle)obj).getEJBObject();
        }
        if (obj instanceof HomeHandle) {
            return ((HomeHandle)obj).getEJBHome();
        }
        if (obj instanceof StatefulSessionBeanField) {
            byte type = ((StatefulSessionBeanField)obj).type;
            if (type == 0) {
                return this.ctx.getSessionContext();
            }
            if (type == 1) {
                return this.ctx.getSessionContext().getUserTransaction();
            }
        }
        return obj;
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        Class[] ifaceClasses = new Class[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            ifaceClasses[i] = Class.forName(interfaces[i], false, this.appCl);
            ++i;
        }
        try {
            clazz = Proxy.getProxyClass(this.appCl, ifaceClasses);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException("Failed to resolve proxy class", e);
        }
        return clazz;
    }
}

