/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import org.jboss.ejb.Container;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.SessionObjectInputStream;
import org.jboss.ejb.plugins.SessionObjectOutputStream;
import org.jboss.logging.Logger;

public class StatefulSessionFilePersistenceManager
implements StatefulSessionPersistenceManager {
    static Logger log = Logger.getLogger(class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager != null ? class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager : (class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager = StatefulSessionFilePersistenceManager.class$("org.jboss.ejb.plugins.StatefulSessionFilePersistenceManager")));
    private StatefulSessionContainer con;
    private Method ejbActivate;
    private Method ejbPassivate;
    private Method ejbRemove;
    private File dir;
    private ArrayList fields;
    private static long id = System.currentTimeMillis();
    static /* synthetic */ Class class$org$jboss$ejb$plugins$StatefulSessionFilePersistenceManager;
    static /* synthetic */ Class class$javax$ejb$SessionBean;
    static /* synthetic */ Class class$java$lang$Object;

    public void activateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        try {
            SessionObjectInputStream in = new SessionObjectInputStream(ctx, new FileInputStream(this.getFile(ctx.getId())));
            ctx.setInstance(in.readObject());
            in.close();
            this.removePassivated(ctx.getId());
            this.ejbActivate.invoke(ctx.getInstance(), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ServerException("Could not activate", e);
        }
        catch (IOException e) {
            throw new ServerException("Could not activate", e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw (Error)e;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void createSession(Method m, Object[] args, StatefulSessionEnterpriseContext ctx) throws Exception {
        ctx.setId(this.nextId());
        try {
            Method createMethod = this.con.getBeanClass().getMethod("ejbCreate", m.getParameterTypes());
            createMethod.invoke(ctx.getInstance(), args);
        }
        catch (IllegalAccessException e) {
            ctx.setId(null);
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            ctx.setId(null);
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        this.con.getInstanceCache().insert(ctx);
        if (this.con.getContainerInvoker() != null) {
            ctx.setEJBObject(this.con.getContainerInvoker().getStatefulSessionEJBObject(ctx.getId()));
        }
        if (this.con.getLocalHomeClass() != null) {
            ctx.setEJBLocalObject(this.con.getLocalContainerInvoker().getStatefulSessionEJBLocalObject(ctx.getId()));
        }
    }

    public void destroy() {
    }

    protected File getFile(Object key) {
        return new File(this.dir, String.valueOf(String.valueOf(key)) + ".ser");
    }

    public void init() throws Exception {
        this.ejbActivate = (class$javax$ejb$SessionBean != null ? class$javax$ejb$SessionBean : (class$javax$ejb$SessionBean = StatefulSessionFilePersistenceManager.class$("javax.ejb.SessionBean"))).getMethod("ejbActivate", new Class[0]);
        this.ejbPassivate = (class$javax$ejb$SessionBean != null ? class$javax$ejb$SessionBean : (class$javax$ejb$SessionBean = StatefulSessionFilePersistenceManager.class$("javax.ejb.SessionBean"))).getMethod("ejbPassivate", new Class[0]);
        this.ejbRemove = (class$javax$ejb$SessionBean != null ? class$javax$ejb$SessionBean : (class$javax$ejb$SessionBean = StatefulSessionFilePersistenceManager.class$("javax.ejb.SessionBean"))).getMethod("ejbRemove", new Class[0]);
        String ejbName = this.con.getBeanMetaData().getEjbName();
        File databaseDir = new File(this.getClass().getResource("/db.properties").getFile()).getParentFile();
        File database = new File(databaseDir, "sessions");
        this.dir = new File(database, ejbName);
        this.dir.mkdirs();
        log.debug("Storing sessions for " + ejbName + " in:" + this.dir);
        File[] sessions = this.dir.listFiles();
        int i = 0;
        while (i < sessions.length) {
            sessions[i].delete();
            ++i;
        }
        log.debug(String.valueOf(sessions.length) + " old sessions removed");
        Class beanClass = this.con.getBeanClass();
        this.fields = new ArrayList();
        while (!beanClass.equals(class$java$lang$Object != null ? class$java$lang$Object : StatefulSessionFilePersistenceManager.class$("java.lang.Object"))) {
            Field[] f = beanClass.getDeclaredFields();
            int i2 = 0;
            while (i2 < f.length) {
                if (!Modifier.isTransient(f[i2].getModifiers())) {
                    this.fields.add(f[i2]);
                }
                ++i2;
            }
            beanClass = beanClass.getSuperclass();
        }
    }

    protected synchronized Long nextId() {
        return new Long(id++);
    }

    public void passivateSession(StatefulSessionEnterpriseContext ctx) throws RemoteException {
        try {
            this.ejbPassivate.invoke(ctx.getInstance(), new Object[0]);
            SessionObjectOutputStream out = new SessionObjectOutputStream(new FileOutputStream(this.getFile(ctx.getId())));
            out.writeObject(ctx.getInstance());
            out.close();
        }
        catch (IOException e) {
            throw new ServerException("Could not passivate", e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw (Error)e;
        }
    }

    public void removePassivated(Object key) {
        this.getFile(key).delete();
    }

    public void removeSession(StatefulSessionEnterpriseContext ctx) throws RemoteException, RemoveException {
        try {
            this.ejbRemove.invoke(ctx.getInstance(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof RemoveException) {
                throw (RemoveException)e;
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw (Error)e;
        }
    }

    public void setContainer(Container c) {
        this.con = (StatefulSessionContainer)c;
    }

    public void start() throws Exception {
    }

    public void stop() {
    }
}

