/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.SystemException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionEnterpriseContext;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.plugins.AbstractInstanceCache;

public class StatefulSessionInstanceCache
extends AbstractInstanceCache {
    private StatefulSessionContainer m_container;
    private HashMap m_passivated = new HashMap();
    private StringBuffer m_buffer = new StringBuffer();

    protected EnterpriseContext acquireContext() throws Exception {
        return this.m_container.getInstancePool().get();
    }

    protected void activate(EnterpriseContext ctx) throws RemoteException {
        this.m_container.getPersistenceManager().activateSession((StatefulSessionEnterpriseContext)ctx);
        this.m_passivated.remove(ctx.getId());
    }

    protected boolean canPassivate(EnterpriseContext ctx) {
        if (ctx.isLocked()) {
            return false;
        }
        if (ctx.getTransaction() != null) {
            try {
                return ctx.getTransaction().getStatus() == 6;
            }
            catch (SystemException systemException) {
                return false;
            }
        }
        return true;
    }

    public void destroy() {
        StatefulSessionInstanceCache statefulSessionInstanceCache = this;
        synchronized (statefulSessionInstanceCache) {
            this.m_container = null;
        }
        this.m_passivated.clear();
        super.destroy();
    }

    protected void freeContext(EnterpriseContext ctx) {
        if (this.m_container != null) {
            this.m_container.getInstancePool().free(ctx);
        }
    }

    protected Container getContainer() {
        return this.m_container;
    }

    protected Object getKey(EnterpriseContext ctx) {
        return ctx.getId();
    }

    private void log(Object key) {
        if (this.log.isTraceEnabled()) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("Removing from storage bean '");
            this.m_buffer.append(this.m_container.getBeanMetaData().getEjbName());
            this.m_buffer.append("' with id = ");
            this.m_buffer.append(key);
            this.log.trace(this.m_buffer.toString());
        }
    }

    protected void passivate(EnterpriseContext ctx) throws RemoteException {
        this.m_container.getPersistenceManager().passivateSession((StatefulSessionEnterpriseContext)ctx);
        this.m_passivated.put(ctx.getId(), new Long(System.currentTimeMillis()));
    }

    void removePassivated(long maxLifeAfterPassivation) {
        StatefulSessionPersistenceManager store = this.m_container.getPersistenceManager();
        long now = System.currentTimeMillis();
        Iterator entries = this.m_passivated.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object key = entry.getKey();
            long passivationTime = (Long)entry.getValue();
            if (now - passivationTime <= maxLifeAfterPassivation) continue;
            store.removePassivated(key);
            this.log(key);
            entries.remove();
        }
    }

    public void setContainer(Container c) {
        this.m_container = (StatefulSessionContainer)c;
    }

    protected void setKey(Object id, EnterpriseContext ctx) {
        ctx.setId(id);
    }
}

