/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.log4j.Category;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.metadata.SessionMetaData;
import org.jboss.security.SecurityAssociation;

public class StatefulSessionInstanceInterceptor
extends AbstractInterceptor {
    protected StatefulSessionContainer container;
    private static Method getEJBHome;
    private static Method getHandle;
    private static Method getPrimaryKey;
    private static Method isIdentical;
    private static Method remove;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$org$jboss$ejb$plugins$StatefulSessionInstanceInterceptor;

    static {
        try {
            Class[] noArg = new Class[]{};
            getEJBHome = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = StatefulSessionInstanceInterceptor.class$("javax.ejb.EJBObject"))).getMethod("getEJBHome", noArg);
            getHandle = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = StatefulSessionInstanceInterceptor.class$("javax.ejb.EJBObject"))).getMethod("getHandle", noArg);
            getPrimaryKey = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = StatefulSessionInstanceInterceptor.class$("javax.ejb.EJBObject"))).getMethod("getPrimaryKey", noArg);
            isIdentical = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = StatefulSessionInstanceInterceptor.class$("javax.ejb.EJBObject"))).getMethod("isIdentical", class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = StatefulSessionInstanceInterceptor.class$("javax.ejb.EJBObject")));
            remove = (class$javax$ejb$EJBObject != null ? class$javax$ejb$EJBObject : (class$javax$ejb$EJBObject = StatefulSessionInstanceInterceptor.class$("javax.ejb.EJBObject"))).getMethod("remove", noArg);
        }
        catch (Exception e) {
            Category tmp = Category.getInstance((Class)(class$org$jboss$ejb$plugins$StatefulSessionInstanceInterceptor != null ? class$org$jboss$ejb$plugins$StatefulSessionInstanceInterceptor : (class$org$jboss$ejb$plugins$StatefulSessionInstanceInterceptor = StatefulSessionInstanceInterceptor.class$("org.jboss.ejb.plugins.StatefulSessionInstanceInterceptor"))));
            tmp.error((Object)"Static setup failed", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation mi) throws Exception {
        InstanceCache cache = this.container.getInstanceCache();
        InstancePool pool = this.container.getInstancePool();
        Object methodID = mi.getId();
        EnterpriseContext ctx = null;
        BeanLock lock = this.container.getLockManager().getLock(methodID);
        try {
            block20: {
                lock.sync();
                try {
                    SecurityAssociation.setPrincipal(mi.getPrincipal());
                    SecurityAssociation.setCredential(mi.getCredential());
                    ctx = cache.get(methodID);
                    mi.setEnterpriseContext(ctx);
                    if (!((SessionMetaData)this.container.getBeanMetaData()).isBeanManagedTx()) {
                        if (ctx.getTransaction() != null && !ctx.getTransaction().equals(mi.getTransaction())) {
                            throw new RemoteException("Application Error: tried to enter Stateful bean with different transaction context");
                        }
                        if (ctx.getTransaction() == null && mi.getTransaction() != null) {
                            this.register(ctx, mi.getTransaction(), lock);
                        }
                    }
                    if (!ctx.isLocked()) {
                        ctx.lock();
                        break block20;
                    }
                    if (!this.isCallAllowed(mi)) {
                        throw new RemoteException("Application Error: no concurrent calls on stateful beans");
                    }
                    ctx.lock();
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    lock.releaseSync();
                    throw throwable;
                }
            }
            Object var11_7 = null;
            lock.releaseSync();
            try {}
            catch (Throwable throwable) {
                var11_7 = null;
                if (ctx == null) throw throwable;
                lock.sync();
                try {}
                catch (Throwable throwable2) {
                    Object var13_15 = null;
                    lock.releaseSync();
                    throw throwable2;
                }
                ctx.unlock();
                if (ctx.getId() == null) {
                    cache.remove(methodID);
                    pool.free(ctx);
                }
                Object var13_14 = null;
                lock.releaseSync();
                throw throwable;
            }
            {
                try {
                    Object object = this.getNext().invoke(mi);
                    var11_7 = null;
                    if (ctx != null) {
                        block21: {
                            lock.sync();
                            try {
                                ctx.unlock();
                                if (ctx.getId() != null) break block21;
                                cache.remove(methodID);
                                pool.free(ctx);
                            }
                            catch (Throwable throwable) {
                                Object var13_13 = null;
                                lock.releaseSync();
                                throw throwable;
                            }
                        }
                        Object var13_12 = null;
                        lock.releaseSync();
                    }
                    Object var9_21 = null;
                    this.container.getLockManager().removeLockRef(lock.getId());
                    return object;
                }
                catch (RemoteException e) {
                    cache.remove(methodID);
                    pool.discard(ctx);
                    ctx = null;
                    throw e;
                }
                catch (RuntimeException e) {
                    cache.remove(methodID);
                    pool.discard(ctx);
                    ctx = null;
                    throw e;
                }
                catch (Error e) {
                    cache.remove(methodID);
                    pool.discard(ctx);
                    ctx = null;
                    throw e;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_22 = null;
            this.container.getLockManager().removeLockRef(lock.getId());
            throw throwable;
        }
    }

    public Object invokeHome(MethodInvocation mi) throws Exception {
        EnterpriseContext enterpriseContext;
        Object object;
        InstancePool pool = this.container.getInstancePool();
        EnterpriseContext ctx = pool.get();
        mi.setEnterpriseContext(ctx);
        ctx.setPrincipal(mi.getPrincipal());
        ctx.lock();
        try {
            object = this.getNext().invokeHome(mi);
            Object var6_5 = null;
            enterpriseContext = ctx;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            EnterpriseContext enterpriseContext2 = ctx;
            synchronized (enterpriseContext2) {
                ctx.unlock();
                if (ctx.getId() == null) {
                    pool.free(ctx);
                }
            }
            throw throwable;
        }
        synchronized (enterpriseContext) {
            ctx.unlock();
            if (ctx.getId() == null) {
                pool.free(ctx);
            }
        }
        return object;
    }

    private boolean isCallAllowed(MethodInvocation mi) {
        Method m = mi.getMethod();
        return m.equals(getEJBHome) || m.equals(getHandle) || m.equals(getPrimaryKey) || m.equals(isIdentical) || m.equals(remove);
    }

    private void register(EnterpriseContext ctx, Transaction tx, BeanLock lock) {
        InstanceSynchronization synch = new InstanceSynchronization(tx, ctx, lock);
        try {
            if (tx.getStatus() == 1) {
                return;
            }
            try {
                tx.registerSynchronization((Synchronization)synch);
            }
            catch (Exception ex) {
                this.getContainer().getLockManager().removeLockRef(lock.getId());
                throw ex;
            }
            synch.afterBegin();
        }
        catch (RollbackException e) {
            this.log.debug("register failure", e);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void setContainer(Container container) {
        this.container = (StatefulSessionContainer)container;
    }

    private class InstanceSynchronization
    implements Synchronization {
        private Transaction tx;
        private EnterpriseContext ctx;
        private boolean notifySession;
        private Method afterBegin;
        private Method beforeCompletion;
        private Method afterCompletion;
        private BeanLock lock;

        InstanceSynchronization(Transaction tx, EnterpriseContext ctx, BeanLock lock) {
            block2: {
                this.notifySession = false;
                this.tx = tx;
                this.ctx = ctx;
                this.lock = lock;
                this.lock.addRef();
                this.notifySession = ctx.getInstance() instanceof SessionSynchronization;
                if (!this.notifySession) break block2;
                try {
                    Class<?> sync = Class.forName("javax.ejb.SessionSynchronization");
                    this.afterBegin = sync.getMethod("afterBegin", new Class[0]);
                    this.beforeCompletion = sync.getMethod("beforeCompletion", new Class[0]);
                    this.afterCompletion = sync.getMethod("afterCompletion", Boolean.TYPE);
                }
                catch (Exception e) {
                    StatefulSessionInstanceInterceptor.this.log.error("failed to setup InstanceSynchronization", e);
                }
            }
        }

        public void afterBegin() {
            if (this.notifySession) {
                try {
                    this.afterBegin.invoke(this.ctx.getInstance(), new Object[0]);
                }
                catch (Exception e) {
                    StatefulSessionInstanceInterceptor.this.log.error("failed to invoke afterBegin", e);
                    try {
                        this.tx.setRollbackOnly();
                    }
                    catch (SystemException systemException) {}
                    throw new EJBException("Unexpected error in afterBegin", e);
                }
            }
        }

        public void afterCompletion(int status) {
            this.lock.sync();
            try {
                this.ctx.setTransaction(null);
                this.ctx.unlock();
                if (this.notifySession) {
                    try {
                        if (status == 3) {
                            this.afterCompletion.invoke(this.ctx.getInstance(), Boolean.TRUE);
                        } else {
                            this.afterCompletion.invoke(this.ctx.getInstance(), Boolean.FALSE);
                        }
                    }
                    catch (Exception e) {
                        StatefulSessionInstanceInterceptor.this.log.error("failed to invoke afterCompletion", e);
                        throw new EJBException("Unexpected error in afterCompletion", e);
                    }
                }
                Object var3_3 = null;
                this.lock.releaseSync();
                StatefulSessionInstanceInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.lock.releaseSync();
                StatefulSessionInstanceInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                throw throwable;
            }
        }

        public void beforeCompletion() {
            this.ctx.lock();
            if (this.notifySession) {
                try {
                    this.beforeCompletion.invoke(this.ctx.getInstance(), new Object[0]);
                }
                catch (Exception e) {
                    StatefulSessionInstanceInterceptor.this.log.error("failed to invoke beforeCompletion", e);
                    try {
                        this.tx.setRollbackOnly();
                    }
                    catch (SystemException systemException) {}
                    throw new EJBException("Unexpected error in beforeCompletion", e);
                }
            }
        }
    }
}

