/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;
import org.jboss.ejb.plugins.jaws.metadata.JawsEntityMetaData;
import org.jboss.ejb.plugins.jaws.metadata.PkFieldMetaData;
import org.jboss.logging.Logger;

public abstract class JDBCCommand {
    private static final HashMap rsTypes = new HashMap();
    protected JDBCCommandFactory factory;
    protected JawsEntityMetaData jawsEntity;
    protected Logger log;
    protected String name;
    private String sql;
    private static Map jdbcTypeNames;
    public static boolean debug;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;
    static /* synthetic */ Class class$java$sql$Types;

    static {
        Class[] arg = new Class[]{Integer.TYPE};
        try {
            rsTypes.put((class$java$util$Date != null ? class$java$util$Date : (class$java$util$Date = JDBCCommand.class$("java.util.Date"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getTimestamp", arg));
            rsTypes.put((class$java$sql$Date != null ? class$java$sql$Date : (class$java$sql$Date = JDBCCommand.class$("java.sql.Date"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getDate", arg));
            rsTypes.put((class$java$sql$Time != null ? class$java$sql$Time : (class$java$sql$Time = JDBCCommand.class$("java.sql.Time"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getTime", arg));
            rsTypes.put((class$java$sql$Timestamp != null ? class$java$sql$Timestamp : (class$java$sql$Timestamp = JDBCCommand.class$("java.sql.Timestamp"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getTimestamp", arg));
            rsTypes.put((class$java$math$BigDecimal != null ? class$java$math$BigDecimal : (class$java$math$BigDecimal = JDBCCommand.class$("java.math.BigDecimal"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getBigDecimal", arg));
            rsTypes.put((class$java$sql$Ref != null ? class$java$sql$Ref : (class$java$sql$Ref = JDBCCommand.class$("java.sql.Ref"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getRef", arg));
            rsTypes.put((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JDBCCommand.class$("java.lang.String"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getString", arg));
            rsTypes.put((class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = JDBCCommand.class$("java.lang.Boolean"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getBoolean", arg));
            rsTypes.put(Boolean.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getBoolean", arg));
            rsTypes.put((class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = JDBCCommand.class$("java.lang.Byte"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getByte", arg));
            rsTypes.put(Byte.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getByte", arg));
            rsTypes.put((class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = JDBCCommand.class$("java.lang.Double"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getDouble", arg));
            rsTypes.put(Double.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getDouble", arg));
            rsTypes.put((class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = JDBCCommand.class$("java.lang.Float"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getFloat", arg));
            rsTypes.put(Float.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getFloat", arg));
            rsTypes.put((class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = JDBCCommand.class$("java.lang.Integer"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getInt", arg));
            rsTypes.put(Integer.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getInt", arg));
            rsTypes.put((class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = JDBCCommand.class$("java.lang.Long"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getLong", arg));
            rsTypes.put(Long.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getLong", arg));
            rsTypes.put((class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = JDBCCommand.class$("java.lang.Short"))).getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getShort", arg));
            rsTypes.put(Short.TYPE.getName(), (class$java$sql$ResultSet != null ? class$java$sql$ResultSet : (class$java$sql$ResultSet = JDBCCommand.class$("java.sql.ResultSet"))).getMethod("getShort", arg));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        debug = false;
    }

    protected JDBCCommand(JDBCCommandFactory factory, String name) {
        this.factory = factory;
        this.jawsEntity = factory.getMetaData();
        this.log = factory.getLog();
        this.name = name;
        debug = factory.getDebug();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected abstract Object executeStatementAndHandleResult(PreparedStatement var1, Object var2) throws Exception;

    protected Object getCMPFieldValue(Object instance, CMPFieldMetaData fieldMetaData) throws IllegalAccessException {
        return fieldMetaData.getValue(instance);
    }

    protected Connection getConnection() throws SQLException {
        return this.jawsEntity.getConnection();
    }

    protected final int getJDBCType(String name) {
        try {
            Integer constant = (Integer)(class$java$sql$Types != null ? class$java$sql$Types : (class$java$sql$Types = JDBCCommand.class$("java.sql.Types"))).getField(name).get(null);
            return constant;
        }
        catch (Exception e) {
            this.log.debug("JDBC type error", e);
            return 1111;
        }
    }

    protected final String getJDBCTypeName(int jdbcType) {
        if (jdbcTypeNames == null) {
            this.setUpJDBCTypeNames();
        }
        return (String)jdbcTypeNames.get(new Integer(jdbcType));
    }

    protected int getJawsCMPFieldJDBCType(CMPFieldMetaData fieldMetaData) {
        return fieldMetaData.getJDBCType();
    }

    protected final String getPkColumnList() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.jawsEntity.getPkFields();
        while (it.hasNext()) {
            PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
            sb.append(pkFieldMetaData.getColumnName());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected final String getPkColumnWhereList() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.jawsEntity.getPkFields();
        while (it.hasNext()) {
            PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
            sb.append(pkFieldMetaData.getColumnName());
            sb.append("=?");
            if (!it.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    protected Object getPkFieldValue(Object pk, PkFieldMetaData pkFieldMetaData) throws IllegalAccessException {
        Field field = pkFieldMetaData.getPkField();
        return field.get(pk);
    }

    protected Object getResultObject(ResultSet rs, int idx, Class destination) throws SQLException {
        Object result = null;
        Method method = (Method)rsTypes.get(destination.getName());
        if (method != null) {
            try {
                result = method.invoke((Object)rs, new Integer(idx));
                if (rs.wasNull()) {
                    return null;
                }
                return result;
            }
            catch (IllegalAccessException e) {
                this.log.debug("Unable to read from ResultSet: " + e);
            }
            catch (InvocationTargetException e) {
                this.log.debug("Unable to read from ResultSet: " + e);
            }
        }
        if ((result = rs.getObject(idx)) == null) {
            return null;
        }
        if (destination.isAssignableFrom(result.getClass()) && !result.getClass().equals(class$java$rmi$MarshalledObject != null ? class$java$rmi$MarshalledObject : (class$java$rmi$MarshalledObject = JDBCCommand.class$("java.rmi.MarshalledObject")))) {
            return result;
        }
        if (debug) {
            this.log.debug("Got a " + result.getClass().getName() + ": '" + result + "' while looking for a " + destination.getName());
        }
        byte[] bytes = null;
        if (result instanceof byte[]) {
            bytes = (byte[])result;
        } else if (result instanceof Blob) {
            Blob blob = (Blob)result;
            bytes = blob.getBytes(1L, (int)blob.length());
        } else {
            if (result instanceof Clob && destination.getName().equals("java.lang.String")) {
                try {
                    int count;
                    BufferedReader in = new BufferedReader(((Clob)result).getCharacterStream());
                    char[] buf = new char[512];
                    StringBuffer string = new StringBuffer("");
                    while ((count = in.read(buf)) > -1) {
                        string.append(buf, 0, count);
                    }
                    ((Reader)in).close();
                    return string.toString();
                }
                catch (IOException e) {
                    this.log.error("Unable to read a CLOB column: " + e);
                    throw new SQLException("Unable to read a CLOB column: " + e);
                }
            }
            bytes = rs.getBytes(idx);
        }
        if (bytes == null) {
            result = null;
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                result = ((MarshalledObject)ois.readObject()).get();
                if (result instanceof Handle) {
                    result = ((Handle)result).getEJBObject();
                }
                if (result instanceof MarshalledObject && !destination.equals(class$java$rmi$MarshalledObject != null ? class$java$rmi$MarshalledObject : (class$java$rmi$MarshalledObject = JDBCCommand.class$("java.rmi.MarshalledObject")))) {
                    result = ((MarshalledObject)result).get();
                }
                if (!destination.isAssignableFrom(result.getClass())) {
                    boolean found = false;
                    if (destination.isPrimitive() && (destination.equals(Byte.TYPE) && result instanceof Byte || destination.equals(Short.TYPE) && result instanceof Short || destination.equals(Character.TYPE) && result instanceof Character || destination.equals(Boolean.TYPE) && result instanceof Boolean || destination.equals(Integer.TYPE) && result instanceof Integer || destination.equals(Long.TYPE) && result instanceof Long || destination.equals(Float.TYPE) && result instanceof Float || destination.equals(Double.TYPE) && result instanceof Double)) {
                        found = true;
                    }
                    if (!found) {
                        this.log.debug("Unable to load a ResultSet column into a variable of type '" + destination.getName() + "' (got a " + result.getClass().getName() + ")");
                        result = null;
                    }
                }
                ois.close();
            }
            catch (RemoteException e) {
                throw new SQLException("Unable to load EJBObject back from Handle: " + e);
            }
            catch (IOException e) {
                throw new SQLException("Unable to load a ResultSet column " + idx + " into a variable of type '" + destination.getName() + "': " + e);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Unable to load a ResultSet column " + idx + " into a variable of type '" + destination.getName() + "': " + e);
            }
        }
        return result;
    }

    protected Object getResultObject(ResultSet rs, int idx, CMPFieldMetaData cmpField) throws SQLException {
        if (!cmpField.isNested()) {
            return this.getResultObject(rs, idx, cmpField.getField().getType());
        }
        return rs.getObject(idx);
    }

    protected String getSQL(Object argOrArgs) throws Exception {
        return this.sql;
    }

    protected Object[] getState(EntityEnterpriseContext ctx) {
        Object[] state = new Object[this.jawsEntity.getNumberOfCMPFields()];
        Iterator iter = this.jawsEntity.getCMPFields();
        int i = 0;
        while (iter.hasNext()) {
            CMPFieldMetaData fieldMetaData = (CMPFieldMetaData)iter.next();
            try {
                state[i++] = this.getCMPFieldValue(ctx.getInstance(), fieldMetaData);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return state;
    }

    protected final boolean isBinaryType(int jdbcType) {
        return jdbcType == -2 || jdbcType == 2004 || jdbcType == 2005 || jdbcType == 2000 || jdbcType == -4 || jdbcType == 1111 || jdbcType == 2002 || jdbcType == -3;
    }

    protected Object jdbcExecute(Object argOrArgs) throws Exception {
        SQLException e32;
        Object result;
        Connection con;
        block14: {
            con = null;
            Statement stmt = null;
            result = null;
            try {
                try {
                    con = this.getConnection();
                    String theSQL = this.getSQL(argOrArgs);
                    if (debug) {
                        this.log.debug(String.valueOf(this.name) + " command executing: " + theSQL);
                    }
                    stmt = con.prepareStatement(theSQL);
                    this.setParameters((PreparedStatement)stmt, argOrArgs);
                    result = this.executeStatementAndHandleResult((PreparedStatement)stmt, argOrArgs);
                }
                catch (SQLException e2) {
                    this.log.debug(e2);
                    throw e2;
                }
                Object var6_8 = null;
                if (stmt == null) break block14;
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var6_9 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e32) {
                        this.log.debug("SQL error", e32);
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        this.log.debug("SQL error", e32);
                    }
                }
                throw throwable;
            }
            try {
                stmt.close();
            }
            catch (SQLException e32) {
                this.log.debug("SQL error", e32);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                this.log.debug("SQL error", e32);
            }
        }
        return result;
    }

    protected void setCMPFieldValue(Object instance, CMPFieldMetaData fieldMetaData, Object value) throws IllegalAccessException {
        if (fieldMetaData.isNested()) {
            fieldMetaData.set(instance, value);
        } else {
            Field field = fieldMetaData.getField();
            field.set(instance, value);
        }
    }

    protected void setParameter(PreparedStatement stmt, int idx, int jdbcType, Object value) throws SQLException {
        if (debug) {
            this.log.debug("Set parameter: idx=" + idx + ", jdbcType=" + this.getJDBCTypeName(jdbcType) + ", value=" + (value == null ? "NULL" : value));
        }
        if (value == null) {
            stmt.setNull(idx, jdbcType);
        } else {
            if (jdbcType == 91) {
                if (value.getClass().getName().equals("java.util.Date")) {
                    value = new Date(((java.util.Date)value).getTime());
                }
            } else if (jdbcType == 92) {
                if (value.getClass().getName().equals("java.util.Date")) {
                    value = new Time(((java.util.Date)value).getTime());
                }
            } else if (jdbcType == 93 && value.getClass().getName().equals("java.util.Date")) {
                value = new Timestamp(((java.util.Date)value).getTime());
            }
            if (this.isBinaryType(jdbcType)) {
                byte[] bytes = null;
                if (value instanceof byte[]) {
                    bytes = (byte[])value;
                } else {
                    if (value instanceof EJBObject) {
                        try {
                            value = ((EJBObject)value).getHandle();
                        }
                        catch (RemoteException e) {
                            throw new SQLException("Cannot get Handle of EJBObject: " + e);
                        }
                    }
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        oos.writeObject(new MarshalledObject<Object>(value));
                        bytes = baos.toByteArray();
                        oos.close();
                    }
                    catch (IOException e) {
                        throw new SQLException("Can't serialize binary object: " + e);
                    }
                }
                if (bytes.length < 2000) {
                    stmt.setBytes(idx, bytes);
                } else {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                        stmt.setBinaryStream(idx, (InputStream)bais, bytes.length);
                        bais.close();
                    }
                    catch (IOException e) {
                        throw new SQLException("Couldn't write binary object to DB: " + e);
                    }
                }
            } else {
                stmt.setObject(idx, value, jdbcType);
            }
        }
    }

    protected void setParameters(PreparedStatement stmt, Object argOrArgs) throws Exception {
    }

    protected int setPrimaryKeyParameters(PreparedStatement stmt, int parameterIndex, Object id) throws IllegalAccessException, SQLException {
        Iterator it = this.jawsEntity.getPkFields();
        if (this.jawsEntity.hasCompositeKey()) {
            while (it.hasNext()) {
                PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
                int jdbcType = pkFieldMetaData.getJDBCType();
                Object value = this.getPkFieldValue(id, pkFieldMetaData);
                this.setParameter(stmt, parameterIndex++, jdbcType, value);
            }
        } else {
            PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
            int jdbcType = pkFieldMetaData.getJDBCType();
            this.setParameter(stmt, parameterIndex++, jdbcType, id);
        }
        return parameterIndex;
    }

    protected void setSQL(String sql) {
        if (debug) {
            this.log.debug(String.valueOf(this.name) + " SQL: " + sql);
        }
        this.sql = sql;
    }

    private final void setUpJDBCTypeNames() {
        jdbcTypeNames = new HashMap();
        Field[] fields = (class$java$sql$Types != null ? class$java$sql$Types : (class$java$sql$Types = JDBCCommand.class$("java.sql.Types"))).getFields();
        int length = fields.length;
        int i = 0;
        while (i < length) {
            Field f = fields[i];
            String fieldName = f.getName();
            try {
                Object fieldValue = f.get(null);
                jdbcTypeNames.put(fieldValue, fieldName);
            }
            catch (IllegalAccessException e) {
                this.log.error("Unexected error", e);
            }
            ++i;
        }
    }

    class WorkaroundInputStream
    extends ObjectInputStream {
        public WorkaroundInputStream(InputStream source) throws IOException, StreamCorruptedException {
            super(source);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(v.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                return super.resolveClass(v);
            }
        }
    }
}

