/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFinderCommand;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;
import org.jboss.ejb.plugins.jaws.metadata.TypeMappingMetaData;

public class JDBCDefinedFinderCommand
extends JDBCFinderCommand {
    private int[] parameterArray;
    private TypeMappingMetaData typeMapping = this.jawsEntity.getJawsApplication().getTypeMapping();
    private String fromClause = "";
    private String whereClause = "";
    private String orderClause = "";

    public JDBCDefinedFinderCommand(JDBCCommandFactory factory, FinderMetaData f) {
        super(factory, f);
        String query = "";
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (f.getQuery() != null) {
            StringTokenizer finderQuery = new StringTokenizer(f.getQuery(), "{}", true);
            while (finderQuery.hasMoreTokens()) {
                String t = finderQuery.nextToken();
                if (t.equals("{")) {
                    query = String.valueOf(query) + "?";
                    String idx = finderQuery.nextToken();
                    parameters.add(new Integer(idx));
                    finderQuery.nextToken();
                    continue;
                }
                query = String.valueOf(query) + t;
            }
        }
        this.parameterArray = new int[parameters.size()];
        int i = 0;
        while (i < this.parameterArray.length) {
            this.parameterArray[i] = (Integer)parameters.get(i);
            ++i;
        }
        String extraOrderColumns = this.getExtraOrderColumns(f);
        String lcQuery = query.toLowerCase();
        if (lcQuery.startsWith(",") || lcQuery.startsWith("inner join")) {
            String tableList = null;
            int whereStart = lcQuery.indexOf("where");
            if (whereStart == -1) {
                this.log.debug("Strange query for finder " + f.getName() + ". Includes join, but no 'where' clause. Is this a findAll?");
                tableList = query;
                this.whereClause = "";
            } else {
                tableList = query.substring(0, whereStart);
                this.whereClause = query.substring(whereStart);
            }
            this.fromClause = "FROM " + this.jawsEntity.getTableName() + tableList;
        } else {
            this.fromClause = "FROM " + this.jawsEntity.getTableName();
            this.whereClause = lcQuery.startsWith("where") ? query : (query.trim().length() != 0 ? "where " + query : "");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        String tableName = this.jawsEntity.getTableName();
        StringTokenizer stok = new StringTokenizer(this.getPkColumnList(), ",");
        while (stok.hasMoreTokens()) {
            sqlBuffer.append(tableName);
            sqlBuffer.append(".");
            sqlBuffer.append(stok.nextElement().toString());
            sqlBuffer.append(",");
        }
        sqlBuffer.setLength(sqlBuffer.length() - 1);
        sqlBuffer.append(extraOrderColumns);
        sqlBuffer.append(' ');
        sqlBuffer.append(this.fromClause);
        sqlBuffer.append(' ');
        sqlBuffer.append(this.whereClause);
        if (f.getOrder() != null && !f.getOrder().equals("")) {
            this.orderClause = " ORDER BY " + f.getOrder();
            sqlBuffer.append(this.orderClause);
        }
        this.setSQL(sqlBuffer.toString());
    }

    protected String[] cleanOrderClause(String rawOrder) {
        StringTokenizer orderTokens = new StringTokenizer(rawOrder, ",");
        String[] checkedOrderTokens = new String[orderTokens.countTokens()];
        int ix = 0;
        while (orderTokens.hasMoreTokens()) {
            String orderToken = orderTokens.nextToken().trim();
            int i = orderToken.toUpperCase().indexOf(" ASC");
            checkedOrderTokens[ix] = i != -1 ? orderToken.substring(0, i).trim() : ((i = orderToken.toUpperCase().indexOf(" DESC")) != -1 ? orderToken.substring(0, i).trim() : new String(orderToken).trim());
            ++ix;
        }
        return checkedOrderTokens;
    }

    private String getExtraOrderColumns(FinderMetaData f) {
        String strippedOrder = "";
        if (f.getOrder() != null && f.getOrder() != "") {
            String[] checkedOrderTokens = this.cleanOrderClause(f.getOrder());
            StringTokenizer pkTokens = new StringTokenizer(this.getPkColumnList(), ",");
            HashSet<String> setOfPkTokens = new HashSet<String>(pkTokens.countTokens());
            while (pkTokens.hasMoreTokens()) {
                setOfPkTokens.add(pkTokens.nextToken().trim().toLowerCase());
            }
            int i = 0;
            while (i < checkedOrderTokens.length) {
                if (setOfPkTokens.contains(checkedOrderTokens[i].toLowerCase())) {
                    checkedOrderTokens[i] = null;
                }
                ++i;
            }
            StringBuffer orderTokensToUse = new StringBuffer("");
            i = 0;
            while (i < checkedOrderTokens.length) {
                if (checkedOrderTokens[i] != null) {
                    orderTokensToUse.append(", ");
                    orderTokensToUse.append(checkedOrderTokens[i]);
                }
                ++i;
            }
            strippedOrder = orderTokensToUse.toString();
        }
        return strippedOrder;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public String getOrderByClause() {
        return this.orderClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    protected void setParameters(PreparedStatement stmt, Object argOrArgs) throws Exception {
        Object[] args = (Object[])argOrArgs;
        int i = 0;
        while (i < this.parameterArray.length) {
            Object arg = args[this.parameterArray[i]];
            int jdbcType = arg != null ? this.typeMapping.getJdbcTypeForJavaType(arg.getClass()) : 0;
            this.setParameter(stmt, i + 1, jdbcType, arg);
            ++i;
        }
    }
}

