/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.FinderException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.jaws.JPMFindEntitiesCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCQueryCommand;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;
import org.jboss.ejb.plugins.jaws.metadata.PkFieldMetaData;
import org.jboss.util.FinderResults;

public abstract class JDBCFinderCommand
extends JDBCQueryCommand
implements JPMFindEntitiesCommand {
    protected FinderMetaData finderMetaData = null;

    public JDBCFinderCommand(JDBCCommandFactory factory, FinderMetaData f) {
        super(factory, f.getName());
        this.finderMetaData = f;
    }

    public FinderResults execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx) throws RemoteException, FinderException {
        FinderResults result = null;
        try {
            Collection keys = (Collection)this.jdbcExecute(args);
            String sql = this.getSQL(args);
            sql.toUpperCase();
            int pos = sql.indexOf("WHERE");
            String where = "";
            if (pos != -1) {
                where = sql.substring(pos);
            }
            result = this.finderMetaData.hasReadAhead() ? new FinderResults(keys, where, this, args) : new FinderResults(keys, null, null, null);
        }
        catch (Exception e) {
            this.log.debug(e);
            throw new FinderException("Find failed, msg=" + e.toString());
        }
        return result;
    }

    public FinderMetaData getFinderMetaData() {
        return this.finderMetaData;
    }

    public abstract String getFromClause();

    public abstract String getOrderByClause();

    public abstract String getWhereClause();

    protected Object handleResult(ResultSet rs, Object argOrArgs) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.jawsEntity.hasCompositeKey()) {
            try {
                while (rs.next()) {
                    Object pk = this.jawsEntity.getPrimaryKeyClass().newInstance();
                    int i = 1;
                    Iterator it = this.jawsEntity.getPkFields();
                    while (it.hasNext()) {
                        PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
                        Field pkField = pkFieldMetaData.getPkField();
                        pkField.set(pk, this.getResultObject(rs, i++, pkField.getType()));
                    }
                    result.add(pk);
                }
            }
            catch (Exception e) {
                throw new ServerException("Finder failed", e);
            }
        } else {
            Iterator it = this.jawsEntity.getPkFields();
            PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
            while (rs.next()) {
                result.add(this.getResultObject(rs, 1, pkFieldMetaData.getCMPField().getType()));
            }
        }
        return result;
    }
}

