/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.jboss.ejb.plugins.jaws.JPMInitCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCUpdateCommand;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;
import org.jboss.ejb.plugins.jaws.metadata.PkFieldMetaData;

public class JDBCInitCommand
extends JDBCUpdateCommand
implements JPMInitCommand {
    public JDBCInitCommand(JDBCCommandFactory factory) {
        super(factory, "Init");
        String sql = "CREATE TABLE " + this.jawsEntity.getTableName() + " (";
        Iterator it = this.jawsEntity.getCMPFields();
        boolean first = true;
        while (it.hasNext()) {
            CMPFieldMetaData cmpField = (CMPFieldMetaData)it.next();
            sql = String.valueOf(sql) + (first ? "" : ",") + cmpField.getColumnName() + " " + cmpField.getSQLType();
            first = false;
        }
        if (this.jawsEntity.hasPkConstraint()) {
            sql = String.valueOf(sql) + ",CONSTRAINT pk" + this.jawsEntity.getTableName() + " PRIMARY KEY (";
            Iterator i = this.jawsEntity.getPkFields();
            while (i.hasNext()) {
                String keyCol = ((PkFieldMetaData)i.next()).getColumnName();
                sql = String.valueOf(sql) + keyCol;
                sql = String.valueOf(sql) + (i.hasNext() ? "," : "");
            }
            sql = String.valueOf(sql) + ")";
        }
        sql = String.valueOf(sql) + ")";
        this.setSQL(sql);
    }

    public void execute() throws Exception {
        block24: {
            Connection con;
            boolean created;
            block23: {
                if (!this.jawsEntity.getCreateTable()) break block24;
                created = false;
                con = null;
                ResultSet rs = null;
                try {
                    con = this.getConnection();
                    DatabaseMetaData dmd = con.getMetaData();
                    rs = dmd.getTables(con.getCatalog(), null, this.jawsEntity.getTableName(), null);
                    if (rs.next()) {
                        created = true;
                    }
                    rs.close();
                    con.close();
                    Object var5_6 = null;
                    if (rs == null) break block23;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                            rs = null;
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (con != null) {
                        try {
                            con.close();
                            con = null;
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                    con = null;
                }
                catch (SQLException sQLException) {}
            }
            if (created) {
                this.log.info("Table '" + this.jawsEntity.getTableName() + "' already exists");
            } else {
                try {
                    String pkStr;
                    this.factory.getContainer().getTransactionManager().begin();
                    this.jdbcExecute(null);
                    this.factory.getContainer().getTransactionManager().commit();
                    this.log.info("Created table '" + this.jawsEntity.getTableName() + "' successfully.");
                    if (this.jawsEntity.getPrimKeyField() != null) {
                        pkStr = "'" + this.jawsEntity.getPrimKeyField() + "'";
                    } else {
                        pkStr = "[";
                        Iterator i = this.jawsEntity.getPkFields();
                        while (i.hasNext()) {
                            String keyCol = ((PkFieldMetaData)i.next()).getColumnName();
                            pkStr = String.valueOf(pkStr) + keyCol;
                            pkStr = String.valueOf(pkStr) + (i.hasNext() ? "," : "]");
                        }
                    }
                    this.log.debug("Primary key of table '" + this.jawsEntity.getTableName() + "' is " + pkStr);
                }
                catch (Exception e) {
                    this.log.error("Could not create table " + this.jawsEntity.getTableName() + ": " + e.getMessage());
                    try {
                        this.factory.getContainer().getTransactionManager().rollback();
                    }
                    catch (Exception _e) {
                        this.log.error("Could not roll back transaction: " + _e.getMessage());
                    }
                }
            }
        }
    }

    protected Object handleResult(int rowsAffected, Object argOrArgs) throws Exception {
        this.log.debug("Table " + this.jawsEntity.getTableName() + " created");
        return null;
    }
}

