/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.jboss.ejb.plugins.jaws.JPMLoadEntitiesCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFinderCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCLoadEntityCommand;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;
import org.jboss.ejb.plugins.jaws.metadata.PkFieldMetaData;
import org.jboss.util.FinderResults;

public class JDBCLoadEntitiesCommand
extends JDBCLoadEntityCommand
implements JPMLoadEntitiesCommand {
    String selectClause = super.createSelectClause();

    public JDBCLoadEntitiesCommand(JDBCCommandFactory factory) {
        super(factory);
    }

    protected Object createKey(ResultSet rs) throws Exception {
        if (this.jawsEntity.hasCompositeKey()) {
            try {
                Object pk = this.jawsEntity.getPrimaryKeyClass().newInstance();
                int i = 1;
                Iterator it = this.jawsEntity.getPkFields();
                while (it.hasNext()) {
                    PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
                    Field pkField = pkFieldMetaData.getPkField();
                    String colName = pkFieldMetaData.getColumnName();
                    pkField.set(pk, this.getResultObject(rs, i++, pkField.getType()));
                }
                return pk;
            }
            catch (Exception exception) {
                return null;
            }
        }
        Iterator it = this.jawsEntity.getPkFields();
        PkFieldMetaData pkFieldMetaData = (PkFieldMetaData)it.next();
        return this.getResultObject(rs, 1, pkFieldMetaData.getCMPField().getType());
    }

    public void execute(FinderResults keys) throws RemoteException {
        JDBCFinderCommand finder = (JDBCFinderCommand)keys.getFinder();
        FinderMetaData metaData = null;
        if (finder != null) {
            metaData = finder.getFinderMetaData();
        }
        if (metaData != null && metaData.hasReadAhead() && keys.getQueryData() != null) {
            try {
                Object[] args = new Object[]{keys};
                this.jdbcExecute(args);
            }
            catch (Exception e) {
                throw new ServerException("Load failed", e);
            }
        }
    }

    protected String getSQL(Object argOrArgs) throws Exception {
        FinderResults keys = (FinderResults)((Object[])argOrArgs)[0];
        JDBCFinderCommand finder = (JDBCFinderCommand)keys.getFinder();
        String sql = String.valueOf(this.selectClause) + " " + finder.getFromClause() + " " + finder.getWhereClause() + " " + finder.getOrderByClause();
        if (this.jawsEntity.hasSelectForUpdate()) {
            sql = String.valueOf(sql) + " FOR UPDATE";
        }
        return sql;
    }

    protected Object handleResult(ResultSet rs, Object argOrArgs) throws Exception {
        FinderResults keys = (FinderResults)((Object[])argOrArgs)[0];
        while (rs.next()) {
            Object key = this.createKey(rs);
            this.preloadOneEntity(rs, key);
        }
        return null;
    }

    protected void preloadOneEntity(ResultSet rs, Object key) {
        int idx = 1;
        Iterator keyIt = this.jawsEntity.getPkFields();
        while (keyIt.hasNext()) {
            keyIt.next();
            ++idx;
        }
        int fieldCount = 0;
        Object[] allValues = new Object[this.jawsEntity.getNumberOfCMPFields()];
        Iterator iter = this.jawsEntity.getCMPFields();
        try {
            while (iter.hasNext()) {
                Object value;
                CMPFieldMetaData cmpField = (CMPFieldMetaData)iter.next();
                allValues[fieldCount] = value = this.getResultObject(rs, this.cmpFieldPositionInSelect[fieldCount], cmpField);
                ++fieldCount;
            }
            this.factory.addPreloadData(key, allValues);
        }
        catch (SQLException sQLException) {
            this.log.warn("SQL Error preloading data for key " + key);
        }
    }

    protected void setParameters(PreparedStatement stmt, Object argOrArgs) throws Exception {
        FinderResults keys = (FinderResults)((Object[])argOrArgs)[0];
        JDBCFinderCommand finder = (JDBCFinderCommand)keys.getFinder();
        Object[] args = keys.getQueryArgs();
        finder.setParameters(stmt, args);
    }
}

