/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.jaws.metadata.JawsEntityMetaData;
import org.jboss.ejb.plugins.jaws.metadata.MappingMetaData;
import org.jboss.ejb.plugins.jaws.metadata.ValueObjectHelper;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class CMPFieldMetaData
extends MetaData
implements XmlLoadable {
    static Logger log = Logger.getLogger(class$org$jboss$ejb$plugins$jaws$metadata$CMPFieldMetaData != null ? class$org$jboss$ejb$plugins$jaws$metadata$CMPFieldMetaData : (class$org$jboss$ejb$plugins$jaws$metadata$CMPFieldMetaData = CMPFieldMetaData.class$("org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData")));
    private JawsEntityMetaData jawsEntity;
    private String name;
    private Field field;
    private int jdbcType;
    private boolean validJdbcType;
    private String sqlType;
    private String columnName;
    private boolean isAPrimaryKeyField;
    private String ejbClassName;
    private Class ejbClass;
    private boolean isNested;
    static /* synthetic */ Class class$org$jboss$ejb$plugins$jaws$metadata$CMPFieldMetaData;

    public CMPFieldMetaData(String name, JawsEntityMetaData jawsEntity) throws DeploymentException {
        this.name = name;
        this.jawsEntity = jawsEntity;
        this.ejbClassName = jawsEntity.getEntity().getEjbClass();
        this.ejbClassName = jawsEntity.getEntity().getEjbClass();
        try {
            this.ejbClass = jawsEntity.getJawsApplication().getClassLoader().loadClass(this.ejbClassName);
            this.field = this.ejbClass.getField(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException("ejb class not found: " + this.ejbClassName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.checkField();
        }
        this.columnName = CMPFieldMetaData.getLastComponent(name);
    }

    private void checkField() throws DeploymentException {
        try {
            this.field = this.verifyNestedField();
        }
        catch (DeploymentException deploymentException) {
            this.debugClass(this.ejbClass);
            this.field = this.verifyNestedField();
            log.warn("!!! using buggy hotspot, try to upgrade ... !!!");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void debugClass(Class debugClass) {
        Field[] fields = debugClass.getFields();
        int i = 0;
        while (i < fields.length) {
            ++i;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Field getField() {
        return this.field;
    }

    public Class getFieldType() {
        if (this.field != null) {
            return this.field.getType();
        }
        Field tmpField = null;
        Class<?> tmpClass = this.ejbClass;
        String fieldName = null;
        StringTokenizer st = new StringTokenizer(this.name, ".");
        while (st.hasMoreTokens()) {
            fieldName = st.nextToken();
            try {
                tmpField = tmpClass.getField(fieldName);
                tmpClass = tmpField.getType();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    return ValueObjectHelper.getNestedFieldType(this.ejbClass, this.name);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.warn("Nested field " + fieldName + " does not have a get method on " + this.ejbClass.getName());
                    return null;
                }
            }
        }
        return tmpField.getType();
    }

    public static String getFirstComponent(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        String fieldName = st.hasMoreTokens() ? st.nextToken() : null;
        return fieldName;
    }

    public int getJDBCType() {
        if (!this.validJdbcType) {
            if (this.field != null) {
                this.jdbcType = this.jawsEntity.getJawsApplication().getTypeMapping().getJdbcTypeForJavaType(this.field.getType());
            } else {
                try {
                    this.jdbcType = this.jawsEntity.getJawsApplication().getTypeMapping().getJdbcTypeForJavaType(ValueObjectHelper.getNestedFieldType(this.ejbClass, this.name));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.warn("Nested Field " + this.name + " does not have a get method on " + this.ejbClassName);
                }
            }
            this.validJdbcType = true;
        }
        return this.jdbcType;
    }

    public JawsEntityMetaData getJawsEntity() {
        return this.jawsEntity;
    }

    public static String getLastComponent(String name) {
        String fieldName = name;
        StringTokenizer st = new StringTokenizer(name, ".");
        while (st.hasMoreTokens()) {
            fieldName = st.nextToken();
        }
        return fieldName;
    }

    public String getName() {
        return this.name;
    }

    public String getSQLType() {
        block4: {
            if (this.sqlType != null) break block4;
            if (this.field != null) {
                this.sqlType = this.jawsEntity.getJawsApplication().getTypeMapping().getSqlTypeForJavaType(this.field.getType());
            } else {
                try {
                    this.sqlType = this.jawsEntity.getJawsApplication().getTypeMapping().getSqlTypeForJavaType(ValueObjectHelper.getNestedFieldType(this.ejbClass, this.name));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.warn("Nested Field " + this.name + " does not have a get method on " + this.ejbClassName);
                }
            }
        }
        return this.sqlType;
    }

    public Object getValue(Object instance) {
        Object currentObject = instance;
        try {
            if (!this.isNested()) {
                return this.getField().get(instance);
            }
            StringTokenizer st = new StringTokenizer(this.name, ".");
            while (st.hasMoreTokens()) {
                Field currentField;
                String fieldName = st.nextToken();
                if (currentObject == null) {
                    return null;
                }
                try {
                    currentField = currentObject.getClass().getField(fieldName);
                    currentObject = currentField.get(currentObject);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    currentField = null;
                    currentObject = ValueObjectHelper.getValue(currentObject, fieldName);
                }
            }
            return currentObject;
        }
        catch (IllegalAccessException e) {
            log.warn("!!! CMPFieldMetaData.getValue() ERROR !!! " + e);
        }
        catch (InvocationTargetException e) {
            log.warn("!!! CMPFieldMetaData.getValue() ERROR !!! " + e);
        }
        catch (NoSuchMethodException e) {
            log.warn("!!! CMPFieldMetaData.getValue() ERROR !!! " + e);
        }
        return null;
    }

    public void importXml(Element element) throws DeploymentException {
        String jdbcStr;
        String columnStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "column-name"));
        if (columnStr != null) {
            this.columnName = columnStr;
        }
        if ((jdbcStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "jdbc-type"))) != null) {
            this.jdbcType = MappingMetaData.getJdbcTypeFromName(jdbcStr);
            this.validJdbcType = true;
            this.sqlType = MetaData.getElementContent(MetaData.getUniqueChild(element, "sql-type"));
        }
    }

    public boolean isAPrimaryKeyField() {
        return this.isAPrimaryKeyField;
    }

    public boolean isEJBReference() {
        return this.jdbcType == 2006;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public void set(Object instance, Object value) {
        Field tmpField = null;
        String fieldName = null;
        Object currentObject = instance;
        StringTokenizer st = new StringTokenizer(this.name, ".");
        int i = 1;
        int tot = st.countTokens();
        while (st.hasMoreTokens() && i < tot) {
            ++i;
            fieldName = st.nextToken();
            Object oldObject = currentObject;
            try {
                tmpField = currentObject.getClass().getField(fieldName);
                currentObject = tmpField.get(currentObject);
                if (currentObject != null) continue;
                currentObject = tmpField.getType().newInstance();
                tmpField.set(oldObject, currentObject);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    currentObject = ValueObjectHelper.getValue(currentObject, fieldName);
                    if (currentObject != null) continue;
                    currentObject = ValueObjectHelper.getNestedFieldType(oldObject.getClass(), fieldName).newInstance();
                    ValueObjectHelper.setValue(oldObject, fieldName, currentObject);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    log.warn("set method not found for " + fieldName + " on " + oldObject.getClass().getName());
                }
                catch (InvocationTargetException invocationTargetException) {
                    log.warn("set method not invocable " + fieldName + " on " + currentObject.getClass().getName());
                }
                catch (IllegalAccessException e) {
                    log.warn("!!! Deployment Failure !!!" + e);
                }
                catch (InstantiationException instantiationException) {
                    log.warn("could not instantiate " + tmpField);
                }
            }
            catch (IllegalAccessException e) {
                log.warn("!!! Deployment Failure !!!" + e);
            }
            catch (InstantiationException instantiationException) {
                log.warn("could not instantiate " + tmpField);
            }
            catch (Exception e) {
                log.warn("Exception " + e);
            }
        }
        try {
            try {
                Field dataField = currentObject.getClass().getField(CMPFieldMetaData.getLastComponent(this.name));
                dataField.set(currentObject, value);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                ValueObjectHelper.setValue(currentObject, CMPFieldMetaData.getLastComponent(this.name), value);
            }
        }
        catch (IllegalAccessException e) {
            log.warn("!!! Deployment Failure !!!" + e);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.warn("set method not invocable " + CMPFieldMetaData.getLastComponent(this.name) + " on " + currentObject.getClass().getName());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.warn("set method not found for " + CMPFieldMetaData.getLastComponent(this.name) + " on " + currentObject.getClass().getName());
        }
    }

    void setPrimary() {
        this.isAPrimaryKeyField = true;
    }

    private Field verifyNestedField() throws DeploymentException {
        String fieldName = null;
        Field tmpField = null;
        Class<?> tmpClass = this.ejbClass;
        StringTokenizer st = new StringTokenizer(this.name, ".");
        if (st.countTokens() > 1) {
            this.isNested = true;
        }
        while (st.hasMoreTokens()) {
            fieldName = st.nextToken();
            try {
                tmpField = tmpClass.getField(fieldName);
                tmpClass = tmpField.getType();
                log.debug("(Dependant Object) " + tmpField.getName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.field = null;
                return null;
            }
        }
        return tmpField;
    }
}

