/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.jaws.metadata.JawsEntityMetaData;
import org.jboss.ejb.plugins.jaws.metadata.TypeMappingMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class JawsApplicationMetaData
extends MetaData
implements XmlLoadable {
    public static final String JPM = "org.jboss.ejb.plugins.jaws.JAWSPersistenceManager";
    static Logger log = Logger.getLogger(class$org$jboss$ejb$plugins$jaws$metadata$JawsApplicationMetaData != null ? class$org$jboss$ejb$plugins$jaws$metadata$JawsApplicationMetaData : (class$org$jboss$ejb$plugins$jaws$metadata$JawsApplicationMetaData = JawsApplicationMetaData.class$("org.jboss.ejb.plugins.jaws.metadata.JawsApplicationMetaData")));
    private ClassLoader classLoader;
    private ApplicationMetaData applicationMetaData;
    private Hashtable entities = new Hashtable();
    private String dbURL;
    private DataSource dataSource;
    private boolean debug = false;
    private Hashtable typeMappings = new Hashtable();
    private TypeMappingMetaData typeMapping;
    static /* synthetic */ Class class$org$jboss$ejb$plugins$jaws$metadata$JawsApplicationMetaData;

    public JawsApplicationMetaData(ApplicationMetaData amd, ClassLoader cl) throws DeploymentException {
        this.classLoader = cl;
        this.applicationMetaData = amd;
        Iterator beans = this.applicationMetaData.getEnterpriseBeans();
        while (beans.hasNext()) {
            EntityMetaData entity;
            BeanMetaData bean = (BeanMetaData)beans.next();
            if (!bean.isEntity() || !(entity = (EntityMetaData)bean).isCMP() || !entity.getContainerConfiguration().getPersistenceManager().equals(JPM)) continue;
            JawsEntityMetaData jawsEntity = new JawsEntityMetaData(this, entity);
            this.entities.put(entity.getEjbName(), jawsEntity);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public JawsEntityMetaData getBeanByEjbName(String name) {
        return (JawsEntityMetaData)this.entities.get(name);
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception exception) {
            try {
                this.init();
                return this.dataSource.getConnection();
            }
            catch (Exception ee) {
                log.warn("Connection init failed", ee);
                throw new SQLException("Connection unavailable: " + ee);
            }
        }
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public TypeMappingMetaData getTypeMapping() {
        return this.typeMapping;
    }

    public void importXml(Element element) throws DeploymentException {
        Element enterpriseBeans;
        Element defaultEntity;
        Element debugElement;
        String typeMappingString;
        Element db;
        Iterator iterator;
        Element typeMaps = MetaData.getOptionalChild(element, "type-mappings");
        if (typeMaps != null) {
            iterator = MetaData.getChildrenByTagName(typeMaps, "type-mapping");
            while (iterator.hasNext()) {
                Element typeMappingElement = (Element)iterator.next();
                TypeMappingMetaData typeMapping = new TypeMappingMetaData();
                try {
                    typeMapping.importXml(typeMappingElement);
                }
                catch (DeploymentException e) {
                    throw new DeploymentException("Error in jaws.xml for type-mapping " + typeMapping.getName() + ": " + e.getMessage());
                }
                this.typeMappings.put(typeMapping.getName(), typeMapping);
            }
        }
        if ((db = MetaData.getOptionalChild(element, "datasource")) != null) {
            this.dbURL = MetaData.getElementContent(db);
        }
        if (!this.dbURL.startsWith("java:/")) {
            this.dbURL = "java:/" + this.dbURL;
        }
        if ((typeMappingString = MetaData.getElementContent(MetaData.getOptionalChild(element, "type-mapping"))) != null) {
            this.typeMapping = (TypeMappingMetaData)this.typeMappings.get(typeMappingString);
            if (this.typeMapping == null) {
                throw new DeploymentException("Error in jaws.xml : type-mapping " + typeMappingString + " not found");
            }
        }
        if ((debugElement = MetaData.getOptionalChild(element, "debug")) != null) {
            String stringDebug = MetaData.getElementContent(debugElement);
            this.debug = Boolean.valueOf(stringDebug);
        }
        if ((defaultEntity = MetaData.getOptionalChild(element, "default-entity")) != null) {
            iterator = this.entities.values().iterator();
            while (iterator.hasNext()) {
                ((JawsEntityMetaData)iterator.next()).importXml(defaultEntity);
            }
        }
        if ((enterpriseBeans = MetaData.getOptionalChild(element, "enterprise-beans")) != null) {
            String ejbName = null;
            try {
                iterator = MetaData.getChildrenByTagName(enterpriseBeans, "entity");
                while (iterator.hasNext()) {
                    Element bean = (Element)iterator.next();
                    ejbName = MetaData.getElementContent(MetaData.getUniqueChild(bean, "ejb-name"));
                    JawsEntityMetaData entity = (JawsEntityMetaData)this.entities.get(ejbName);
                    if (entity != null) {
                        entity.importXml(bean);
                        continue;
                    }
                    log.warn("Warning: data found in jaws.xml for entity " + ejbName + " but bean is not a jaws-managed cmp entity in ejb-jar.xml");
                }
            }
            catch (DeploymentException e) {
                throw new DeploymentException("Error in jaws.xml for Entity " + ejbName + ": " + e.getMessage());
            }
        }
    }

    public void init() throws DeploymentException {
        if (!this.dbURL.startsWith("jdbc:")) {
            try {
                this.dataSource = (DataSource)new InitialContext().lookup(this.dbURL);
            }
            catch (NamingException e) {
                throw new DeploymentException("Error during lookup of dbURL=" + this.dbURL, e);
            }
        }
    }
}

