/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.metadata;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;
import org.jboss.ejb.plugins.jaws.metadata.JawsApplicationMetaData;
import org.jboss.ejb.plugins.jaws.metadata.PkFieldMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class JawsEntityMetaData
extends MetaData
implements XmlLoadable {
    private JawsApplicationMetaData jawsApplication;
    private EntityMetaData entity;
    private String ejbName = null;
    private String tableName = null;
    private boolean createTable;
    private boolean removeTable;
    private boolean tunedUpdates;
    private boolean selectForUpdate;
    private boolean readOnly;
    private int timeOut;
    private boolean pkConstraint;
    private boolean compositeKey;
    private Class primaryKeyClass;
    private Hashtable cmpFields = new Hashtable();
    private ArrayList pkFields = new ArrayList();
    private ArrayList finders = new ArrayList();
    private DataSource dataSource = null;
    private String dataSourceName = null;
    private HashMap detailedFieldDescriptions = new HashMap();
    private static final Boolean detailedBoolean = new Boolean(true);

    public JawsEntityMetaData(JawsApplicationMetaData app, EntityMetaData ent) throws DeploymentException {
        CMPFieldMetaData cmpField;
        this.jawsApplication = app;
        this.entity = ent;
        this.ejbName = this.entity.getEjbName();
        this.compositeKey = this.entity.getPrimKeyField() == null;
        try {
            this.primaryKeyClass = this.jawsApplication.getClassLoader().loadClass(this.entity.getPrimaryKeyClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException("could not load primary key class: " + this.entity.getPrimaryKeyClass());
        }
        this.tableName = this.ejbName.replace('.', '_');
        Iterator cmpFieldNames = this.entity.getCMPFields();
        while (cmpFieldNames.hasNext()) {
            String cmpFieldName = (String)cmpFieldNames.next();
            cmpField = new CMPFieldMetaData(cmpFieldName, this);
            this.cmpFields.put(cmpFieldName, cmpField);
        }
        if (this.compositeKey) {
            Field[] pkClassFields = this.primaryKeyClass.getFields();
            int i = 0;
            while (i < pkClassFields.length) {
                Field pkField = pkClassFields[i];
                CMPFieldMetaData cmpField2 = (CMPFieldMetaData)this.cmpFields.get(pkField.getName());
                if (cmpField2 == null) {
                    throw new DeploymentException("Bean " + this.ejbName + " has PK of type " + this.primaryKeyClass.getName() + ", so it should have a cmp-field named " + pkField.getName());
                }
                this.pkFields.add(new PkFieldMetaData(pkField, cmpField2, this));
                ++i;
            }
        } else {
            String pkFieldName = this.entity.getPrimKeyField();
            cmpField = (CMPFieldMetaData)this.cmpFields.get(pkFieldName);
            this.pkFields.add(new PkFieldMetaData(cmpField, this));
        }
    }

    public CMPFieldMetaData getCMPFieldByName(String name) {
        return (CMPFieldMetaData)this.cmpFields.get(name);
    }

    public Iterator getCMPFields() {
        return this.cmpFields.values().iterator();
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource != null) {
            try {
                return this.dataSource.getConnection();
            }
            catch (Exception exception) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(this.dataSourceName);
                    return this.dataSource.getConnection();
                }
                catch (Exception ee) {
                    throw new SQLException("Connection unavailable: " + ee);
                }
            }
        }
        return this.jawsApplication.getConnection();
    }

    public boolean getCreateTable() {
        return this.createTable;
    }

    public String getDbURL() {
        return this.jawsApplication.getDbURL();
    }

    public Iterator getEjbReferences() {
        return this.entity.getEjbReferences();
    }

    public EntityMetaData getEntity() {
        return this.entity;
    }

    public Iterator getFinders() {
        return ((AbstractList)this.finders).iterator();
    }

    public JawsApplicationMetaData getJawsApplication() {
        return this.jawsApplication;
    }

    public String getName() {
        return this.ejbName;
    }

    public int getNumberOfCMPFields() {
        return this.cmpFields.size();
    }

    public int getNumberOfPkFields() {
        return this.pkFields.size();
    }

    public Iterator getPkFields() {
        return ((AbstractList)this.pkFields).iterator();
    }

    public String getPrimKeyField() {
        return this.entity.getPrimKeyField();
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public int getReadOnlyTimeOut() {
        return this.timeOut;
    }

    public boolean getRemoveTable() {
        return this.removeTable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasCompositeKey() {
        return this.compositeKey;
    }

    public boolean hasPkConstraint() {
        return this.pkConstraint;
    }

    public boolean hasSelectForUpdate() {
        return this.selectForUpdate;
    }

    public boolean hasTunedUpdates() {
        return this.tunedUpdates;
    }

    public void importXml(Element element) throws DeploymentException {
        String pkStr;
        String sForUpStr;
        String roStr;
        String tunedStr;
        String removeStr;
        String createStr;
        String tableStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "table-name"));
        if (tableStr != null) {
            this.tableName = tableStr;
        }
        this.dataSourceName = MetaData.getElementContent(MetaData.getOptionalChild(element, "datasource"));
        if (this.dataSourceName != null) {
            if (!this.dataSourceName.startsWith("java:/")) {
                this.dataSourceName = "java:/" + this.dataSourceName;
            }
            if (!this.dataSourceName.startsWith("jdbc:")) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(this.dataSourceName);
                }
                catch (NamingException e) {
                    throw new DeploymentException(e.getMessage());
                }
            }
        }
        if ((createStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "create-table"))) != null) {
            this.createTable = Boolean.valueOf(createStr);
        }
        if ((removeStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "remove-table"))) != null) {
            this.removeTable = Boolean.valueOf(removeStr);
        }
        if ((tunedStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "tuned-updates"))) != null) {
            this.tunedUpdates = Boolean.valueOf(tunedStr);
        }
        if ((roStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "read-only"))) != null) {
            this.readOnly = Boolean.valueOf(roStr);
        }
        if ((sForUpStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "select-for-update"))) != null) {
            this.selectForUpdate = Boolean.valueOf(sForUpStr);
        }
        this.selectForUpdate = this.selectForUpdate && !this.readOnly;
        String toStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "time-out"));
        if (toStr != null) {
            this.timeOut = Integer.valueOf(toStr);
        }
        if ((pkStr = MetaData.getElementContent(MetaData.getOptionalChild(element, "pk-constraint"))) != null) {
            this.pkConstraint = Boolean.valueOf(pkStr);
        }
        Iterator iterator = MetaData.getChildrenByTagName(element, "cmp-field");
        while (iterator.hasNext()) {
            Element cmpField = (Element)iterator.next();
            String fieldName = MetaData.getElementContent(MetaData.getUniqueChild(cmpField, "field-name"));
            CMPFieldMetaData cmpFieldMetaData = this.getCMPFieldByName(fieldName);
            if (cmpFieldMetaData == null) {
                if (this.isDetailedFieldDescription(fieldName)) {
                    cmpFieldMetaData = new CMPFieldMetaData(fieldName, this);
                    this.cmpFields.put(fieldName, cmpFieldMetaData);
                } else {
                    throw new DeploymentException("cmp-field '" + fieldName + "' found in jaws.xml but not in ejb-jar.xml");
                }
            }
            cmpFieldMetaData.importXml(cmpField);
        }
        iterator = MetaData.getChildrenByTagName(element, "finder");
        while (iterator.hasNext()) {
            Element finder = (Element)iterator.next();
            FinderMetaData finderMetaData = new FinderMetaData();
            finderMetaData.importXml(finder);
            this.finders.add(finderMetaData);
        }
    }

    private boolean isDetailedFieldDescription(String fieldName) {
        String fieldBaseName = CMPFieldMetaData.getFirstComponent(fieldName);
        if (this.detailedFieldDescriptions.containsKey(fieldBaseName)) {
            return true;
        }
        CMPFieldMetaData cmpFieldMetaData = this.getCMPFieldByName(fieldBaseName);
        if (cmpFieldMetaData == null) {
            return false;
        }
        this.detailedFieldDescriptions.put(fieldBaseName, detailedBoolean);
        this.cmpFields.remove(fieldBaseName);
        return true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

