/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.metadata;

import java.util.Hashtable;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.jaws.metadata.MappingMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class TypeMappingMetaData
extends MetaData
implements XmlLoadable {
    public static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    public static final String[] PRIMITIVE_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private String name;
    private Hashtable mappings = new Hashtable();

    public int getJdbcTypeForJavaType(Class type) {
        String javaType = type.getName();
        int i = 0;
        while (i < PRIMITIVES.length) {
            if (javaType.equals(PRIMITIVES[i])) {
                javaType = PRIMITIVE_CLASSES[i];
                break;
            }
            ++i;
        }
        MappingMetaData mapping = (MappingMetaData)this.mappings.get(javaType);
        if (mapping == null) {
            mapping = (MappingMetaData)this.mappings.get("java.lang.Object");
        }
        return mapping.getJdbcType();
    }

    public String getName() {
        return this.name;
    }

    public String getSqlTypeForJavaType(Class type) {
        String javaType = type.getName();
        int i = 0;
        while (i < PRIMITIVES.length) {
            if (javaType.equals(PRIMITIVES[i])) {
                javaType = PRIMITIVE_CLASSES[i];
                break;
            }
            ++i;
        }
        MappingMetaData mapping = (MappingMetaData)this.mappings.get(javaType);
        if (mapping == null) {
            mapping = (MappingMetaData)this.mappings.get("java.lang.Object");
        }
        return mapping.getSqlType();
    }

    public void importXml(Element element) throws DeploymentException {
        this.name = MetaData.getElementContent(MetaData.getUniqueChild(element, "name"));
        Iterator iterator = MetaData.getChildrenByTagName(element, "mapping");
        while (iterator.hasNext()) {
            Element mappingElement = (Element)iterator.next();
            MappingMetaData mapping = new MappingMetaData();
            mapping.importXml(mappingElement);
            this.mappings.put(mapping.getJavaType(), mapping);
        }
    }
}

