/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jms;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class DLQHandler {
    private static Logger log = Logger.getLogger(class$org$jboss$ejb$plugins$jms$DLQHandler != null ? class$org$jboss$ejb$plugins$jms$DLQHandler : (class$org$jboss$ejb$plugins$jms$DLQHandler = DLQHandler.class$("org.jboss.ejb.plugins.jms.DLQHandler")));
    public static final String JBOSS_ORIG_DESTINATION = "JBOSS_ORIG_DESTINATION";
    public static final String JBOSS_ORIG_MESSAGEID = "JBOSS_ORIG_MESSAGEID";
    private static final String FACTORY_JNDI = "java:/ConnectionFactory";
    private String destinationJNDI = "queue/DLQ";
    private int maxResent = 10;
    private long timeToLive = 0L;
    private int deliveryMode = 2;
    private int priority = 4;
    private QueueConnection connection;
    private Queue dlq;
    private Hashtable resentBuffer = new Hashtable();
    static /* synthetic */ Class class$org$jboss$ejb$plugins$jms$DLQHandler;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void deleteFromBuffer(String id) {
        this.resentBuffer.remove(id);
    }

    void destroy() {
        try {
            this.connection.stop();
        }
        catch (Exception exception) {}
    }

    public boolean handleRedeliveredMessage(Message msg) {
        try {
            String id = msg.getJMSMessageID();
            if (id == null) {
                log.debug("Message id is null, can't handle message");
            }
            if (id != null && this.incrementResentCount(id) > this.maxResent) {
                log.info("Message resent to many time, sending it to DLQ. Id: " + id);
                this.sendMessage(msg);
                this.deleteFromBuffer(id);
                return true;
            }
        }
        catch (JMSException ex) {
            log.error("Could not send message to Dead Letter Queue", ex);
            return false;
        }
        return false;
    }

    public void importXml(Element element) throws DeploymentException {
        this.destinationJNDI = MetaData.getElementContent(MetaData.getUniqueChild(element, "DestinationQueue"));
        try {
            String mr = MetaData.getElementContent(MetaData.getUniqueChild(element, "MaxTimesRedelivered"));
            this.maxResent = Integer.parseInt(mr);
            String ttl = MetaData.getElementContent(MetaData.getUniqueChild(element, "TimeToLive"));
            this.timeToLive = Long.parseLong(ttl);
            if (this.timeToLive < 0L) {
                this.timeToLive = 0L;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (DeploymentException deploymentException) {}
    }

    protected int incrementResentCount(String id) {
        BufferEntry entry = null;
        if (!this.resentBuffer.containsKey(id)) {
            log.debug("Making new entry for id " + id);
            entry = new BufferEntry();
            entry.id = id;
            entry.count = 1;
            this.resentBuffer.put(id, entry);
        } else {
            entry = (BufferEntry)this.resentBuffer.get(id);
            ++entry.count;
            log.debug("Incremented old entry for id " + id + " count " + entry.count);
        }
        return entry.count;
    }

    void init() throws Exception {
        InitialContext ctx = new InitialContext();
        QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(FACTORY_JNDI);
        this.connection = factory.createQueueConnection();
        this.dlq = (Queue)ctx.lookup(this.destinationJNDI);
        log.debug("Created Dead Letter Queue connection " + this.dlq);
    }

    protected Message makeWritable(Message msg) throws JMSException {
        Hashtable<String, String> tmp = new Hashtable<String, String>();
        Enumeration en = msg.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            tmp.put(key, msg.getStringProperty(key));
        }
        msg.clearProperties();
        Enumeration keys = tmp.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            msg.setStringProperty(key, (String)tmp.get(key));
        }
        return msg;
    }

    protected void sendMessage(Message msg) throws JMSException {
        QueueSession ses = null;
        QueueSender sender = null;
        try {
            msg = this.makeWritable(msg);
            msg.setStringProperty(JBOSS_ORIG_MESSAGEID, msg.getJMSMessageID());
            msg.setStringProperty(JBOSS_ORIG_DESTINATION, msg.getJMSDestination().toString());
            ses = this.connection.createQueueSession(false, 1);
            sender = ses.createSender(this.dlq);
            log.debug("Resending DLQ message to destination" + this.dlq);
            sender.send(msg, this.deliveryMode, this.priority, this.timeToLive);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                sender.close();
                ses.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object var5_4 = null;
        try {
            sender.close();
            ses.close();
        }
        catch (Exception exception) {}
    }

    void start() throws Exception {
    }

    void stop() {
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("DLQHandler: {");
        buff.append("destinationJNDI=").append(this.destinationJNDI);
        buff.append(";maxResent=").append(this.maxResent);
        buff.append(";timeToLive=").append(this.timeToLive);
        buff.append("}");
        return buff.toString();
    }

    private class BufferEntry {
        int count;
        String id;

        BufferEntry() {
        }
    }
}

