/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.ServerException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb.plugins.jrmp.interfaces.InitialContextHandle;

public abstract class AbstractHandle
implements Serializable {
    private static final long serialVersionUID = -6161932252555944539L;
    protected final String name;
    protected final InitialContextHandle initialContextHandle;

    public AbstractHandle(String name) {
        this(InitialContextHandle.create(), name);
    }

    public AbstractHandle(InitialContextHandle handle, String name) {
        this.initialContextHandle = handle;
        this.name = name;
    }

    protected InitialContext createInitialContext() throws NamingException {
        if (this.initialContextHandle == null) {
            return new InitialContext();
        }
        return this.initialContextHandle.getInitialContext();
    }

    protected EJBObject getEJBObject(String name, Class[] types, Object[] args) throws ServerException {
        try {
            EJBHome home = this.lookupEJBHome();
            Class<?> type = home.getClass();
            Method method = type.getMethod(name, types);
            return (EJBObject)method.invoke((Object)home, args);
        }
        catch (Exception e) {
            throw new ServerException("Could not get EJBObject", e);
        }
    }

    protected EJBHome lookupEJBHome() throws NamingException {
        EJBHome eJBHome;
        InitialContext ctx = this.createInitialContext();
        try {
            eJBHome = (EJBHome)ctx.lookup(this.name);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        return eJBHome;
    }
}

