/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.local;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ejb.CacheKey;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvokerContainer;
import org.jboss.ejb.LocalContainerInvoker;
import org.jboss.ejb.LocalHomeObjectFactory;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.jrmp.interfaces.RemoteMethodInvocation;
import org.jboss.ejb.plugins.local.LocalHomeProxy;
import org.jboss.ejb.plugins.local.LocalProxy;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.security.SecurityAssociation;
import org.jboss.tm.TransactionPropagationContextFactory;

public class BaseLocalContainerInvoker
implements LocalContainerInvoker {
    static Logger log = Logger.getLogger(class$org$jboss$ejb$plugins$local$BaseLocalContainerInvoker != null ? class$org$jboss$ejb$plugins$local$BaseLocalContainerInvoker : (class$org$jboss$ejb$plugins$local$BaseLocalContainerInvoker = BaseLocalContainerInvoker.class$("org.jboss.ejb.plugins.local.BaseLocalContainerInvoker")));
    protected Container container;
    protected String jndiName;
    protected TransactionManager transactionManager;
    protected EJBLocalHome home;
    protected EJBLocalObject statelessObject;
    protected Map beanMethodInvokerMap;
    protected Map homeMethodInvokerMap;
    private static TransactionPropagationContextFactory tpcFactory;
    static /* synthetic */ Class class$org$jboss$ejb$plugins$local$BaseLocalContainerInvoker;
    static /* synthetic */ Class class$org$jboss$ejb$LocalHomeObjectFactory;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        this.container = null;
    }

    Object getCredential() {
        return SecurityAssociation.getCredential();
    }

    public EJBLocalHome getEJBLocalHome() {
        ContainerInvokerContainer cic = (ContainerInvokerContainer)((Object)this.container);
        return (EJBLocalHome)Proxy.newProxyInstance(cic.getLocalHomeClass().getClassLoader(), new Class[]{cic.getLocalHomeClass()}, (InvocationHandler)new HomeProxy());
    }

    public EJBLocalObject getEntityEJBLocalObject(Object id) {
        ContainerInvokerContainer cic = (ContainerInvokerContainer)((Object)this.container);
        return (EJBLocalObject)Proxy.newProxyInstance(cic.getLocalClass().getClassLoader(), new Class[]{cic.getLocalClass()}, (InvocationHandler)new EntityProxy(id));
    }

    public Collection getEntityLocalCollection(Collection ids) {
        ArrayList<EJBLocalObject> list = new ArrayList<EJBLocalObject>(ids.size());
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            list.add(this.getEntityEJBLocalObject(iter.next()));
        }
        return list;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    Principal getPrincipal() {
        return SecurityAssociation.getPrincipal();
    }

    public EJBLocalObject getStatefulSessionEJBLocalObject(Object id) {
        ContainerInvokerContainer cic = (ContainerInvokerContainer)((Object)this.container);
        return (EJBLocalObject)Proxy.newProxyInstance(cic.getLocalClass().getClassLoader(), new Class[]{cic.getLocalClass()}, (InvocationHandler)new StatefulSessionProxy(id));
    }

    public EJBLocalObject getStatelessSessionEJBLocalObject() {
        ContainerInvokerContainer cic = (ContainerInvokerContainer)((Object)this.container);
        return (EJBLocalObject)Proxy.newProxyInstance(cic.getLocalClass().getClassLoader(), new Class[]{cic.getLocalClass()}, (InvocationHandler)new StatelessSessionProxy());
    }

    Transaction getTransaction() throws SystemException {
        return this.transactionManager == null ? null : this.transactionManager.getTransaction();
    }

    public void init() throws Exception {
        int i;
        Method[] methods;
        ContainerInvokerContainer invokerContainer = (ContainerInvokerContainer)((Object)this.container);
        if (invokerContainer.getLocalClass() == null) {
            return;
        }
        InitialContext iniCtx = new InitialContext();
        this.jndiName = this.container.getBeanMetaData().getJndiName();
        this.transactionManager = (TransactionManager)iniCtx.lookup("java:/TransactionManager");
        Class clazz = invokerContainer.getLocalClass();
        if (clazz != null) {
            log.debug("Caching methods for localClass: " + clazz);
            methods = clazz.getMethods();
            this.beanMethodInvokerMap = new HashMap();
            i = 0;
            while (i < methods.length) {
                this.beanMethodInvokerMap.put(new Long(RemoteMethodInvocation.calculateHash(methods[i])), methods[i]);
                ++i;
            }
        }
        if ((clazz = invokerContainer.getLocalHomeClass()) != null) {
            log.debug("Caching methods for localHomeClass: " + clazz);
            methods = clazz.getMethods();
            this.homeMethodInvokerMap = new HashMap();
            i = 0;
            while (i < methods.length) {
                this.homeMethodInvokerMap.put(new Long(RemoteMethodInvocation.calculateHash(methods[i])), methods[i]);
                ++i;
            }
        }
        String jndiName = this.container.getBeanMetaData().getLocalJndiName();
        String beanName = this.container.getBeanMetaData().getEjbName();
        LocalHomeObjectFactory.rebind(jndiName, this.container.getApplication(), this.container);
        StringRefAddr refAddr = new StringRefAddr("nns", jndiName);
        Reference jndiRef = new Reference(this.container.getBeanMetaData().getLocalHome(), refAddr, (class$org$jboss$ejb$LocalHomeObjectFactory != null ? class$org$jboss$ejb$LocalHomeObjectFactory : (class$org$jboss$ejb$LocalHomeObjectFactory = BaseLocalContainerInvoker.class$("org.jboss.ejb.LocalHomeObjectFactory"))).getName(), null);
        Util.rebind((Context)iniCtx, jndiName, (Object)jndiRef);
        log.debug("Bound Local " + beanName + " to " + jndiName);
    }

    public Object invoke(Object id, Method m, Object[] args) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            try {
                Object object = this.container.invoke(new MethodInvocation(id, m, args, this.getTransaction(), this.getPrincipal(), this.getCredential()));
                Object var7_6 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                return object;
            }
            catch (AccessException ae) {
                throw new AccessLocalException(ae.getMessage(), (Exception)ae);
            }
            catch (NoSuchObjectException nsoe) {
                throw new NoSuchObjectLocalException(nsoe.getMessage(), (Exception)nsoe);
            }
            catch (TransactionRequiredException tre) {
                throw new TransactionRequiredLocalException(((RemoteException)((Object)tre)).getMessage());
            }
            catch (TransactionRolledbackException trbe) {
                throw new TransactionRolledbackLocalException(((RemoteException)((Object)trbe)).getMessage(), (Exception)((Object)trbe));
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public Object invokeHome(Method m, Object[] args) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            try {
                Object object = this.container.invokeHome(new MethodInvocation(null, m, args, this.getTransaction(), this.getPrincipal(), this.getCredential()));
                Object var6_5 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                return object;
            }
            catch (AccessException ae) {
                throw new AccessLocalException(ae.getMessage(), (Exception)ae);
            }
            catch (NoSuchObjectException nsoe) {
                throw new NoSuchObjectLocalException(nsoe.getMessage(), (Exception)nsoe);
            }
            catch (TransactionRequiredException tre) {
                throw new TransactionRequiredLocalException(((RemoteException)((Object)tre)).getMessage());
            }
            catch (TransactionRolledbackException trbe) {
                throw new TransactionRolledbackLocalException(((RemoteException)((Object)trbe)).getMessage(), (Exception)((Object)trbe));
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public void setContainer(Container con) {
        this.container = con;
    }

    public void start() throws Exception {
    }

    public void stop() {
        int i;
        Method[] methods;
        ContainerInvokerContainer invokerContainer;
        Class clazz;
        if (this.container == null) {
            return;
        }
        if (this.beanMethodInvokerMap != null) {
            this.beanMethodInvokerMap.clear();
        }
        if (this.homeMethodInvokerMap != null) {
            this.homeMethodInvokerMap.clear();
        }
        if ((clazz = (invokerContainer = (ContainerInvokerContainer)((Object)this.container)).getLocalClass()) != null) {
            methods = clazz.getMethods();
            i = 0;
            while (i < methods.length) {
                RemoteMethodInvocation.clearHash(methods[i]);
                ++i;
            }
        }
        if ((clazz = invokerContainer.getLocalHomeClass()) != null) {
            methods = clazz.getMethods();
            i = 0;
            while (i < methods.length) {
                RemoteMethodInvocation.clearHash(methods[i]);
                ++i;
            }
        }
        log.debug("Cleared method maps");
        Class localHome = ((ContainerInvokerContainer)((Object)this.container)).getLocalHomeClass();
        if (localHome == null) {
            return;
        }
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.container.getBeanMetaData().getLocalJndiName());
        }
        catch (Exception exception) {}
    }

    class HomeProxy
    extends LocalHomeProxy
    implements InvocationHandler {
        HomeProxy() {
        }

        protected Object getId() {
            return BaseLocalContainerInvoker.this.jndiName;
        }

        protected String getJndiName() {
            return BaseLocalContainerInvoker.this.jndiName;
        }

        public final Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object retValue;
            if (args == null) {
                args = LocalProxy.EMPTY_ARGS;
            }
            if ((retValue = super.invoke(proxy, m, args)) != null) {
                return retValue;
            }
            if (m.equals(LocalHomeProxy.REMOVE_BY_PRIMARY_KEY)) {
                CacheKey id = new CacheKey(args[0]);
                return BaseLocalContainerInvoker.this.invoke(id, LocalHomeProxy.REMOVE_OBJECT, LocalProxy.EMPTY_ARGS);
            }
            return BaseLocalContainerInvoker.this.invokeHome(m, args);
        }
    }

    class EntityProxy
    extends LocalProxy
    implements InvocationHandler {
        CacheKey cacheKey;

        EntityProxy(Object id) {
            if (!(id instanceof CacheKey)) {
                id = new CacheKey(id);
            }
            this.cacheKey = (CacheKey)id;
        }

        protected Object getId() {
            return this.cacheKey.getId();
        }

        protected String getJndiName() {
            return BaseLocalContainerInvoker.this.jndiName;
        }

        public final Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object retValue;
            if (args == null) {
                args = LocalProxy.EMPTY_ARGS;
            }
            if ((retValue = super.invoke(proxy, m, args)) != null) {
                return retValue;
            }
            return BaseLocalContainerInvoker.this.invoke(this.cacheKey, m, args);
        }
    }

    class StatefulSessionProxy
    extends LocalProxy
    implements InvocationHandler {
        Object id;

        StatefulSessionProxy(Object id) {
            this.id = id;
        }

        protected Object getId() {
            return this.id;
        }

        protected String getJndiName() {
            return BaseLocalContainerInvoker.this.jndiName;
        }

        public final Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            Object retValue;
            if (args == null) {
                args = LocalProxy.EMPTY_ARGS;
            }
            if ((retValue = super.invoke(proxy, m, args)) != null) {
                return retValue;
            }
            return BaseLocalContainerInvoker.this.invoke(this.id, m, args);
        }
    }

    class StatelessSessionProxy
    extends LocalProxy
    implements InvocationHandler {
        StatelessSessionProxy() {
        }

        protected Object getId() {
            return BaseLocalContainerInvoker.this.jndiName;
        }

        protected String getJndiName() {
            return BaseLocalContainerInvoker.this.jndiName;
        }

        public final Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (args == null) {
                args = LocalProxy.EMPTY_ARGS;
            }
            if (m.equals(LocalProxy.TO_STRING)) {
                return String.valueOf(BaseLocalContainerInvoker.this.jndiName) + ":Stateless";
            }
            if (m.equals(LocalProxy.EQUALS)) {
                return this.invoke(proxy, LocalProxy.IS_IDENTICAL, args);
            }
            if (m.equals(LocalProxy.HASH_CODE)) {
                return new Integer(this.hashCode());
            }
            if (m.equals(LocalProxy.GET_PRIMARY_KEY)) {
                return BaseLocalContainerInvoker.this.jndiName;
            }
            if (m.equals(LocalProxy.GET_EJB_HOME)) {
                throw new UnsupportedOperationException();
            }
            if (m.equals(LocalProxy.IS_IDENTICAL)) {
                return this.isIdentical(args[0], BaseLocalContainerInvoker.this.jndiName);
            }
            return BaseLocalContainerInvoker.this.invoke(BaseLocalContainerInvoker.this.jndiName, m, args);
        }
    }
}

