/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.hsqldb.Embedded_Server;
import org.jboss.jdbc.HypersonicDatabaseMBean;
import org.jboss.util.ServiceMBeanSupport;

public class HypersonicDatabase
extends ServiceMBeanSupport
implements HypersonicDatabaseMBean {
    Embedded_Server embeddedDBServer;
    String name = "jboss";
    int port = 1476;
    boolean silent = true;
    boolean trace = false;

    public String getDatabase() {
        return this.name;
    }

    public String getName() {
        return "Hypersonic";
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSilent() {
        return this.silent;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setDatabase(String name) {
        this.name = name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void startService() throws Exception {
        File jbossHomeDir = new File(System.getProperty("jboss.home"));
        String dbPath = "db" + File.separator + "hypersonic" + File.separator + this.name;
        File dbName = new File(jbossHomeDir, dbPath);
        String[] args = new String[]{"-database", dbName.toString(), "-port", String.valueOf(this.port), "-silent", String.valueOf(this.silent), "-trace", String.valueOf(this.trace)};
        Throwable[] error = new Throwable[]{null};
        this.embeddedDBServer = new Embedded_Server();
        Throwable[] throwableArray = error;
        synchronized (throwableArray) {
            this.embeddedDBServer.runEmbedded(args, error);
            error.wait();
        }
        this.log.info("Database started");
    }

    public void stopService() {
        String cmd = "SHUTDOWN";
        String jdbcDriver = "org.hsqldb.jdbcDriver";
        String dbStrVersion_1_4 = "jdbc:HypersonicSQL:hsql://localhost:" + this.port;
        String dbStrVersion_1_6 = "jdbc:hsqldb:hsql://localhost:" + this.port;
        String user = "sa";
        String password = "";
        try {
            Connection connection = DriverManager.getConnection(dbStrVersion_1_6, user, password);
            Statement statement = connection.createStatement();
            statement.executeQuery(cmd);
            this.log.info("Database closed clean");
        }
        catch (Throwable e) {
            this.log.error("Database closed failed", e);
        }
        this.embeddedDBServer = null;
    }
}

