/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.jdbc.JdbcProviderMBean;
import org.jboss.util.ServiceMBeanSupport;

public class JdbcProvider
extends ServiceMBeanSupport
implements JdbcProviderMBean {
    public static final String OBJECT_NAME = ":service=JdbcProvider";
    String driverList = System.getProperty("jdbc.drivers");

    public String getDrivers() {
        return this.driverList;
    }

    public String getName() {
        return "JDBC provider";
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? new ObjectName(OBJECT_NAME) : name;
    }

    protected void initService() throws Exception {
        StringTokenizer drivers = new StringTokenizer(this.driverList, ",");
        while (drivers.hasMoreTokens()) {
            String driver = drivers.nextToken().trim();
            try {
                Class.forName(driver);
                this.log.info("Loaded JDBC-driver:" + driver);
            }
            catch (Exception e) {
                this.log.error("Could not load driver:" + driver, e);
            }
        }
    }

    public void setDrivers(String driverList) {
        this.driverList = driverList;
        System.setProperty("jdbc.drivers", driverList);
    }
}

