/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.XADataSource;
import org.jboss.jdbc.RawXADataSourceLoaderMBean;
import org.jboss.logging.Logger;
import org.jboss.logging.log4j.CategoryWriter;
import org.jboss.util.ServiceMBeanSupport;

public class RawXADataSourceLoader
extends ServiceMBeanSupport
implements RawXADataSourceLoaderMBean,
ObjectFactory {
    String name;
    String dataSourceClass;
    String properties;
    boolean loggingEnabled;
    static XADataSource vendorSource = null;
    static /* synthetic */ Class class$org$jboss$jdbc$RawXADataSourceLoader;
    static /* synthetic */ Class class$java$lang$String;

    public RawXADataSourceLoader() {
    }

    public RawXADataSourceLoader(String poolName, String xaDataSourceClass) {
        this.setPoolName(poolName);
        this.setDataSourceClass(xaDataSourceClass);
    }

    private void bind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.bind(n.get(0), val);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public String getDataSourceClass() {
        return this.dataSourceClass;
    }

    public boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public String getName() {
        return this.name;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        return vendorSource;
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName objectName) throws MalformedObjectNameException {
        return objectName == null ? new ObjectName(":service=RawXADataSource,name=" + this.getPoolName()) : objectName;
    }

    public String getPoolName() {
        return this.name;
    }

    public String getProperties() {
        return this.properties;
    }

    private static Properties parseProperties(String string) {
        Properties props = new Properties();
        StringTokenizer tokens = new StringTokenizer(string, ";=");
        while (tokens.hasMoreTokens()) {
            String key = tokens.nextToken();
            String value = tokens.nextToken();
            ((Hashtable)props).put(key, value);
        }
        return props;
    }

    public void setDataSourceClass(String clazz) {
        this.dataSourceClass = clazz.trim();
    }

    public void setLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    public void setPoolName(String name) {
        this.name = name.trim();
        String logName = String.valueOf((class$org$jboss$jdbc$RawXADataSourceLoader != null ? class$org$jboss$jdbc$RawXADataSourceLoader : (class$org$jboss$jdbc$RawXADataSourceLoader = RawXADataSourceLoader.class$("org.jboss.jdbc.RawXADataSourceLoader"))).getName()) + '.' + name;
        this.log = Logger.getLogger(logName);
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void startService() throws Exception {
        Class<?> cls = Class.forName(this.dataSourceClass);
        vendorSource = (XADataSource)cls.newInstance();
        cls = vendorSource.getClass();
        if (this.properties != null && this.properties.length() > 0) {
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(this.properties.getBytes("ISO-8859-1")));
            }
            catch (IOException ioe) {
                this.log.error("Couldn't convert properties string '" + this.properties + "' to Properties", ioe);
            }
            Iterator i = ((Hashtable)props).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                this.log.debug("Setting attribute '" + attributeName + "' to '" + attributeValue + "'");
                try {
                    Method setAttribute = cls.getMethod("set" + attributeName, class$java$lang$String != null ? class$java$lang$String : RawXADataSourceLoader.class$("java.lang.String"));
                    setAttribute.invoke((Object)vendorSource, attributeValue);
                }
                catch (NoSuchMethodException e) {
                    this.log.warn("No setter method for attribute '" + attributeName + "' - skipping", e);
                }
            }
        }
        CategoryWriter writer = this.loggingEnabled ? new CategoryWriter(this.log.getCategory()) : null;
        vendorSource.setLogWriter(writer);
        vendorSource.getXAConnection().close();
        this.bind(new InitialContext(), "java:/" + this.getPoolName(), new Reference(vendorSource.getClass().getName(), this.getClass().getName(), null));
        this.log.info("XA Data source " + this.getPoolName() + " bound to java:/" + this.getPoolName());
    }

    public void stopService() {
        try {
            String name = this.getPoolName();
            new InitialContext().unbind("java:/" + name);
            this.log.info("XA Data source " + name + " removed from JNDI");
            this.log.info("XA Data source " + name + " shut down");
        }
        catch (NamingException namingException) {}
    }
}

